/*
 * Decompiled with CFR 0.152.
 */
package org.coffeescript.codeinsight.inspections;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.inspections.JSUnusedLocalSymbolsInspection;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.coffeescript.CoffeeScriptUtil;
import org.coffeescript.CsBundle;
import org.coffeescript.codeinsight.inspections.CoffeeScriptInspectionGroupNames;
import org.coffeescript.lang.lexer.CoffeeScriptTokenTypes;
import org.coffeescript.lang.psi.CoffeeScriptForStatement;
import org.coffeescript.lang.psi.impl.CoffeeScriptClassImpl;
import org.jetbrains.annotations.NotNull;

public class CoffeeScriptUnusedLocalSymbolsInspection
extends JSUnusedLocalSymbolsInspection {
    private static Key<Map<ProblemsHolder, Map<PsiElement, ConcurrentMap<JSNamedElement, Boolean>>>> ourUnusedScopeMapKey = Key.create((String)"coffeeScript.unusedMap");

    @NotNull
    public String getDisplayName() {
        String string = CsBundle.message("inspection.unused_locals.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/coffeescript/codeinsight/inspections/CoffeeScriptUnusedLocalSymbolsInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = CoffeeScriptInspectionGroupNames.GENERAL_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/coffeescript/codeinsight/inspections/CoffeeScriptUnusedLocalSymbolsInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @NotNull
    public String[] getGroupPath() {
        String[] stringArray = new String[]{"CoffeeScript", this.getGroupDisplayName()};
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/coffeescript/codeinsight/inspections/CoffeeScriptUnusedLocalSymbolsInspection", "getGroupPath"));
        }
        return stringArray;
    }

    public boolean isSuppressedFor(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/coffeescript/codeinsight/inspections/CoffeeScriptUnusedLocalSymbolsInspection", "isSuppressedFor"));
        }
        return super.isSuppressedFor(element) || CoffeeScriptUtil.isInspectionSuppressedFor(element, this.getID());
    }

    protected boolean isLocallyDefined(JSNamedElement node, PsiElement scopeNode) {
        if (node instanceof CoffeeScriptClassImpl) {
            PsiElement grandParent;
            PsiElement parent = node.getParent();
            PsiElement psiElement = grandParent = parent != null ? parent.getParent() : null;
            if (grandParent instanceof JSFunction && parent.getLastChild() == node || parent instanceof JSReturnStatement) {
                return false;
            }
        }
        return super.isLocallyDefined(node, scopeNode);
    }

    private static boolean isPropertyAccessorAsParameter(JSNamedElement node) {
        PsiElement firstChild;
        return node instanceof JSParameter && (firstChild = node.getFirstChild()) != null && firstChild.getNode().getElementType() == CoffeeScriptTokenTypes.THIS;
    }

    private static boolean isForStatementVariable(JSNamedElement node) {
        PsiElement parent = node.getParent();
        PsiElement grandparent = parent != null ? parent.getParent() : null;
        return grandparent != null && grandparent instanceof CoffeeScriptForStatement;
    }

    protected void addUnusedElementIfNotUsedBefore(JSNamedElement node, ConcurrentMap<JSNamedElement, Boolean> unusedLocalDefsSet) {
        if (CoffeeScriptUnusedLocalSymbolsInspection.isPropertyAccessorAsParameter(node) || CoffeeScriptUnusedLocalSymbolsInspection.isForStatementVariable(node)) {
            return;
        }
        super.addUnusedElementIfNotUsedBefore(node, unusedLocalDefsSet);
    }

    protected Key<Map<ProblemsHolder, Map<PsiElement, ConcurrentMap<JSNamedElement, Boolean>>>> getUnsedScopeMapKey() {
        return ourUnusedScopeMapKey;
    }
}

