/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jboss.jbpm.diagram;

import com.intellij.diagram.DiagramColorManager;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdgeCreationPolicy;
import com.intellij.diagram.DiagramElementManager;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramNodeContentManager;
import com.intellij.diagram.DiagramPresentationModel;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.DiagramRelationshipManager;
import com.intellij.diagram.DiagramVfsResolver;
import com.intellij.diagram.DiagramVisibilityManager;
import com.intellij.diagram.EmptyDiagramVisibilityManager;
import com.intellij.diagram.actions.DiagramCreateNewElementAction;
import com.intellij.diagram.extras.DiagramExtras;
import com.intellij.jboss.jbpm.diagram.BpmnDiagramDataModel;
import com.intellij.jboss.jbpm.diagram.beans.wrappers.BpmnElementWrapper;
import com.intellij.jboss.jbpm.diagram.managers.BpmnDiagramColorManager;
import com.intellij.jboss.jbpm.diagram.managers.BpmnDiagramElementManager;
import com.intellij.jboss.jbpm.diagram.managers.BpmnDiagramExtras;
import com.intellij.jboss.jbpm.diagram.managers.BpmnDiagramVfsResolver;
import com.intellij.jboss.jbpm.diagram.managers.BpmnNodeContentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import icons.JbpmIcons;
import javax.swing.Icon;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BpmnDiagramProvider
extends DiagramProvider<BpmnElementWrapper> {
    @NonNls
    public static final String ID = "BPMN_2_0";
    private final DiagramVisibilityManager visibilityManager = new EmptyDiagramVisibilityManager();
    private final DiagramNodeContentManager nodeContentManager = new BpmnNodeContentManager();
    private final DiagramElementManager<BpmnElementWrapper> diagramElementManager = new BpmnDiagramElementManager();
    private final DiagramVfsResolver<BpmnElementWrapper> diagramVfsResolver = new BpmnDiagramVfsResolver();
    private final DiagramColorManager diagramColorManager = new BpmnDiagramColorManager();
    private final DiagramExtras<BpmnElementWrapper> diagramExtras = new BpmnDiagramExtras();

    @Pattern(value="[a-zA-Z0-9_-]*")
    public String getID() {
        return ID;
    }

    public DiagramVisibilityManager createVisibilityManager() {
        return this.visibilityManager;
    }

    public DiagramEdgeCreationPolicy<BpmnElementWrapper> getEdgeCreationPolicy() {
        return new DiagramEdgeCreationPolicy<BpmnElementWrapper>(){

            public boolean acceptSource(@NotNull DiagramNode<BpmnElementWrapper> source) {
                if (source == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/jboss/jbpm/diagram/BpmnDiagramProvider$1", "acceptSource"));
                }
                BpmnElementWrapper element = (BpmnElementWrapper)source.getIdentifyingElement();
                return true;
            }

            public boolean acceptTarget(@NotNull DiagramNode<BpmnElementWrapper> target) {
                if (target == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/jboss/jbpm/diagram/BpmnDiagramProvider$1", "acceptTarget"));
                }
                BpmnElementWrapper element = (BpmnElementWrapper)target.getIdentifyingElement();
                return true;
            }
        };
    }

    public DiagramNodeContentManager getNodeContentManager() {
        return this.nodeContentManager;
    }

    public DiagramElementManager<BpmnElementWrapper> getElementManager() {
        return this.diagramElementManager;
    }

    public DiagramVfsResolver<BpmnElementWrapper> getVfsResolver() {
        return this.diagramVfsResolver;
    }

    public DiagramRelationshipManager getRelationshipManager() {
        return DiagramRelationshipManager.NO_RELATIONSHIP_MANAGER;
    }

    public String getPresentableName() {
        return "BPMN 2.0 diagram";
    }

    public DiagramDataModel<BpmnElementWrapper> createDataModel(@NotNull Project project, @Nullable BpmnElementWrapper element, @Nullable VirtualFile file, DiagramPresentationModel presentationModel) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/jboss/jbpm/diagram/BpmnDiagramProvider", "createDataModel"));
        }
        return new BpmnDiagramDataModel(project, this, element, presentationModel);
    }

    public Icon getActionIcon(boolean isPopup) {
        return JbpmIcons.Bpmn.Process;
    }

    public String getActionName(boolean isPopup) {
        return !isPopup ? "BPMN 2.0 Designer" : "BPMN 2.0 Overview";
    }

    public DiagramColorManager getColorManager() {
        return this.diagramColorManager;
    }

    @NotNull
    public DiagramExtras<BpmnElementWrapper> getExtras() {
        DiagramExtras<BpmnElementWrapper> diagramExtras = this.diagramExtras;
        if (diagramExtras == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jboss/jbpm/diagram/BpmnDiagramProvider", "getExtras"));
        }
        return diagramExtras;
    }

    public DiagramCreateNewElementAction<BpmnElementWrapper, ?>[] getCreateNewActions() {
        return new DiagramCreateNewElementAction[0];
    }
}

