/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jboss.jbpm.highlighting;

import com.intellij.jboss.jbpm.model.xml.bpmn20.TDataOutput;
import com.intellij.jboss.jbpm.model.xml.bpmn20.TInputOutputSpecification;
import com.intellij.jboss.jbpm.model.xml.bpmn20.TOutputSet;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import java.util.List;

public class DataOutputIsReferencedInspection {
    private final DomElement myElement;
    private final DomElementAnnotationHolder myHolder;
    private final DomHighlightingHelper myHelper;

    public DataOutputIsReferencedInspection(DomElement element, DomElementAnnotationHolder holder, DomHighlightingHelper helper) {
        this.myElement = element;
        this.myHolder = holder;
        this.myHelper = helper;
    }

    public void check() {
        if (!this.myElement.isValid() || !((TDataOutput)this.myElement).getId().isValid()) {
            return;
        }
        DomElement ioSpecDomElement = this.myElement.getParent();
        if (ioSpecDomElement == null || !TInputOutputSpecification.class.equals((Object)ioSpecDomElement.getDomElementType())) {
            return;
        }
        List<TOutputSet> sets = ((TInputOutputSpecification)ioSpecDomElement).getOutputSets();
        for (TOutputSet set : sets) {
            List<GenericDomValue<TDataOutput>> refses = set.getDataOutputRefses();
            for (GenericDomValue<TDataOutput> refse : refses) {
                TDataOutput input;
                if (!refse.isValid() || (input = (TDataOutput)refse.getValue()) == null || !input.equals(this.myElement)) continue;
                return;
            }
        }
        this.myHolder.createProblem(this.myElement, HighlightSeverity.ERROR, "Should be referenced by any dataOutputRefs");
    }
}

