/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot;

import com.intellij.execution.RunManager;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.internal.statistic.AbstractApplicationUsagesCollector;
import com.intellij.internal.statistic.CollectUsagesException;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.model.properties.jam.ConfigurationProperties;
import com.intellij.spring.boot.model.properties.jam.NestedConfigurationProperty;
import com.intellij.spring.boot.run.SpringBootApplicationConfigurationTypeBase;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SpringBootUsagesCollector
extends AbstractApplicationUsagesCollector {
    @NotNull
    public Set<UsageDescriptor> getProjectUsages(@NotNull Project project) throws CollectUsagesException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/boot/SpringBootUsagesCollector", "getProjectUsages"));
        }
        HashSet usages = new HashSet();
        ApplicationManager.getApplication().runReadAction(() -> SpringBootUsagesCollector.lambda$getProjectUsages$0(project, (Set)usages));
        HashSet hashSet = usages;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/SpringBootUsagesCollector", "getProjectUsages"));
        }
        return hashSet;
    }

    @NotNull
    public GroupDescriptor getGroupId() {
        GroupDescriptor groupDescriptor = GroupDescriptor.create((String)"Spring Boot");
        if (groupDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/SpringBootUsagesCollector", "getGroupId"));
        }
        return groupDescriptor;
    }

    private static void recordConfigFileUsages(Set<UsageDescriptor> usages, Project project, GlobalSearchScope scope, String configFileName) {
        Collection files = FilenameIndex.getVirtualFilesByName((Project)project, (String)configFileName, (GlobalSearchScope)scope);
        if (!files.isEmpty()) {
            usages.add(new UsageDescriptor(configFileName, files.size()));
        }
    }

    private static /* synthetic */ void lambda$getProjectUsages$0(@NotNull Project project, Set usages) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/boot/SpringBootUsagesCollector", "lambda$getProjectUsages$0"));
        }
        if (!SpringBootLibraryUtil.hasSpringBootLibrary(project)) {
            return;
        }
        int springBootModulesPerProject = 0;
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            List configurationPropertiesMethods;
            if (!SpringBootLibraryUtil.hasSpringBootLibrary(module)) continue;
            ++springBootModulesPerProject;
            if (SpringBootLibraryUtil.hasDevtools(module)) {
                usages.add(new UsageDescriptor("SpringBootDevTools", 1));
            }
            GlobalSearchScope scope = module.getModuleScope(false);
            SpringBootUsagesCollector.recordConfigFileUsages(usages, project, scope, "application.properties");
            SpringBootUsagesCollector.recordConfigFileUsages(usages, project, scope, "bootstrap.properties");
            SpringBootUsagesCollector.recordConfigFileUsages(usages, project, scope, "additional-spring-configuration-metadata.json");
            SpringBootUsagesCollector.recordConfigFileUsages(usages, project, scope, "application.yml");
            SpringBootUsagesCollector.recordConfigFileUsages(usages, project, scope, "application.yaml");
            SpringBootUsagesCollector.recordConfigFileUsages(usages, project, scope, "bootstrap.yml");
            SpringBootUsagesCollector.recordConfigFileUsages(usages, project, scope, "bootstrap.yaml");
            List configurationProperties = JamService.getJamService((Project)project).getJamClassElements((JamMemberMeta)ConfigurationProperties.CLASS_META, "org.springframework.boot.context.properties.ConfigurationProperties", scope);
            if (!configurationProperties.isEmpty()) {
                usages.add(new UsageDescriptor("ConfigurationProperties_" + configurationProperties.size(), 1));
                List nestedConfigurationProperties = JamService.getJamService((Project)project).getJamFieldElements((JamMemberMeta)NestedConfigurationProperty.FIELD_META, "org.springframework.boot.context.properties.NestedConfigurationProperty", scope);
                if (!nestedConfigurationProperties.isEmpty()) {
                    usages.add(new UsageDescriptor("NestedConfigurationProperty_" + configurationProperties.size(), 1));
                }
            }
            if ((configurationPropertiesMethods = JamService.getJamService((Project)project).getJamMethodElements((JamMemberMeta)ConfigurationProperties.Method.METHOD_META, "org.springframework.boot.context.properties.ConfigurationProperties", scope)).isEmpty()) continue;
            usages.add(new UsageDescriptor("ConfigurationProperties_Methods_" + configurationPropertiesMethods.size(), 1));
        }
        usages.add(new UsageDescriptor("SpringBootModulesPerProject_" + springBootModulesPerProject, 1));
        List springBootRunConfigurations = RunManager.getInstance((Project)project).getConfigurationsList((ConfigurationType)SpringBootApplicationConfigurationTypeBase.getInstance());
        usages.add(new UsageDescriptor("RunConfigsPerProject_" + springBootRunConfigurations.size(), 1));
    }
}

