/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.config.hints;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.spring.boot.application.config.hints.HintReferenceBase;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RegExReferenceProvider
extends PsiReferenceProvider {
    private final Pattern myPattern;

    public RegExReferenceProvider(String regExPattern) {
        this.myPattern = Pattern.compile(regExPattern);
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/boot/application/config/hints/RegExReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/boot/application/config/hints/RegExReferenceProvider", "getReferencesByElement"));
        }
        PsiReference[] psiReferenceArray = new PsiReference[]{new HintReferenceBase(element){

            @Override
            @Nullable
            protected PsiElement doResolve() {
                if (RegExReferenceProvider.this.myPattern.matcher(this.getValue()).matches()) {
                    return this.getElement();
                }
                return null;
            }

            @NotNull
            public Object[] getVariants() {
                if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/config/hints/RegExReferenceProvider$1", "getVariants"));
                }
                return ArrayUtil.EMPTY_OBJECT_ARRAY;
            }

            @Override
            @NotNull
            public String getUnresolvedMessagePattern() {
                String string = "Value ''{0}'' does not match pattern ''" + RegExReferenceProvider.this.myPattern + "''";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/config/hints/RegExReferenceProvider$1", "getUnresolvedMessagePattern"));
                }
                return string;
            }
        }};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/config/hints/RegExReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }
}

