/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.metadata;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonReader;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonPsiUtil;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.boot.application.metadata.ConfigKeyDeclarationPsiElement;
import com.intellij.spring.boot.application.metadata.ConfigKeyDocumentationProviderBase;
import com.intellij.spring.boot.application.metadata.RelaxedNames;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKey;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKeyImpl;
import com.intellij.spring.boot.application.metadata.additional.SpringBootAdditionalConfigUtils;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.text.CharSequenceReader;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SpringBootConfigurationMetadataParser {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.spring.boot.application.metadata.SpringBootConfigurationMetadataParser");
    @Nullable
    private final Module myLocalModule;
    @Nullable
    private final JsonFile myJsonPsiFile;
    @Nullable
    private final File myLocalJsonFile;
    private final String myLibraryName;
    private final Caching myCaching;
    private final NotNullLazyValue<Map<String, PsiElement>> myAdditionalConfigTargets;

    SpringBootConfigurationMetadataParser(@NotNull JsonFile jsonPsiFile) {
        if (jsonPsiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsonPsiFile", "com/intellij/spring/boot/application/metadata/SpringBootConfigurationMetadataParser", "<init>"));
        }
        this.myAdditionalConfigTargets = new NotNullLazyValue<Map<String, PsiElement>>(){

            @NotNull
            protected Map<String, PsiElement> compute() {
                if (SpringBootConfigurationMetadataParser.this.myLocalModule == null) {
                    Map<String, PsiElement> map = Collections.emptyMap();
                    if (map == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/SpringBootConfigurationMetadataParser$1", "compute"));
                    }
                    return map;
                }
                HashMap<String, PsiElement> additionalConfigTargets = new HashMap<String, PsiElement>();
                SpringBootAdditionalConfigUtils utils = new SpringBootAdditionalConfigUtils(SpringBootConfigurationMetadataParser.this.myLocalModule);
                utils.processAdditionalMetadataFiles((Processor<JsonFile>)((Processor)file -> {
                    com.intellij.json.psi.JsonObject rootObject = (com.intellij.json.psi.JsonObject)ObjectUtils.tryCast((Object)file.getTopLevelValue(), com.intellij.json.psi.JsonObject.class);
                    if (rootObject == null) {
                        return true;
                    }
                    JsonProperty propertiesRoot = rootObject.findProperty("properties");
                    if (propertiesRoot == null) {
                        return true;
                    }
                    JsonArray propertiesArray = (JsonArray)ObjectUtils.tryCast((Object)propertiesRoot.getValue(), JsonArray.class);
                    if (propertiesArray == null) {
                        return true;
                    }
                    for (JsonValue value : propertiesArray.getValueList()) {
                        String key;
                        JsonStringLiteral nameValue;
                        JsonProperty nameProperty;
                        com.intellij.json.psi.JsonObject object = (com.intellij.json.psi.JsonObject)ObjectUtils.tryCast((Object)value, com.intellij.json.psi.JsonObject.class);
                        if (object == null || (nameProperty = object.findProperty("name")) == null || (nameValue = (JsonStringLiteral)ObjectUtils.tryCast((Object)nameProperty.getValue(), JsonStringLiteral.class)) == null || !StringUtil.isNotEmpty((String)(key = JsonPsiUtil.stripQuotes((String)nameValue.getValue())))) continue;
                        additionalConfigTargets.put(key, (PsiElement)nameProperty);
                    }
                    return true;
                }));
                HashMap<String, PsiElement> hashMap = additionalConfigTargets;
                if (hashMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/SpringBootConfigurationMetadataParser$1", "compute"));
                }
                return hashMap;
            }
        };
        this.myJsonPsiFile = jsonPsiFile;
        this.myLocalJsonFile = null;
        this.myLocalModule = null;
        this.myLibraryName = SpringBootConfigurationMetadataParser.getLibraryName(jsonPsiFile);
        this.myCaching = new Caching(jsonPsiFile.getResolveScope());
    }

    SpringBootConfigurationMetadataParser(@NotNull Module module, @NotNull File localJsonFile) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/boot/application/metadata/SpringBootConfigurationMetadataParser", "<init>"));
        }
        if (localJsonFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localJsonFile", "com/intellij/spring/boot/application/metadata/SpringBootConfigurationMetadataParser", "<init>"));
        }
        this.myAdditionalConfigTargets = new /* invalid duplicate definition of identical inner class */;
        this.myLocalModule = module;
        this.myJsonPsiFile = null;
        this.myLocalJsonFile = localJsonFile;
        this.myLibraryName = this.myLocalModule.getName();
        this.myCaching = new Caching(module.getModuleRuntimeScope(false));
    }

    private static String getLibraryName(@NotNull JsonFile jsonFile) {
        if (jsonFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsonFile", "com/intellij/spring/boot/application/metadata/SpringBootConfigurationMetadataParser", "getLibraryName"));
        }
        OrderEntry libraryEntry = LibraryUtil.findLibraryEntry((VirtualFile)jsonFile.getVirtualFile(), (Project)jsonFile.getProject());
        if (libraryEntry instanceof LibraryOrderEntry) {
            String libraryName = ((LibraryOrderEntry)libraryEntry).getLibraryName();
            if (libraryName != null) {
                return libraryName;
            }
            VirtualFile jarRoot = JarFileSystem.getInstance().getLocalByEntry(jsonFile.getVirtualFile());
            if (jarRoot != null) {
                return jarRoot.getName();
            }
        }
        return "<unknown>";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean processKeys(@NotNull Module module, @NotNull Processor<SpringBootApplicationMetaConfigKey> processor) {
        JsonObject rootObject;
        JsonElement parse;
        String path;
        JsonReader reader;
        block15: {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/boot/application/metadata/SpringBootConfigurationMetadataParser", "processKeys"));
            }
            if (processor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/spring/boot/application/metadata/SpringBootConfigurationMetadataParser", "processKeys"));
            }
            reader = null;
            path = null;
            if (this.myJsonPsiFile != null) {
                path = this.myJsonPsiFile.getVirtualFile().getPath();
                String content = VfsUtilCore.loadText((VirtualFile)this.myJsonPsiFile.getVirtualFile());
                reader = new JsonReader((Reader)new CharSequenceReader((CharSequence)content));
            } else {
                assert (this.myLocalJsonFile != null);
                path = this.myLocalJsonFile.getPath();
                reader = new JsonReader((Reader)new BufferedReader(new FileReader(this.myLocalJsonFile)));
            }
            reader.setLenient(true);
            parse = new JsonParser().parse(reader);
            if (parse.isJsonObject()) break block15;
            boolean bl = true;
            StreamUtil.closeStream((Closeable)reader);
            return bl;
        }
        try {
            rootObject = parse.getAsJsonObject();
        }
        catch (Throwable e) {
            try {
                LOG.error("Error parsing Spring Boot metadata JSON from " + path, e);
                boolean bl = true;
                return bl;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                StreamUtil.closeStream(reader);
            }
        }
        StreamUtil.closeStream((Closeable)reader);
        JsonElement propertiesElement = rootObject.get("properties");
        if (propertiesElement == null) {
            return true;
        }
        com.google.gson.JsonArray properties = propertiesElement.getAsJsonArray();
        Map<String, SpringBootApplicationMetaConfigKey.ItemHint> hints = SpringBootConfigurationMetadataParser.getItemHints(rootObject);
        for (JsonElement element : properties) {
            SpringBootApplicationMetaConfigKey.ItemHint keyHint;
            SpringBootApplicationMetaConfigKey.ItemHint valueHint;
            JsonObject property = element.getAsJsonObject();
            String configKeyName = SpringBootConfigurationMetadataParser.getStringLiteral(property, "name");
            if (StringUtil.isEmptyOrSpaces((String)configKeyName)) continue;
            String typeLiteral = SpringBootConfigurationMetadataParser.getStringLiteral(property, "type");
            String finalType = Comparing.strEqual((String)typeLiteral, (String)"java.util.Properties") ? "java.util.Map<java.lang.String,java.lang.String>" : typeLiteral;
            Pair typeWithAccess = (Pair)this.myCaching.myCachedTypes.get(finalType);
            PsiType type = (PsiType)typeWithAccess.getFirst();
            SpringBootApplicationMetaConfigKey.AccessType accessType = (SpringBootApplicationMetaConfigKey.AccessType)typeWithAccess.getSecond();
            if (accessType == SpringBootApplicationMetaConfigKey.AccessType.MAP) {
                valueHint = hints.get(configKeyName + ".values");
                keyHint = hints.get(configKeyName + ".keys");
            } else {
                valueHint = hints.get(configKeyName);
                keyHint = SpringBootApplicationMetaConfigKey.ItemHint.NONE;
            }
            PsiElement declaration = this.getDeclaration(property, configKeyName, type);
            if (declaration == null) continue;
            declaration.putUserData(ConfigKeyDocumentationProviderBase.CONFIG_KEY_DECLARATION_MODULE, (Object)module);
            SpringBootApplicationMetaConfigKeyImpl key = new SpringBootApplicationMetaConfigKeyImpl(declaration, configKeyName, SpringBootConfigurationMetadataParser.getDescription(property), SpringBootConfigurationMetadataParser.getValueAsString(property, "defaultValue"), SpringBootConfigurationMetadataParser.getDeprecation(property), type, accessType, (SpringBootApplicationMetaConfigKey.ItemHint)ObjectUtils.notNull((Object)valueHint, (Object)SpringBootApplicationMetaConfigKey.ItemHint.NONE), (SpringBootApplicationMetaConfigKey.ItemHint)ObjectUtils.notNull((Object)keyHint, (Object)SpringBootApplicationMetaConfigKey.ItemHint.NONE));
            if (processor.process((Object)key)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static String getValueAsString(JsonObject object, String propertyName) {
        JsonElement propertyElement = object.get(propertyName);
        if (propertyElement == null) {
            return null;
        }
        if (propertyElement.isJsonPrimitive()) {
            return propertyElement.getAsJsonPrimitive().getAsString();
        }
        if (!propertyElement.isJsonArray()) {
            return null;
        }
        com.google.gson.JsonArray array = propertyElement.getAsJsonArray();
        SmartList valueList = new SmartList();
        for (JsonElement jsonValue : array) {
            if (!jsonValue.isJsonPrimitive()) continue;
            valueList.add(StringUtil.wrapWithDoubleQuote((String)jsonValue.getAsJsonPrimitive().getAsString()));
        }
        return "[" + StringUtil.join((Collection)valueList, (String)", ") + "]";
    }

    @Nullable
    private PsiElement getDeclaration(JsonObject entry, String configKeyName, PsiType type) {
        String sourceTypeText = SpringBootConfigurationMetadataParser.getStringLiteral(entry, "sourceType");
        if (StringUtil.isEmpty((String)sourceTypeText)) {
            return this.getFallbackDeclaration(configKeyName, type);
        }
        PsiClass sourceTypeClass = (PsiClass)this.myCaching.myCachedClass.get(sourceTypeText);
        if (sourceTypeClass == null) {
            return this.getFallbackDeclaration(configKeyName, type);
        }
        return new ConfigKeyDeclarationPsiElement(this.myLibraryName, (PsiElement)sourceTypeClass, SpringBootConfigurationMetadataParser.getNavigationTarget(sourceTypeClass, configKeyName), configKeyName, sourceTypeText, type);
    }

    @Nullable
    private PsiElement getFallbackDeclaration(String configKeyName, PsiType type) {
        PsiElement additionalTarget = this.getAdditionalTarget(configKeyName);
        if (this.myJsonPsiFile != null) {
            return new ConfigKeyDeclarationPsiElement(this.myLibraryName, (PsiElement)this.myJsonPsiFile, additionalTarget, configKeyName, configKeyName, type);
        }
        if (additionalTarget == null) {
            return null;
        }
        return new ConfigKeyDeclarationPsiElement(this.myLibraryName, additionalTarget, additionalTarget, configKeyName, configKeyName, type);
    }

    @Nullable
    private PsiElement getAdditionalTarget(String configKeyName) {
        PsiElement additionalTarget = (PsiElement)((Map)this.myAdditionalConfigTargets.getValue()).get(configKeyName);
        return additionalTarget != null ? additionalTarget : this.myJsonPsiFile;
    }

    @NotNull
    private static PsiElement getNavigationTarget(@NotNull PsiClass sourceTypeClass, String configKeyName) {
        if (sourceTypeClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceTypeClass", "com/intellij/spring/boot/application/metadata/SpringBootConfigurationMetadataParser", "getNavigationTarget"));
        }
        String propertyName = RelaxedNames.dashedPropertyNameToCamelCase(configKeyName);
        PsiMethod setter = PropertyUtil.findPropertySetter((PsiClass)sourceTypeClass, (String)propertyName, (boolean)false, (boolean)false);
        if (setter != null) {
            PsiMethod psiMethod = setter;
            if (psiMethod == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/SpringBootConfigurationMetadataParser", "getNavigationTarget"));
            }
            return psiMethod;
        }
        PsiMethod getter = PropertyUtil.findPropertyGetter((PsiClass)sourceTypeClass, (String)propertyName, (boolean)false, (boolean)false);
        Object object = getter != null ? getter : sourceTypeClass;
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/SpringBootConfigurationMetadataParser", "getNavigationTarget"));
        }
        return object;
    }

    private static SpringBootApplicationMetaConfigKey.DescriptionText getDescription(JsonObject property) {
        String descriptionText = SpringBootConfigurationMetadataParser.getStringLiteral(property, "description");
        if (descriptionText == null) {
            return SpringBootApplicationMetaConfigKey.DescriptionText.NONE;
        }
        return new SpringBootApplicationMetaConfigKey.DescriptionText(descriptionText);
    }

    private static SpringBootApplicationMetaConfigKey.Deprecation getDeprecation(JsonObject property) {
        JsonObject deprecationObject = property.getAsJsonObject("deprecation");
        if (deprecationObject != null) {
            String reasonText = SpringBootConfigurationMetadataParser.getStringLiteral(deprecationObject, "reason");
            SpringBootApplicationMetaConfigKey.DescriptionText reason = reasonText == null ? SpringBootApplicationMetaConfigKey.DescriptionText.NONE : new SpringBootApplicationMetaConfigKey.DescriptionText(reasonText);
            String replacement = SpringBootConfigurationMetadataParser.getStringLiteral(deprecationObject, "replacement");
            return new SpringBootApplicationMetaConfigKey.Deprecation(reason, replacement);
        }
        JsonPrimitive deprecatedProperty = property.getAsJsonPrimitive("deprecated");
        if (deprecatedProperty != null && deprecatedProperty.getAsBoolean()) {
            return SpringBootApplicationMetaConfigKey.Deprecation.DEPRECATED_WITHOUT_REASON;
        }
        return SpringBootApplicationMetaConfigKey.Deprecation.NOT_DEPRECATED;
    }

    private static Map<String, SpringBootApplicationMetaConfigKey.ItemHint> getItemHints(JsonObject rootObject) {
        JsonElement hintsElement = rootObject.get("hints");
        if (hintsElement == null) {
            return Collections.emptyMap();
        }
        HashMap<String, SpringBootApplicationMetaConfigKey.ItemHint> itemHintsMap = new HashMap<String, SpringBootApplicationMetaConfigKey.ItemHint>();
        for (JsonElement value : hintsElement.getAsJsonArray()) {
            JsonObject entry = value.getAsJsonObject();
            String nameValue = SpringBootConfigurationMetadataParser.getStringLiteral(entry, "name");
            if (nameValue == null) continue;
            itemHintsMap.put(nameValue, SpringBootConfigurationMetadataParser.createItemHint(entry));
        }
        return itemHintsMap;
    }

    private static SpringBootApplicationMetaConfigKey.ItemHint createItemHint(JsonObject entry) {
        List<SpringBootApplicationMetaConfigKey.ValueProvider> providers = SpringBootConfigurationMetadataParser.getItemHintProviders(entry);
        List<SpringBootApplicationMetaConfigKey.ValueHint> values = SpringBootConfigurationMetadataParser.getItemHintValues(entry);
        return new SpringBootApplicationMetaConfigKey.ItemHint(providers, values);
    }

    private static List<SpringBootApplicationMetaConfigKey.ValueProvider> getItemHintProviders(JsonObject entry) {
        JsonElement providersObject = entry.get("providers");
        if (providersObject == null) {
            return Collections.emptyList();
        }
        List providers = ContainerUtil.newSmartList();
        for (JsonElement arrayValue : providersObject.getAsJsonArray()) {
            JsonObject providerObject;
            String name;
            if (!arrayValue.isJsonObject() || (name = SpringBootConfigurationMetadataParser.getStringLiteral(providerObject = arrayValue.getAsJsonObject(), "name")) == null) continue;
            Map<String, String> parameters = SpringBootConfigurationMetadataParser.getItemHintProviderParameters(providerObject);
            providers.add(new SpringBootApplicationMetaConfigKey.ValueProvider(name, parameters));
        }
        return providers;
    }

    private static Map<String, String> getItemHintProviderParameters(JsonObject entry) {
        JsonElement parametersProperty = entry.get("parameters");
        if (parametersProperty == null || !parametersProperty.isJsonObject()) {
            return Collections.emptyMap();
        }
        JsonObject parametersObject = parametersProperty.getAsJsonObject();
        LinkedHashMap parameters = ContainerUtil.newLinkedHashMap();
        for (Map.Entry parameterProperty : parametersObject.entrySet()) {
            JsonElement value = (JsonElement)parameterProperty.getValue();
            if (value == null || !value.isJsonPrimitive()) continue;
            JsonPrimitive primitive = value.getAsJsonPrimitive();
            parameters.put(parameterProperty.getKey(), primitive.getAsString());
        }
        return parameters;
    }

    private static List<SpringBootApplicationMetaConfigKey.ValueHint> getItemHintValues(JsonObject entry) {
        JsonElement valuesObject = entry.get("values");
        if (valuesObject == null || !valuesObject.isJsonArray()) {
            return Collections.emptyList();
        }
        List values = ContainerUtil.newSmartList();
        for (JsonElement arrayValue : valuesObject.getAsJsonArray()) {
            JsonObject valueObject;
            String value;
            if (!arrayValue.isJsonObject() || (value = SpringBootConfigurationMetadataParser.getStringLiteral(valueObject = arrayValue.getAsJsonObject(), "value")) == null) continue;
            values.add(new SpringBootApplicationMetaConfigKey.ValueHint(value, SpringBootConfigurationMetadataParser.getDescription(valueObject)));
        }
        return values;
    }

    @Nullable
    private static String getStringLiteral(JsonObject object, String propertyName) {
        JsonElement property = object.get(propertyName);
        return property != null ? property.getAsString() : null;
    }

    private static class Caching {
        private static final Pair<PsiType, SpringBootApplicationMetaConfigKey.AccessType> DUMMY_TYPE = Pair.create((Object)PsiType.NULL, (Object)SpringBootApplicationMetaConfigKey.AccessType.NORMAL);
        private final JavaPsiFacade myJavaPsiFacade;
        private final PsiElementFactory myElementFactory;
        private final GlobalSearchScope mySearchScope;
        private final Map<String, Pair<PsiType, SpringBootApplicationMetaConfigKey.AccessType>> myCachedTypes = new FactoryMap<String, Pair<PsiType, SpringBootApplicationMetaConfigKey.AccessType>>(){

            @Nullable
            protected Pair<PsiType, SpringBootApplicationMetaConfigKey.AccessType> create(String key) {
                if (key == null) {
                    return DUMMY_TYPE;
                }
                try {
                    PsiType psiType = myElementFactory.createTypeFromText(key.replace('$', '.'), null);
                    return Pair.create((Object)psiType, (Object)Caching.getAccessType(psiType));
                }
                catch (IncorrectOperationException e) {
                    return DUMMY_TYPE;
                }
            }
        };
        private final Map<String, PsiClass> myCachedClass = new FactoryMap<String, PsiClass>(){

            @Nullable
            protected PsiClass create(String key) {
                return myJavaPsiFacade.findClass(key.replace('$', '.'), mySearchScope);
            }
        };

        private Caching(GlobalSearchScope scope) {
            this.myJavaPsiFacade = JavaPsiFacade.getInstance((Project)scope.getProject());
            this.myElementFactory = this.myJavaPsiFacade.getElementFactory();
            this.mySearchScope = scope;
        }

        private static SpringBootApplicationMetaConfigKey.AccessType getAccessType(PsiType type) {
            if (type instanceof PsiArrayType) {
                return SpringBootApplicationMetaConfigKey.AccessType.INDEXED;
            }
            PsiClass resolve = PsiTypesUtil.getPsiClass((PsiType)type);
            if (resolve == null) {
                return SpringBootApplicationMetaConfigKey.AccessType.NORMAL;
            }
            if (resolve.isEnum()) {
                return SpringBootApplicationMetaConfigKey.AccessType.NORMAL;
            }
            String fqn = resolve.getQualifiedName();
            if ("java.util.Map".equals(fqn)) {
                return SpringBootApplicationMetaConfigKey.AccessType.MAP;
            }
            if ("java.util.List".equals(fqn)) {
                return SpringBootApplicationMetaConfigKey.AccessType.INDEXED;
            }
            return SpringBootApplicationMetaConfigKey.AccessType.NORMAL;
        }
    }
}

