/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.metadata;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.editor.SpringEditorNotificationPanel;
import com.intellij.ui.JBColor;
import com.intellij.ui.LightColors;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashSet;
import icons.SpringBootApiIcons;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SpringBootMetadataNotificationPanel
extends SpringEditorNotificationPanel {
    private final boolean myHasAnnotationProcessor;

    SpringBootMetadataNotificationPanel(@NotNull Module module, @NotNull PsiFile psiFile) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/boot/application/metadata/SpringBootMetadataNotificationPanel", "<init>"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/spring/boot/application/metadata/SpringBootMetadataNotificationPanel", "<init>"));
        }
        this.myHasAnnotationProcessor = SpringBootMetadataNotificationPanel.hasAnnotationProcessor(module);
        this.icon(SpringBootApiIcons.SpringBoot);
        Object object = this.myBackgroundColor = this.myHasAnnotationProcessor ? JBColor.lightGray : LightColors.RED;
        if (this.myHasAnnotationProcessor) {
            this.text("Re-run Spring Boot Configuration Annotation Processor to update generated metadata");
        } else {
            this.text("Spring Boot Configuration Annotation Processor not found in classpath");
        }
        this.createActionLabel("Open Documentation...", () -> {
            if (psiFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/spring/boot/application/metadata/SpringBootMetadataNotificationPanel", "lambda$new$0"));
            }
            String version = SpringBootMetadataNotificationPanel.detectSpringBootVersion(psiFile);
            BrowserUtil.browse((String)("http://docs.spring.io/spring-boot/docs/" + version + "/reference/html/configuration-metadata.html#configuration-metadata-annotation-processor"));
        });
        this.installOpenEditorSettingsButton(psiFile.getProject());
    }

    private static boolean hasAnnotationProcessor(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/boot/application/metadata/SpringBootMetadataNotificationPanel", "hasAnnotationProcessor"));
        }
        HashSet allModules = new HashSet();
        ModuleUtilCore.getDependencies((Module)module, (Set)allModules);
        return !ContainerUtil.process((Iterable)allModules, module1 -> !SpringBootLibraryUtil.hasConfigurationMetadataAnnotationProcessor(module1));
    }

    @Nullable
    private static String detectSpringBootVersion(PsiFile psiFile) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile);
        if (module == null) {
            return "current";
        }
        return SpringBootLibraryUtil.getVersionFromJar(module);
    }
}

