/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.metadata.additional;

import com.intellij.json.psi.JsonFile;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.Processor;
import java.util.List;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class SpringBootAdditionalConfigUtils {
    private final Module myModule;
    private final List<VirtualFile> myResourceRoots;

    public SpringBootAdditionalConfigUtils(Module module) {
        this.myModule = module;
        this.myResourceRoots = ModuleRootManager.getInstance((Module)module).getSourceRoots((JpsModuleSourceRootType)JavaResourceRootType.RESOURCE);
    }

    boolean hasResourceRoots() {
        return !this.myResourceRoots.isEmpty();
    }

    List<VirtualFile> getResourceRoots() {
        return this.myResourceRoots;
    }

    public boolean processAdditionalMetadataFiles(Processor<JsonFile> processor) {
        for (VirtualFile root : this.myResourceRoots) {
            PsiFile psiFile;
            VirtualFile vf = root.findFileByRelativePath("META-INF/additional-spring-configuration-metadata.json");
            if (vf == null || !((psiFile = PsiManager.getInstance((Project)this.myModule.getProject()).findFile(vf)) instanceof JsonFile) || processor.process((Object)((JsonFile)psiFile))) continue;
            return false;
        }
        return true;
    }
}

