/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.properties;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesInspectionBase;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.lang.properties.psi.impl.PropertyKeyImpl;
import com.intellij.lang.properties.psi.impl.PropertyValueImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.spring.boot.application.config.SpringBootConfigFileHighlightingUtil;
import com.intellij.spring.boot.application.metadata.MetaConfigKeyReference;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKey;
import com.intellij.spring.boot.application.properties.MapKeyPropertyEnumReferenceSet;
import com.intellij.spring.boot.application.properties.SpringBootApplicationPropertiesUtil;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBootApplicationPropertiesInspection
extends PropertiesInspectionBase {
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesInspection", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesInspection", "checkFile"));
        }
        if (!(file instanceof PropertiesFile)) {
            return null;
        }
        PropertiesFile propertiesFile = (PropertiesFile)file;
        if (!SpringBootApplicationPropertiesUtil.isApplicationPropertiesFile(propertiesFile)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (!SpringBootLibraryUtil.isAtLeastVersion(module, SpringBootLibraryUtil.SpringBootVersion.VERSION_1_2_0)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        ProblemsHolder holder = new ProblemsHolder(manager, file, isOnTheFly);
        SpringBootConfigFileHighlightingUtil configFileHighlightingUtil = new SpringBootConfigFileHighlightingUtil(holder);
        for (IProperty iProperty : propertiesFile.getProperties()) {
            PropertyValueImpl valueElement;
            PropertyImpl property;
            PropertyKeyImpl propertyKey;
            ProgressManager.checkCanceled();
            if (!(iProperty instanceof PropertyImpl) || (propertyKey = SpringBootApplicationPropertiesInspection.getPropertyKey(property = (PropertyImpl)iProperty)) == null) continue;
            SpringBootApplicationMetaConfigKey configKey = MetaConfigKeyReference.getResolvedMetaConfigKey((PsiElement)propertyKey);
            if (configKey == null) {
                PsiReference[] keyName = property.getName();
                configFileHighlightingUtil.highlightUnresolvedConfigKey((PsiElement)propertyKey, (String)keyName);
                continue;
            }
            if (configKey.getDeprecation() != SpringBootApplicationMetaConfigKey.Deprecation.NOT_DEPRECATED) {
                configFileHighlightingUtil.highlightDeprecatedConfigKey((PsiElement)propertyKey, configKey, SpringBootApplicationPropertiesInspection.getDeprecationFix(property, configKey));
            }
            if (configKey.isAccessType(SpringBootApplicationMetaConfigKey.AccessType.MAP_GROUP) && propertyKey.getText().length() == configKey.getName().length()) {
                holder.registerProblem((PsiElement)propertyKey, "Missing map key", ProblemHighlightType.ERROR, new LocalQuickFix[0]);
                continue;
            }
            if (configKey.isAccessType(new SpringBootApplicationMetaConfigKey.AccessType[]{SpringBootApplicationMetaConfigKey.AccessType.ENUM_MAP, SpringBootApplicationMetaConfigKey.AccessType.INDEXED})) {
                for (PsiReference reference : propertyKey.getReferences()) {
                    if (!(reference instanceof MapKeyPropertyEnumReferenceSet.MyReference) || reference.isSoft() || reference.resolve() != null) continue;
                    holder.registerProblem(reference, ProblemsHolder.unresolvedReferenceMessage((PsiReference)reference), ProblemHighlightType.ERROR);
                }
            }
            if ((valueElement = SpringBootApplicationPropertiesInspection.getPropertyValue(property)) == null) continue;
            configFileHighlightingUtil.highlightValueReferences((PsiElement)valueElement);
        }
        return holder.getResultsArray();
    }

    @Nullable
    private static PropertyKeyImpl getPropertyKey(PropertyImpl property) {
        ASTNode keyNode = property.getKeyNode();
        if (keyNode == null) {
            return null;
        }
        PsiElement keyElement = keyNode.getPsi();
        if (!(keyElement instanceof PropertyKeyImpl)) {
            return null;
        }
        return (PropertyKeyImpl)keyElement;
    }

    @Nullable
    private static PropertyValueImpl getPropertyValue(PropertyImpl property) {
        ASTNode valueNode = property.getValueNode();
        if (valueNode == null) {
            return null;
        }
        PsiElement valueElement = valueNode.getPsi();
        if (!(valueElement instanceof PropertyValueImpl)) {
            return null;
        }
        return (PropertyValueImpl)valueElement;
    }

    private static LocalQuickFix[] getDeprecationFix(PropertyImpl property, SpringBootApplicationMetaConfigKey configKey) {
        final String replacement = configKey.getDeprecation().getReplacement();
        if (replacement == null) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        return new LocalQuickFix[]{new LocalQuickFixOnPsiElement((PsiElement)property){

            @NotNull
            public String getText() {
                String string = "Use replacement key '" + replacement + "'";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesInspection$1", "getText"));
                }
                return string;
            }

            public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesInspection$1", "invoke"));
                }
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesInspection$1", "invoke"));
                }
                if (startElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesInspection$1", "invoke"));
                }
                if (endElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesInspection$1", "invoke"));
                }
                PropertyImpl property = (PropertyImpl)startElement;
                property.setName(replacement);
            }

            @Nls
            @NotNull
            public String getFamilyName() {
                if ("Use replacement key" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesInspection$1", "getFamilyName"));
                }
                return "Use replacement key";
            }
        }};
    }
}

