/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.properties;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.CharTailType;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.codeStyle.PropertiesCodeStyleSettings;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.boot.application.metadata.MetaConfigKeyReference;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKey;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKeyManager;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SpringBootApplicationPropertiesKeyReferenceProvider
extends PsiReferenceProvider {
    SpringBootApplicationPropertiesKeyReferenceProvider() {
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesKeyReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesKeyReferenceProvider", "getReferencesByElement"));
        }
        PropertyImpl property = (PropertyImpl)PsiTreeUtil.getParentOfType((PsiElement)element, PropertyImpl.class);
        if (property == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesKeyReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiReference[] psiReferenceArray = new PsiReference[]{new PropertyKeyMetaConfigKeyReference(element, property)};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesKeyReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }

    private static class PropertyKeyMetaConfigKeyReference
    extends MetaConfigKeyReference {
        private static final TailType MAP_DOT_TAIL = new CharTailType('.'){

            public int processTail(Editor editor, int tailOffset) {
                int offset = super.processTail(editor, tailOffset);
                AutoPopupController.getInstance((Project)editor.getProject()).scheduleAutoPopup(editor);
                return offset;
            }
        };
        private final PropertyImpl myProperty;

        private PropertyKeyMetaConfigKeyReference(PsiElement element, PropertyImpl property) {
            super(element, property.getName());
            this.myProperty = property;
            SpringBootApplicationMetaConfigKey configKey = this.getResolvedKey();
            if (configKey != null && configKey.isAccessType(new SpringBootApplicationMetaConfigKey.AccessType[]{SpringBootApplicationMetaConfigKey.AccessType.INDEXED, SpringBootApplicationMetaConfigKey.AccessType.MAP, SpringBootApplicationMetaConfigKey.AccessType.ENUM_MAP})) {
                String keyName = configKey.getName();
                this.setRangeInElement(TextRange.allOf((String)keyName));
            }
        }

        @Override
        @NotNull
        public String getReferenceDisplayText() {
            String string = this.myProperty.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesKeyReferenceProvider$PropertyKeyMetaConfigKeyReference", "getReferenceDisplayText"));
            }
            return string;
        }

        @NotNull
        public Object[] getVariants() {
            Set existingKeys = ContainerUtil.map2Set((Collection)this.myProperty.getPropertiesFile().getProperties(), IProperty::getKey);
            CharTailType defaultDelimiterType = new CharTailType(PropertyKeyMetaConfigKeyReference.getKeyValueDelimiter(this.myElement.getProject())){

                public int processTail(Editor editor, int tailOffset) {
                    int offset = super.processTail(editor, tailOffset);
                    AutoPopupController.getInstance((Project)editor.getProject()).scheduleAutoPopup(editor);
                    return offset;
                }
            };
            ArrayList<LookupElement> result = new ArrayList<LookupElement>();
            List configKeys = SpringBootApplicationMetaConfigKeyManager.getInstance().getAllMetaConfigKeys(this.getElement());
            for (SpringBootApplicationMetaConfigKey configKey : configKeys) {
                String name = configKey.getName();
                if (existingKeys.contains(name)) continue;
                LookupElementBuilder builder = configKey.getPresentation().getLookupElement();
                TailType customTailType = PropertyKeyMetaConfigKeyReference.getCustomTailType(configKey);
                TailTypeDecorator tailTypeDecorator = TailTypeDecorator.withTail((LookupElement)builder, (TailType)(customTailType != null ? customTailType : defaultDelimiterType));
                result.add(configKey.getPresentation().tuneLookupElement((LookupElement)tailTypeDecorator));
            }
            Object[] objectArray = result.toArray(new LookupElement[result.size()]);
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesKeyReferenceProvider$PropertyKeyMetaConfigKeyReference", "getVariants"));
            }
            return objectArray;
        }

        @Nullable
        private static TailType getCustomTailType(SpringBootApplicationMetaConfigKey configKey) {
            if (configKey.isAccessType(SpringBootApplicationMetaConfigKey.AccessType.MAP_GROUP)) {
                return MAP_DOT_TAIL;
            }
            return null;
        }

        private static char getKeyValueDelimiter(Project project) {
            return PropertiesCodeStyleSettings.getInstance((Project)project).getDelimiter();
        }
    }
}

