/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.properties;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.spring.boot.application.properties.SpringBootApplicationPropertiesUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.intellij.lang.regexp.RegExpLanguage;
import org.jetbrains.annotations.NotNull;

public class SpringBootApplicationPropertiesValueRegexInjector
implements MultiHostInjector {
    private static final String[] REGEX_PARTS = new String[]{"*", "$", "^", "+"};
    private static final Set<String> REGEX_CONFIG_KEYS = ContainerUtil.immutableSet((Object[])new String[]{"endpoints.configprops.keys-to-sanitize", "endpoints.env.keys-to-sanitize"});

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesValueRegexInjector", "getLanguagesToInject"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesValueRegexInjector", "getLanguagesToInject"));
        }
        PsiFile file = context.getContainingFile();
        if (!(file instanceof PropertiesFile)) {
            return;
        }
        PropertiesFile propertiesFile = (PropertiesFile)file;
        if (!SpringBootApplicationPropertiesUtil.isApplicationPropertiesFile(propertiesFile)) {
            return;
        }
        PropertyImpl value = (PropertyImpl)context;
        String key = value.getKey();
        if (!REGEX_CONFIG_KEYS.contains(key)) {
            return;
        }
        String text = value.getValue();
        if (StringUtil.isEmptyOrSpaces((String)text) || !SpringBootApplicationPropertiesValueRegexInjector.isRegEx(text)) {
            return;
        }
        ASTNode valueNode = value.getValueNode();
        if (valueNode == null) {
            return;
        }
        registrar.startInjecting((Language)RegExpLanguage.INSTANCE).addPlace(null, null, (PsiLanguageInjectionHost)value, TextRange.from((int)valueNode.getPsi().getStartOffsetInParent(), (int)text.length())).doneInjecting();
    }

    private static boolean isRegEx(String value) {
        for (String part : REGEX_PARTS) {
            if (!value.contains(part)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class<PropertyImpl>> list = Collections.singletonList(PropertyImpl.class);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesValueRegexInjector", "elementsToInjectIn"));
        }
        return list;
    }
}

