/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.yaml;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.psi.PsiFile;
import com.intellij.spring.SpringInspectionsRegistry;
import com.intellij.spring.boot.application.config.SpringBootAdditionalFilesContributor;
import com.intellij.spring.boot.application.yaml.SpringBootApplicationYamlInspection;
import com.intellij.spring.boot.application.yaml.SpringBootApplicationYamlUtil;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.util.containers.ContainerUtil;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.psi.YAMLFile;

public class SpringBootApplicationYamlInspectionsRegistryContributor
implements SpringInspectionsRegistry.Contributor {
    public Class<? extends LocalInspectionTool>[] getInspectionClasses() {
        return new Class[]{SpringBootApplicationYamlInspection.class};
    }

    public static class Contributor
    extends SpringBootAdditionalFilesContributor {
        @Override
        @NotNull
        protected Set<VirtualFilePointer> getRelevantFileCandidates(SpringFileSet fileSet) {
            LinkedHashSet otherConfigFiles = ContainerUtil.newLinkedHashSet((Iterable)fileSet.getFiles());
            otherConfigFiles.removeAll(fileSet.getCodeConfigurationFiles());
            otherConfigFiles.removeAll(fileSet.getXmlFiles());
            otherConfigFiles.removeAll(fileSet.getPropertiesFiles());
            LinkedHashSet linkedHashSet = otherConfigFiles;
            if (linkedHashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/yaml/SpringBootApplicationYamlInspectionsRegistryContributor$Contributor", "getRelevantFileCandidates"));
            }
            return linkedHashSet;
        }

        @Override
        protected boolean isRelevantFile(PsiFile psiFile) {
            return psiFile instanceof YAMLFile && SpringBootApplicationYamlUtil.isApplicationYamlFile((YAMLFile)psiFile);
        }
    }
}

