/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.autoconfigure;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.spring.boot.application.SpringBootApplicationUtil;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.model.autoconfigure.EnableAutoConfigurationModel;
import com.intellij.spring.boot.model.autoconfigure.jam.EnableAutoConfiguration;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.LocalAnnotationModelDependentModelsProvider;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.graph.LocalModelDependency;
import com.intellij.spring.contexts.model.graph.LocalModelDependencyType;
import com.intellij.util.PairProcessor;
import java.util.ArrayList;
import java.util.Collection;

public class EnableAutoConfigDependentModelsProvider
extends LocalAnnotationModelDependentModelsProvider {
    public boolean processCustomDependentLocalModels(LocalAnnotationModel localAnnotationModel, PairProcessor<LocalModel, LocalModelDependency> processor) {
        if (!SpringBootLibraryUtil.hasSpringBootLibrary(localAnnotationModel.getModule())) {
            return true;
        }
        PsiClass localModelConfigClass = (PsiClass)localAnnotationModel.getConfig();
        if (!SpringBootApplicationUtil.isSpringApplication((PsiClass)localModelConfigClass)) {
            return true;
        }
        ArrayList<String> fqns = new ArrayList<String>((Collection)EnableAutoConfiguration.getAnnotations().fun((Object)localAnnotationModel.getModule()));
        fqns.add("org.springframework.boot.autoconfigure.EnableAutoConfiguration");
        PsiAnnotation enableAutoConfigAnno = AnnotationUtil.findAnnotation((PsiModifierListOwner)localModelConfigClass, fqns, (boolean)true);
        if (enableAutoConfigAnno == null) {
            return true;
        }
        String enableAnnotationFqn = enableAutoConfigAnno.getQualifiedName();
        assert (enableAnnotationFqn != null);
        PsiClass enableAnnotationClass = JavaPsiFacade.getInstance((Project)localModelConfigClass.getProject()).findClass(enableAnnotationFqn, localModelConfigClass.getResolveScope());
        if (enableAnnotationClass == null) {
            return true;
        }
        EnableAutoConfigurationModel enableAutoConfigModel = new EnableAutoConfigurationModel(localAnnotationModel, enableAnnotationClass);
        return processor.process((Object)enableAutoConfigModel, (Object)LocalModelDependency.create((LocalModelDependencyType)LocalModelDependencyType.UNKNOWN, (PsiElement)enableAutoConfigAnno));
    }
}

