/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.autoconfigure.jam;

import com.intellij.jam.JamElement;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.jam.reflect.JamMethodMeta;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiFieldPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.PsiClass;
import com.intellij.semantic.SemContributor;
import com.intellij.semantic.SemKey;
import com.intellij.semantic.SemRegistrar;
import com.intellij.semantic.SemService;
import com.intellij.spring.boot.model.autoconfigure.jam.AutoConfigureAfter;
import com.intellij.spring.boot.model.autoconfigure.jam.AutoConfigureBefore;
import com.intellij.spring.boot.model.autoconfigure.jam.AutoConfigureOrder;
import com.intellij.spring.boot.model.autoconfigure.jam.Conditional;
import com.intellij.spring.boot.model.autoconfigure.jam.ConditionalOnBean;
import com.intellij.spring.boot.model.autoconfigure.jam.ConditionalOnClass;
import com.intellij.spring.boot.model.autoconfigure.jam.ConditionalOnExpression;
import com.intellij.spring.boot.model.autoconfigure.jam.ConditionalOnMissingBean;
import com.intellij.spring.boot.model.autoconfigure.jam.ConditionalOnMissingClass;
import com.intellij.spring.boot.model.autoconfigure.jam.ConditionalOnNotWebApplication;
import com.intellij.spring.boot.model.autoconfigure.jam.ConditionalOnProperty;
import com.intellij.spring.boot.model.autoconfigure.jam.ConditionalOnResource;
import com.intellij.spring.boot.model.autoconfigure.jam.ConditionalOnSingleCandidate;
import com.intellij.spring.boot.model.autoconfigure.jam.ConditionalOnWebApplication;
import com.intellij.spring.boot.model.autoconfigure.jam.EnableAutoConfiguration;
import com.intellij.spring.boot.model.autoconfigure.jam.SpringBootApplication;
import com.intellij.spring.boot.model.properties.jam.ConfigurationProperties;
import com.intellij.spring.boot.model.properties.jam.EnableConfigurationProperties;
import com.intellij.spring.boot.model.properties.jam.NestedConfigurationProperty;
import com.intellij.spring.boot.model.testing.jam.custom.SpringApplicationConfiguration;
import com.intellij.spring.boot.model.testing.jam.custom.SpringBootDataJpaTest;
import com.intellij.spring.boot.model.testing.jam.custom.SpringBootJsonTest;
import com.intellij.spring.boot.model.testing.jam.custom.SpringBootRestClientTest;
import com.intellij.spring.boot.model.testing.jam.custom.SpringBootTest;
import com.intellij.spring.boot.model.testing.jam.custom.SpringBootWebIntegrationTest;
import com.intellij.spring.boot.model.testing.jam.custom.SpringBootWebMvcTest;
import com.intellij.spring.model.jam.SpringSemContributorUtil;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;

public class SpringBootAutoconfigureSemContributor
extends SemContributor {
    private final SemService mySemService;

    public SpringBootAutoconfigureSemContributor(SemService semService) {
        this.mySemService = semService;
    }

    public void registerSemProviders(SemRegistrar registrar) {
        SpringBootApplication.META.register(registrar, (ElementPattern)PsiJavaPatterns.psiClass().withAnnotation("org.springframework.boot.autoconfigure.SpringBootApplication"));
        this.registerTesting(registrar);
        ConfigurationProperties.CLASS_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiClass().withAnnotation("org.springframework.boot.context.properties.ConfigurationProperties"));
        ConfigurationProperties.Method.METHOD_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiMethod().withAnnotation("org.springframework.boot.context.properties.ConfigurationProperties"));
        NestedConfigurationProperty.FIELD_META.register(registrar, (ElementPattern)((PsiFieldPattern)PsiJavaPatterns.psiField().withoutModifiers(new String[]{"static"})).withAnnotation("org.springframework.boot.context.properties.NestedConfigurationProperty"));
        EnableConfigurationProperties.CLASS_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiClass().withAnnotation("org.springframework.boot.context.properties.EnableConfigurationProperties"));
        this.registerEnableAutoConfiguration(registrar);
        AutoConfigureOrder.CLASS_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiClass().withAnnotation("org.springframework.boot.autoconfigure.AutoConfigureOrder"));
        AutoConfigureOrder.FIELD_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiField().withAnnotation("org.springframework.boot.autoconfigure.AutoConfigureOrder"));
        AutoConfigureOrder.METHOD_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiMethod().withAnnotation("org.springframework.boot.autoconfigure.AutoConfigureOrder"));
        AutoConfigureAfter.META.register(registrar, (ElementPattern)PsiJavaPatterns.psiClass().withAnnotation("org.springframework.boot.autoconfigure.AutoConfigureAfter"));
        AutoConfigureBefore.META.register(registrar, (ElementPattern)PsiJavaPatterns.psiClass().withAnnotation("org.springframework.boot.autoconfigure.AutoConfigureBefore"));
        SpringBootAutoconfigureSemContributor.registerConditionalOn(registrar, "org.springframework.context.annotation.Conditional", Conditional.CLASS_META, Conditional.METHOD_META);
        SpringBootAutoconfigureSemContributor.registerConditionalOn(registrar, "org.springframework.boot.autoconfigure.condition.ConditionalOnBean", ConditionalOnBean.CLASS_META, ConditionalOnBean.METHOD_META);
        SpringBootAutoconfigureSemContributor.registerConditionalOn(registrar, "org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean", ConditionalOnMissingBean.CLASS_META, ConditionalOnMissingBean.METHOD_META);
        SpringBootAutoconfigureSemContributor.registerConditionalOn(registrar, "org.springframework.boot.autoconfigure.condition.ConditionalOnClass", ConditionalOnClass.CLASS_META, ConditionalOnClass.METHOD_META);
        SpringBootAutoconfigureSemContributor.registerConditionalOn(registrar, "org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass", ConditionalOnMissingClass.CLASS_META, ConditionalOnMissingClass.METHOD_META);
        SpringBootAutoconfigureSemContributor.registerConditionalOn(registrar, "org.springframework.boot.autoconfigure.condition.ConditionalOnExpression", ConditionalOnExpression.CLASS_META, ConditionalOnExpression.METHOD_META);
        SpringBootAutoconfigureSemContributor.registerConditionalOn(registrar, "org.springframework.boot.autoconfigure.condition.ConditionalOnProperty", ConditionalOnProperty.CLASS_META, ConditionalOnProperty.METHOD_META);
        SpringBootAutoconfigureSemContributor.registerConditionalOn(registrar, "org.springframework.boot.autoconfigure.condition.ConditionalOnResource", ConditionalOnResource.CLASS_META, ConditionalOnResource.METHOD_META);
        SpringBootAutoconfigureSemContributor.registerConditionalOn(registrar, "org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate", ConditionalOnSingleCandidate.CLASS_META, ConditionalOnSingleCandidate.METHOD_META);
        SpringBootAutoconfigureSemContributor.registerConditionalOn(registrar, "org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication", ConditionalOnWebApplication.CLASS_META, ConditionalOnWebApplication.METHOD_META);
        SpringBootAutoconfigureSemContributor.registerConditionalOn(registrar, "org.springframework.boot.autoconfigure.condition.ConditionalOnNotWebApplication", ConditionalOnNotWebApplication.CLASS_META, ConditionalOnNotWebApplication.METHOD_META);
    }

    protected void registerTesting(SemRegistrar registrar) {
        this.registerSpringApplicationConfiguration(registrar);
        this.registerSpringBootTest(registrar);
        SpringBootJsonTest.META.register(registrar, (ElementPattern)PsiJavaPatterns.psiClass().withAnnotation("org.springframework.boot.test.autoconfigure.json.JsonTest"));
        SpringBootRestClientTest.META.register(registrar, (ElementPattern)PsiJavaPatterns.psiClass().withAnnotation("org.springframework.boot.test.autoconfigure.web.client.RestClientTest"));
        SpringBootDataJpaTest.META.register(registrar, (ElementPattern)PsiJavaPatterns.psiClass().withAnnotation("org.springframework.boot.test.autoconfigure.orm.jpa.DataJpaTest"));
        SpringBootWebIntegrationTest.META.register(registrar, (ElementPattern)PsiJavaPatterns.psiClass().withAnnotation("org.springframework.boot.test.WebIntegrationTest"));
        SpringBootWebMvcTest.META.register(registrar, (ElementPattern)PsiJavaPatterns.psiClass().withAnnotation("org.springframework.boot.test.autoconfigure.web.servlet.WebMvcTest"));
    }

    private void registerSpringApplicationConfiguration(SemRegistrar registrar) {
        SpringApplicationConfiguration.META.register(registrar, (ElementPattern)PsiJavaPatterns.psiClass().withAnnotation("org.springframework.boot.test.SpringApplicationConfiguration"));
        SpringSemContributorUtil.registerMetaComponents((SemService)this.mySemService, (SemRegistrar)registrar, (ElementPattern)PsiJavaPatterns.psiClass(), SpringApplicationConfiguration.META_KEY, SpringApplicationConfiguration.JAM_KEY, (NullableFunction)SpringSemContributorUtil.createFunction(SpringApplicationConfiguration.JAM_KEY, SpringApplicationConfiguration.class, (Function)SpringSemContributorUtil.getCustomMetaAnnotations((String)"org.springframework.boot.test.SpringApplicationConfiguration", (boolean)true, (boolean)false), pair -> new SpringApplicationConfiguration((String)pair.first, (PsiClass)pair.second), null));
    }

    private void registerSpringBootTest(SemRegistrar registrar) {
        SpringBootTest.META.register(registrar, (ElementPattern)PsiJavaPatterns.psiClass().withAnnotation("org.springframework.boot.test.context.SpringBootTest"));
        SpringSemContributorUtil.registerMetaComponents((SemService)this.mySemService, (SemRegistrar)registrar, (ElementPattern)PsiJavaPatterns.psiClass(), SpringBootTest.META_KEY, SpringBootTest.JAM_KEY, (NullableFunction)SpringSemContributorUtil.createFunction(SpringBootTest.JAM_KEY, SpringBootTest.class, (Function)SpringSemContributorUtil.getCustomMetaAnnotations((String)"org.springframework.boot.test.context.SpringBootTest", (boolean)true, (boolean)false), pair -> new SpringBootTest((String)pair.first, (PsiClass)pair.second), null));
    }

    private void registerEnableAutoConfiguration(SemRegistrar registrar) {
        EnableAutoConfiguration.META.register(registrar, (ElementPattern)PsiJavaPatterns.psiClass().withAnnotation("org.springframework.boot.autoconfigure.EnableAutoConfiguration"));
        SpringSemContributorUtil.registerMetaComponents((SemService)this.mySemService, (SemRegistrar)registrar, (ElementPattern)PsiJavaPatterns.psiClass(), (SemKey)EnableAutoConfiguration.META_KEY, (SemKey)EnableAutoConfiguration.JAM_KEY, (NullableFunction)SpringSemContributorUtil.createFunction((SemKey)EnableAutoConfiguration.JAM_KEY, EnableAutoConfiguration.class, (Function)EnableAutoConfiguration.getAnnotations(), pair -> new EnableAutoConfiguration((String)pair.first, (PsiClass)pair.getSecond()), null));
    }

    private static <T extends JamElement> void registerConditionalOn(SemRegistrar registrar, String annotationFQN, JamClassMeta<T> classMeta, JamMethodMeta<T> methodMeta) {
        classMeta.register(registrar, (ElementPattern)PsiJavaPatterns.psiClass().withAnnotation(annotationFQN));
        methodMeta.register(registrar, (ElementPattern)PsiJavaPatterns.psiMethod().withAnnotation(annotationFQN));
    }
}

