/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.properties;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.model.properties.jam.ConfigurationProperties;
import com.intellij.spring.boot.model.properties.jam.EnableConfigurationProperties;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.graph.LocalModelDependency;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.jam.stereotype.CustomSpringComponent;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class EnableConfigurationPropertiesModel
extends LocalAnnotationModel {
    @NonNls
    private static final String CONFIGURATION_PROPERTIES_BEAN_NAME_SUFFIX = "CONFIGURATION_PROPERTIES";
    private final EnableConfigurationProperties myEnableConfigurationProperties;
    private final LocalAnnotationModel myLocalAnnotationModel;

    EnableConfigurationPropertiesModel(LocalAnnotationModel localAnnotationModel, EnableConfigurationProperties enableConfigurationProperties) {
        this.myEnableConfigurationProperties = enableConfigurationProperties;
        this.myLocalAnnotationModel = localAnnotationModel;
    }

    protected Collection<SpringBeanPointer> calculateLocalBeans() {
        final boolean isAtLeast14 = SpringBootLibraryUtil.isAtLeastVersion(this.getModule(), SpringBootLibraryUtil.SpringBootVersion.VERSION_1_4_0);
        SmartList beans = new SmartList();
        for (final PsiClass configBeanClass : this.myEnableConfigurationProperties.getValue()) {
            final ConfigurationProperties configurationProperties = (ConfigurationProperties)ConfigurationProperties.CLASS_META.getJamElement((PsiModifierListOwner)configBeanClass);
            if (configurationProperties == null) continue;
            CustomSpringComponent bean = new CustomSpringComponent("org.springframework.boot.context.properties.ConfigurationProperties", configBeanClass){

                public String getBeanName() {
                    String prefix = configurationProperties.getValueOrPrefix();
                    boolean hasPrefix = StringUtil.isNotEmpty((String)prefix);
                    String qualifiedName = configBeanClass.getQualifiedName();
                    if (isAtLeast14) {
                        return hasPrefix ? prefix + "-" + qualifiedName : qualifiedName;
                    }
                    return hasPrefix ? prefix + "." + EnableConfigurationPropertiesModel.CONFIGURATION_PROPERTIES_BEAN_NAME_SUFFIX : qualifiedName;
                }
            };
            beans.add(bean);
        }
        return BeanService.getInstance().mapSpringBeans((Collection)beans);
    }

    @NotNull
    public PsiClass getConfig() {
        PsiClass psiClass = this.myEnableConfigurationProperties.getPsiElement();
        if (psiClass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/model/properties/EnableConfigurationPropertiesModel", "getConfig"));
        }
        return psiClass;
    }

    @NotNull
    public Set<Pair<LocalModel, LocalModelDependency>> getDependentLocalModels() {
        Set<Pair<LocalModel, LocalModelDependency>> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/model/properties/EnableConfigurationPropertiesModel", "getDependentLocalModels"));
        }
        return set;
    }

    @NotNull
    public Module getModule() {
        Module module = this.myLocalAnnotationModel.getModule();
        if (module == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/model/properties/EnableConfigurationPropertiesModel", "getModule"));
        }
        return module;
    }

    @NotNull
    public Set<String> getAllProfiles() {
        Set set = this.myLocalAnnotationModel.getAllProfiles();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/model/properties/EnableConfigurationPropertiesModel", "getAllProfiles"));
        }
        return set;
    }

    public void setActiveProfiles(@NotNull Set<String> activeProfiles) {
        if (activeProfiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activeProfiles", "com/intellij/spring/boot/model/properties/EnableConfigurationPropertiesModel", "setActiveProfiles"));
        }
    }

    @NotNull
    public Set<PsiFile> getConfigFiles() {
        Set set = this.myLocalAnnotationModel.getConfigFiles();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/model/properties/EnableConfigurationPropertiesModel", "getConfigFiles"));
        }
        return set;
    }

    public boolean hasConfigFile(@NotNull PsiFile configFile) {
        if (configFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFile", "com/intellij/spring/boot/model/properties/EnableConfigurationPropertiesModel", "hasConfigFile"));
        }
        return this.myLocalAnnotationModel.hasConfigFile(configFile);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        EnableConfigurationPropertiesModel model = (EnableConfigurationPropertiesModel)((Object)o);
        if (!this.myEnableConfigurationProperties.equals(model.myEnableConfigurationProperties)) {
            return false;
        }
        return this.myLocalAnnotationModel.equals(model.myLocalAnnotationModel);
    }

    public int hashCode() {
        int result = this.myEnableConfigurationProperties.hashCode();
        result = 31 * result + this.myLocalAnnotationModel.hashCode();
        return result;
    }
}

