/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.testing;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.MetaAnnotationUtil;
import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class SpringBootTestingImplicitUsageProvider
implements ImplicitUsageProvider {
    public boolean isImplicitUsage(PsiElement element) {
        return this.isImplicitWrite(element);
    }

    public boolean isImplicitRead(PsiElement element) {
        return false;
    }

    private static boolean isMetaAnnotated(@NotNull PsiField element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/boot/model/testing/SpringBootTestingImplicitUsageProvider", "isMetaAnnotated"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        return module != null && AnnotationUtil.isAnnotated((PsiModifierListOwner)element, SpringBootTestingImplicitUsageProvider.getMetaAnnotations(module, "org.springframework.boot.test.mock.mockito.MockBean", "org.springframework.boot.test.mock.mockito.SpyBean"));
    }

    @NotNull
    private static Set<String> getMetaAnnotations(@NotNull Module module, String ... annos) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/boot/model/testing/SpringBootTestingImplicitUsageProvider", "getMetaAnnotations"));
        }
        HashSet set = ContainerUtil.newHashSet();
        for (String anno : annos) {
            set.addAll(SpringBootTestingImplicitUsageProvider.getMetaAnnotationsFor(module, anno));
        }
        HashSet hashSet = set;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/model/testing/SpringBootTestingImplicitUsageProvider", "getMetaAnnotations"));
        }
        return hashSet;
    }

    @NotNull
    private static List<String> getMetaAnnotationsFor(@NotNull Module module, String annotation) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/boot/model/testing/SpringBootTestingImplicitUsageProvider", "getMetaAnnotationsFor"));
        }
        List<String> list = MetaAnnotationUtil.getAnnotationTypesWithChildren((Module)module, (String)annotation, (boolean)true).stream().map(PsiClass::getQualifiedName).filter(Objects::nonNull).collect(Collectors.toList());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/model/testing/SpringBootTestingImplicitUsageProvider", "getMetaAnnotationsFor"));
        }
        return list;
    }

    public boolean isImplicitWrite(PsiElement element) {
        if (!(element instanceof PsiField)) {
            return false;
        }
        PsiField modifierListOwner = (PsiField)element;
        PsiModifierList modifierList = modifierListOwner.getModifierList();
        if (modifierList == null || modifierList.getAnnotations().length == 0) {
            return false;
        }
        return (SpringCommonUtils.hasSpringFacets((Project)element.getProject()) || SpringLibraryUtil.hasSpringLibrary((Project)element.getProject())) && SpringBootTestingImplicitUsageProvider.isMetaAnnotated(modifierListOwner);
    }
}

