/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.testing.jam;

import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.semantic.SemKey;
import com.intellij.spring.boot.model.autoconfigure.jam.SpringBootApplication;
import com.intellij.spring.boot.model.testing.jam.SpringBootTestingConfiguration;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBootstrapWithTest
extends SpringBootTestingConfiguration {
    public static final SemKey<SpringBootstrapWithTest> JAM_KEY = SpringBootTestingConfiguration.JAM_KEY.subKey("SpringBootstrapWithTest", new SemKey[0]);
    public static final JamClassMeta<SpringBootstrapWithTest> META = new JamClassMeta(null, SpringBootstrapWithTest.class, JAM_KEY);

    public SpringBootstrapWithTest(@NotNull PsiClass psiClassAnchor) {
        if (psiClassAnchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClassAnchor", "com/intellij/spring/boot/model/testing/jam/SpringBootstrapWithTest", "<init>"));
        }
        this("org.springframework.boot.test.context.SpringBootTest", psiClassAnchor);
    }

    public SpringBootstrapWithTest(String anno, @NotNull PsiClass psiClassAnchor) {
        if (psiClassAnchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClassAnchor", "com/intellij/spring/boot/model/testing/jam/SpringBootstrapWithTest", "<init>"));
        }
        super(anno, psiClassAnchor);
    }

    @Override
    @NotNull
    public List<PsiClass> getConfigurationClasses() {
        List psiClasses = ContainerUtil.newSmartList();
        psiClasses.addAll(this.getBootstrapWithConfigurations());
        psiClasses.addAll(super.getConfigurationClasses());
        List list = psiClasses;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/model/testing/jam/SpringBootstrapWithTest", "getConfigurationClasses"));
        }
        return list;
    }

    @NotNull
    protected List<PsiClass> getBootstrapWithConfigurations() {
        List psiClasses = ContainerUtil.newSmartList();
        PsiClass psiClass = this.getPsiElement();
        PsiFile file = psiClass.getContainingFile();
        if (file instanceof PsiClassOwner) {
            String packageName = ((PsiClassOwner)file).getPackageName();
            while (packageName != null) {
                PsiPackage ourPackage = JavaPsiFacade.getInstance((Project)psiClass.getProject()).findPackage(packageName);
                if (ourPackage == null) continue;
                List elements = JamService.getJamService((Project)psiClass.getProject()).getJamClassElements((JamMemberMeta)SpringBootApplication.META, "org.springframework.boot.autoconfigure.SpringBootApplication", this.getScope(ourPackage));
                if (!elements.isEmpty()) {
                    psiClasses.addAll(elements.stream().map(application -> application.getPsiElement()).collect(Collectors.toList()));
                    break;
                }
                packageName = SpringBootstrapWithTest.getParentPackage(packageName);
            }
        }
        List list = psiClasses;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/model/testing/jam/SpringBootstrapWithTest", "getBootstrapWithConfigurations"));
        }
        return list;
    }

    @Nullable
    private static String getParentPackage(@NotNull String sourcePackage) {
        if (sourcePackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourcePackage", "com/intellij/spring/boot/model/testing/jam/SpringBootstrapWithTest", "getParentPackage"));
        }
        if (sourcePackage.length() == 0) {
            return null;
        }
        int lastDot = sourcePackage.lastIndexOf(".");
        return lastDot == -1 ? "" : sourcePackage.substring(0, lastDot);
    }

    @NotNull
    protected GlobalSearchScope getScope(@NotNull PsiPackage ourPackage) {
        if (ourPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ourPackage", "com/intellij/spring/boot/model/testing/jam/SpringBootstrapWithTest", "getScope"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getPsiElement());
        GlobalSearchScope packageScope = PackageScope.packageScope((PsiPackage)ourPackage, (boolean)false);
        GlobalSearchScope globalSearchScope = module == null ? packageScope : GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)true).intersectWith(packageScope);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/model/testing/jam/SpringBootstrapWithTest", "getScope"));
        }
        return globalSearchScope;
    }
}

