/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.application.BaseJavaApplicationCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.run.SpringBootAdditionalParameter;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfiguration;
import org.jetbrains.annotations.NotNull;

class SpringBootCommandLineState
extends BaseJavaApplicationCommandLineState<SpringBootApplicationRunConfiguration> {
    static final String DEBUG_PARAMETER = "-Ddebug";
    static final String NO_VERIFY_PARAMETER = "-noverify";
    static final String HIDE_BANNER_PARAMETER = "-Dspring.main.show_banner=false";
    static final String HIDE_BANNER_PARAMETER_1_5 = "-Dspring.main.banner-mode=OFF";
    static final String ACTIVE_PROFILES_PARAMETER = "-Dspring.profiles.active";
    static final String OUTPUT_ANSI_ENABLED_PARAMETER = "-Dspring.output.ansi.enabled=always";

    SpringBootCommandLineState(@NotNull SpringBootApplicationRunConfiguration configuration, ExecutionEnvironment environment) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/spring/boot/run/SpringBootCommandLineState", "<init>"));
        }
        super(environment, (RunConfigurationBase)configuration);
    }

    protected JavaParameters createJavaParameters() throws ExecutionException {
        JavaParameters params = new JavaParameters();
        JavaRunConfigurationModule module = (JavaRunConfigurationModule)((SpringBootApplicationRunConfiguration)this.myConfiguration).getConfigurationModule();
        int classPathType = JavaParametersUtil.getClasspathType((RunConfigurationModule)module, (String)((SpringBootApplicationRunConfiguration)this.myConfiguration).getSpringBootMainClass(), (boolean)false);
        String jreHome = ((SpringBootApplicationRunConfiguration)this.myConfiguration).isAlternativeJrePathEnabled() ? ((SpringBootApplicationRunConfiguration)this.myConfiguration).getAlternativeJrePath() : null;
        JavaParametersUtil.configureModule((RunConfigurationModule)module, (JavaParameters)params, (int)classPathType, (String)jreHome);
        params.setMainClass(((SpringBootApplicationRunConfiguration)this.myConfiguration).getSpringBootMainClass());
        params.setUseClasspathJar(true);
        this.setupJavaParameters(params);
        this.applySpringBootSettings(params);
        return params;
    }

    private void applySpringBootSettings(JavaParameters params) {
        ParametersList vmParametersList = params.getVMParametersList();
        if (((SpringBootApplicationRunConfiguration)this.myConfiguration).isDebugMode()) {
            vmParametersList.add(DEBUG_PARAMETER);
        }
        if (((SpringBootApplicationRunConfiguration)this.myConfiguration).isDisableBytecodeVerification()) {
            vmParametersList.add(NO_VERIFY_PARAMETER);
        }
        if (((SpringBootApplicationRunConfiguration)this.myConfiguration).isHideBanner()) {
            if (SpringBootLibraryUtil.isAtLeastVersion(((SpringBootApplicationRunConfiguration)this.myConfiguration).getModule(), SpringBootLibraryUtil.SpringBootVersion.VERSION_1_5_0)) {
                vmParametersList.add(HIDE_BANNER_PARAMETER_1_5);
            } else {
                vmParametersList.add(HIDE_BANNER_PARAMETER);
            }
        }
        if (StringUtil.isNotEmpty((String)((SpringBootApplicationRunConfiguration)this.myConfiguration).getActiveProfiles())) {
            vmParametersList.add("-Dspring.profiles.active=" + ((SpringBootApplicationRunConfiguration)this.myConfiguration).getActiveProfiles());
        }
        vmParametersList.add(OUTPUT_ANSI_ENABLED_PARAMETER);
        for (SpringBootAdditionalParameter parameter : ((SpringBootApplicationRunConfiguration)this.myConfiguration).getAdditionalParameters()) {
            if (!parameter.isEnabled()) continue;
            String parameterValue = parameter.getValue();
            if (StringUtil.isNotEmpty((String)parameterValue)) {
                vmParametersList.add("-D" + parameter.getName() + "=" + parameterValue);
                continue;
            }
            vmParametersList.add("-D" + parameter.getName());
        }
    }
}

