/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.admin;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.w3c.jigsaw.admin.AdminContext;
import org.w3c.jigsaw.admin.AdminReader;
import org.w3c.jigsaw.admin.RemoteAccessException;
import org.w3c.jigsaw.admin.RemoteResource;
import org.w3c.tools.resources.ArrayAttribute;
import org.w3c.tools.resources.Attribute;
import org.w3c.tools.resources.SimpleAttribute;
import org.w3c.tools.resources.serialization.AttributeDescription;
import org.w3c.tools.resources.serialization.EmptyDescription;
import org.w3c.tools.resources.serialization.ResourceDescription;
import org.w3c.www.protocol.http.Reply;
import org.w3c.www.protocol.http.Request;

public class PlainRemoteResource
implements RemoteResource {
    private static final boolean debug = false;
    protected AdminContext admin = null;
    protected AttributeDescription[] attributes;
    protected Object[] values = null;
    protected boolean iscontainer = false;
    protected boolean isindexerscatalog = false;
    protected boolean isDirectoryResource = false;
    protected boolean isframed = false;
    protected String identifier = null;
    protected URL parent = null;
    protected URL url = null;
    protected RemoteResource[] frames = null;
    protected ResourceDescription description = null;

    protected Request createRequest() {
        Request request = this.admin.http.createRequest();
        request.setURL(this.url);
        request.setValue("TE", "gzip");
        return request;
    }

    protected InputStream getInputStream(Reply reply) throws IOException {
        if (reply.hasTransferEncoding("gzip")) {
            return new GZIPInputStream(reply.getInputStream());
        }
        return reply.getInputStream();
    }

    protected void setFrames(RemoteResource[] remoteResourceArray) {
        this.isframed = true;
        this.frames = remoteResourceArray;
    }

    public String[] getClassHierarchy() throws RemoteAccessException {
        return this.description.getClassHierarchy();
    }

    public void reindex(boolean bl) throws RemoteAccessException {
        if (this.isDirectoryResource()) {
            try {
                Request request = this.createRequest();
                if (bl) {
                    request.setMethod("REINDEX-RESOURCE");
                } else {
                    request.setMethod("REINDEX-LOCALLY");
                }
                Reply reply = this.admin.runRequest(request);
            }
            catch (RemoteAccessException remoteAccessException) {
                throw remoteAccessException;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new RemoteAccessException(exception.getMessage());
            }
        } else {
            throw new RemoteAccessException("Error, can't reindex! This is not a DirectoryResource.");
        }
    }

    public void delete() throws RemoteAccessException {
        try {
            Request request = this.createRequest();
            request.setMethod("DELETE-RESOURCE");
            Reply reply = this.admin.runRequest(request);
        }
        catch (RemoteAccessException remoteAccessException) {
            throw remoteAccessException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RemoteAccessException(exception.getMessage());
        }
    }

    public synchronized AttributeDescription[] getAttributes() throws RemoteAccessException {
        return this.description.getAttributeDescriptions();
    }

    public Object getValue(String string) throws RemoteAccessException {
        if (string.equals("identifier")) {
            return this.identifier;
        }
        String[] stringArray = new String[]{string};
        return this.getValues(stringArray)[0];
    }

    protected AttributeDescription lookupAttribute(String string) {
        AttributeDescription[] attributeDescriptionArray = this.description.getAttributeDescriptions();
        for (int i = 0; i < attributeDescriptionArray.length; ++i) {
            AttributeDescription attributeDescription = attributeDescriptionArray[i];
            if (!attributeDescription.getName().equals(string)) continue;
            return attributeDescription;
        }
        return null;
    }

    public Object[] getValues(String[] stringArray) throws RemoteAccessException {
        Object[] objectArray = new Object[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            AttributeDescription attributeDescription = this.lookupAttribute(stringArray[i]);
            objectArray[i] = attributeDescription != null ? attributeDescription.getValue() : null;
        }
        return objectArray;
    }

    public void setValue(String string, Object object) throws RemoteAccessException {
        String[] stringArray = new String[1];
        Object[] objectArray = new Object[1];
        stringArray[0] = string;
        objectArray[0] = object;
        this.setValues(stringArray, objectArray);
    }

    public void setValues(String[] stringArray, Object[] objectArray) throws RemoteAccessException {
        Object object;
        Object object2;
        String string = null;
        boolean bl = false;
        AttributeDescription[] attributeDescriptionArray = new AttributeDescription[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            object2 = this.lookupAttribute(stringArray[i]);
            if (object2 != null) {
                ((AttributeDescription)object2).setValue(objectArray[i]);
                attributeDescriptionArray[i] = object2;
            }
            if (!stringArray[i].equals("identifier")) continue;
            bl = true;
            string = (String)objectArray[i];
        }
        ResourceDescription resourceDescription = this.description.getClone(attributeDescriptionArray);
        try {
            object2 = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream((OutputStream)object2);
            this.admin.writer.writeResourceDescription(resourceDescription, gZIPOutputStream);
            object = ((ByteArrayOutputStream)object2).toByteArray();
            Request request = this.createRequest();
            request.setMethod("SET-VALUES");
            request.setContentType(AdminContext.conftype);
            request.setContentLength(((byte[])object).length);
            request.addTransferEncoding("gzip");
            request.setOutputStream(new ByteArrayInputStream((byte[])object));
            Reply reply = this.admin.runRequest(request);
        }
        catch (RemoteAccessException remoteAccessException) {
            throw remoteAccessException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RemoteAccessException("exception " + exception.getMessage());
        }
        if (bl) {
            this.identifier = new String(string);
            try {
                if (!this.isFrame()) {
                    this.url = this.iscontainer ? new URL(this.parent.toString() + this.identifier + "/") : new URL(this.parent.toString() + this.identifier);
                    this.updateURL(new URL(this.parent.toString() + this.identifier));
                } else {
                    object2 = this.url.getFile();
                    int n = ((String)object2).lastIndexOf(63);
                    object = ((String)object2).substring(0, n);
                    this.updateURL(new URL(this.url, (String)object));
                }
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
        }
    }

    public void updateURL(URL uRL) {
        if (this.isFrame()) {
            try {
                this.url = new URL(uRL, uRL.getFile() + "?" + this.identifier);
            }
            catch (MalformedURLException malformedURLException) {
                return;
            }
        }
        if (this.frames != null) {
            for (int i = 0; i < this.frames.length; ++i) {
                this.frames[i].updateURL(this.url);
            }
        }
    }

    public boolean isContainer() throws RemoteAccessException {
        if (this.identifier != null) {
            String string;
            if (this.identifier.equals("root")) {
                return false;
            }
            if (this.identifier.equals("control") && (string = this.getClassHierarchy()[0]).equals("org.w3c.jigsaw.http.ControlResource")) {
                return false;
            }
        }
        return this.iscontainer;
    }

    public boolean isIndexersCatalog() throws RemoteAccessException {
        return this.isindexerscatalog;
    }

    public boolean isDirectoryResource() throws RemoteAccessException {
        if (this.identifier != null && this.identifier.equals("root")) {
            return false;
        }
        return this.isDirectoryResource;
    }

    public String[] enumerateResourceIdentifiers() throws RemoteAccessException {
        if (!this.iscontainer) {
            throw new RuntimeException("not a container");
        }
        try {
            this.update();
            return this.description.getChildren();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RemoteAccessException("http " + exception.getMessage());
        }
    }

    public RemoteResource loadResource(String string) throws RemoteAccessException {
        try {
            Request request = this.createRequest();
            request.setMethod("LOAD-RESOURCE");
            request.setURL(new URL(this.url.toString() + URLEncoder.encode(string)));
            Reply reply = this.admin.runRequest(request);
            InputStream inputStream = this.getInputStream(reply);
            RemoteResource remoteResource = this.admin.reader.readResource(this.url, string, inputStream);
            inputStream.close();
            return remoteResource;
        }
        catch (RemoteAccessException remoteAccessException) {
            throw remoteAccessException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RemoteAccessException(exception.getMessage());
        }
    }

    public RemoteResource registerResource(String string, String string2) throws RemoteAccessException {
        ResourceDescription resourceDescription = new EmptyDescription(string2, string);
        try {
            Request request = this.createRequest();
            request.setMethod("REGISTER-RESOURCE");
            request.setContentType(AdminContext.conftype);
            request.setURL(this.url);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            this.admin.writer.writeResourceDescription(resourceDescription, gZIPOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            request.setContentLength(byArray.length);
            request.addTransferEncoding("gzip");
            request.setOutputStream(new ByteArrayInputStream(byArray));
            Reply reply = this.admin.runRequest(request);
            AdminReader cfr_ignored_0 = this.admin.reader;
            resourceDescription = AdminReader.readResourceDescription(this.getInputStream(reply));
            PlainRemoteResource plainRemoteResource = new PlainRemoteResource(this.admin, this.url, resourceDescription.getIdentifier(), resourceDescription);
            return plainRemoteResource;
        }
        catch (RemoteAccessException remoteAccessException) {
            throw remoteAccessException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RemoteAccessException(exception.getMessage());
        }
    }

    public boolean isFramed() throws RemoteAccessException {
        return this.isframed;
    }

    public RemoteResource[] getFrames() throws RemoteAccessException {
        if (!this.isframed) {
            throw new RuntimeException("not a framed resource");
        }
        return this.frames;
    }

    public void unregisterFrame(RemoteResource remoteResource) throws RemoteAccessException {
        RemoteResource[] remoteResourceArray;
        if (!this.isframed) {
            throw new RuntimeException("not a framed resource");
        }
        if (this.frames == null) {
            throw new RuntimeException("this resource has no frames");
        }
        String string = null;
        try {
            string = ((PlainRemoteResource)remoteResource).identifier;
            remoteResourceArray = this.createRequest();
            remoteResourceArray.setMethod("UNREGISTER-FRAME");
            remoteResourceArray.setContentType(AdminContext.conftype);
            remoteResourceArray.setURL(this.url);
            EmptyDescription emptyDescription = new EmptyDescription("", string);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            this.admin.writer.writeResourceDescription(emptyDescription, gZIPOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            remoteResourceArray.setContentLength(byArray.length);
            remoteResourceArray.addTransferEncoding("gzip");
            remoteResourceArray.setOutputStream(new ByteArrayInputStream(byArray));
            Reply reply = this.admin.runRequest((Request)remoteResourceArray);
        }
        catch (RemoteAccessException remoteAccessException) {
            throw remoteAccessException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RemoteAccessException(exception.getMessage());
        }
        remoteResourceArray = new RemoteResource[this.frames.length - 1];
        int n = 0;
        for (int i = 0; i < this.frames.length; ++i) {
            if (((PlainRemoteResource)this.frames[i]).identifier.equals(string)) {
                System.arraycopy(this.frames, i + 1, remoteResourceArray, n, this.frames.length - i - 1);
                this.frames = remoteResourceArray;
                return;
            }
            try {
                remoteResourceArray[n++] = this.frames[i];
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return;
            }
        }
    }

    public boolean isFrame() {
        return this.isFrameURL(this.url);
    }

    protected boolean isFrameURL(URL uRL) {
        return uRL.toString().lastIndexOf(63) != -1;
    }

    public RemoteResource registerFrame(String string, String string2) throws RemoteAccessException {
        if (!this.isframed) {
            throw new RuntimeException("not a framed resource");
        }
        try {
            Request request = this.createRequest();
            request.setMethod("REGISTER-FRAME");
            request.setContentType(AdminContext.conftype);
            ResourceDescription resourceDescription = new EmptyDescription(string2, string);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            this.admin.writer.writeResourceDescription(resourceDescription, gZIPOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            request.setContentLength(byArray.length);
            request.addTransferEncoding("gzip");
            request.setOutputStream(new ByteArrayInputStream(byArray));
            Reply reply = this.admin.runRequest(request);
            AdminReader cfr_ignored_0 = this.admin.reader;
            resourceDescription = AdminReader.readResourceDescription(this.getInputStream(reply));
            string = resourceDescription.getIdentifier();
            URL uRL = null;
            uRL = this.isFrame() ? new URL(this.url, this.url.getFile() + "?" + string) : new URL(this.parent.toString() + this.identifier + "?" + string);
            PlainRemoteResource plainRemoteResource = new PlainRemoteResource(this.admin, this.parent, uRL, string, resourceDescription);
            if (this.frames != null) {
                RemoteResource[] remoteResourceArray = new RemoteResource[this.frames.length + 1];
                System.arraycopy(this.frames, 0, remoteResourceArray, 0, this.frames.length);
                remoteResourceArray[this.frames.length] = plainRemoteResource;
                this.frames = remoteResourceArray;
            } else {
                this.frames = new RemoteResource[1];
                this.frames[0] = plainRemoteResource;
            }
            return plainRemoteResource;
        }
        catch (RemoteAccessException remoteAccessException) {
            throw remoteAccessException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RemoteAccessException(exception.getMessage());
        }
    }

    protected void createRemoteFrames() {
        ResourceDescription[] resourceDescriptionArray = this.description.getFrameDescriptions();
        int n = resourceDescriptionArray.length;
        this.frames = new RemoteResource[n];
        for (int i = 0; i < n; ++i) {
            ResourceDescription resourceDescription = resourceDescriptionArray[i];
            String string = resourceDescription.getIdentifier();
            URL uRL = null;
            try {
                uRL = this.isFrame() ? new URL(this.url, this.url.getFile() + "?" + string) : new URL(this.parent.toString() + this.identifier + "?" + string);
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
                uRL = null;
            }
            PlainRemoteResource plainRemoteResource = new PlainRemoteResource(this.admin, this.parent, uRL, string, resourceDescription);
            this.frames[i] = plainRemoteResource;
        }
    }

    public void dump(PrintStream printStream) throws RemoteAccessException {
        int n;
        System.out.println("+ classes: ");
        String[] stringArray = this.getClassHierarchy();
        for (n = 0; n < stringArray.length; ++n) {
            System.out.println("\t" + stringArray[n]);
        }
        if (this.isframed && this.frames != null) {
            System.out.println("+ " + this.frames.length + " frames.");
            for (n = 0; n < this.frames.length; ++n) {
                printStream.println("\t" + ((PlainRemoteResource)this.frames[n]).identifier);
                ((PlainRemoteResource)this.frames[n]).dump(printStream);
            }
        }
        System.out.println("+ attributes: ");
        AttributeDescription[] attributeDescriptionArray = this.getAttributes();
        for (int i = 0; i < attributeDescriptionArray.length; ++i) {
            Attribute attribute = attributeDescriptionArray[i].getAttribute();
            if (!attribute.checkFlag(2)) continue;
            Object object = attributeDescriptionArray[i].getValue();
            if (object != null) {
                Attribute attribute2;
                if (attribute instanceof SimpleAttribute) {
                    attribute2 = (SimpleAttribute)attribute;
                    printStream.println("\t" + attribute.getName() + "=" + ((SimpleAttribute)attribute2).pickle(attributeDescriptionArray[i].getValue()));
                    continue;
                }
                if (!(attribute instanceof ArrayAttribute)) continue;
                attribute2 = (ArrayAttribute)attribute;
                String[] stringArray2 = ((ArrayAttribute)attribute2).pickle(attributeDescriptionArray[i].getValue());
                printStream.print("\t" + attribute.getName() + "=");
                for (int j = 0; j < stringArray2.length; ++j) {
                    if (j != 0) {
                        printStream.print(" | ");
                    }
                    printStream.print(stringArray2[j]);
                }
                continue;
            }
            printStream.println("\t" + attribute.getName() + " <undef>");
        }
    }

    protected void update() throws RemoteAccessException {
        try {
            Request request = this.createRequest();
            request.setMethod("LOAD-RESOURCE");
            Reply reply = this.admin.runRequest(request);
            InputStream inputStream = this.getInputStream(reply);
            AdminReader cfr_ignored_0 = this.admin.reader;
            this.description = AdminReader.readResourceDescription(inputStream);
            this.createRemoteFrames();
        }
        catch (RemoteAccessException remoteAccessException) {
            throw remoteAccessException;
        }
        catch (Exception exception) {
            throw new RemoteAccessException(exception.getMessage());
        }
    }

    PlainRemoteResource(AdminContext adminContext, URL uRL, String string, ResourceDescription resourceDescription) {
        this(adminContext, uRL, null, string, resourceDescription);
    }

    PlainRemoteResource(AdminContext adminContext, URL uRL, URL uRL2, String string, ResourceDescription resourceDescription) {
        this.admin = adminContext;
        this.parent = uRL;
        this.identifier = string;
        this.description = resourceDescription;
        String[] stringArray = resourceDescription.getClassesAndInterfaces();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("org.w3c.tools.resources.ContainerInterface")) {
                this.iscontainer = true;
            }
            if (stringArray[i].equals("org.w3c.tools.resources.FramedResource")) {
                this.isframed = true;
            }
            if (stringArray[i].equals("org.w3c.tools.resources.DirectoryResource")) {
                this.isDirectoryResource = true;
            }
            if (!stringArray[i].equals("org.w3c.tools.resources.indexer.IndexersCatalog")) continue;
            this.isindexerscatalog = true;
        }
        if (uRL2 == null) {
            if (uRL != null) {
                String string2 = string == null ? string : URLEncoder.encode(string);
                String string3 = this.iscontainer ? string2 + "/" : string2;
                try {
                    this.url = string != null ? new URL(uRL.toString() + string3) : uRL;
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                    this.url = null;
                }
            } else {
                this.url = null;
            }
        } else {
            this.url = uRL2;
        }
        this.createRemoteFrames();
    }
}

