/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.JMenu;
import javax.swing.SwingUtilities;
import org.lobobrowser.clientlet.ClientletResponse;
import org.lobobrowser.clientlet.ComponentContent;
import org.lobobrowser.gui.AbstractBrowserWindow;
import org.lobobrowser.gui.DefaultWindowFactory;
import org.lobobrowser.gui.FillerComponent;
import org.lobobrowser.gui.FramePanel;
import org.lobobrowser.gui.FramePanelFactorySource;
import org.lobobrowser.gui.ProgressWindow;
import org.lobobrowser.gui.WindowCallback;
import org.lobobrowser.gui.WindowFactory;
import org.lobobrowser.main.ExtensionManager;
import org.lobobrowser.request.RequestEngine;
import org.lobobrowser.request.UserAgentImpl;
import org.lobobrowser.ua.NavigationEntry;
import org.lobobrowser.ua.NavigatorEvent;
import org.lobobrowser.ua.NavigatorEventType;
import org.lobobrowser.ua.NavigatorFrame;
import org.lobobrowser.ua.NavigatorProgressEvent;
import org.lobobrowser.ua.NavigatorWindow;
import org.lobobrowser.ua.NavigatorWindowEvent;
import org.lobobrowser.ua.NavigatorWindowListener;
import org.lobobrowser.ua.ParameterInfo;
import org.lobobrowser.ua.RequestType;
import org.lobobrowser.ua.TargetType;
import org.lobobrowser.ua.UserAgent;
import org.lobobrowser.util.EventDispatch2;
import org.lobobrowser.util.Objects;
import org.lobobrowser.util.Urls;

public class NavigatorWindowImpl
implements NavigatorWindow,
WindowCallback {
    private static final Logger logger = Logger.getLogger(NavigatorWindowImpl.class.getName());
    private static final int HGAP = 4;
    private static final int VGAP = 2;
    private final FramePanel framePanel;
    private final Properties requestedProperties;
    private final String windowId;
    private final Window progressWindow;
    private final AbstractBrowserWindow browserWindow;
    private final Map<String, JMenu> menusById = new HashMap<String, JMenu>();
    private final Collection<JMenu> menus = new LinkedList<JMenu>();
    private final Collection<Component> addressBarComponents = new LinkedList<Component>();
    private final Collection<Component> sharedToolbarComponents = new LinkedList<Component>();
    private final Collection<Component> statusBarComponents = new LinkedList<Component>();
    private final Collection<Component> toolBars = new LinkedList<Component>();
    private volatile boolean launched = false;
    private volatile boolean disposingProgressWindow = false;
    private static volatile WindowFactory windowFactory = DefaultWindowFactory.getInstance();
    private volatile NavigatorFrame latestAccessedFrame = null;
    private String status;
    private String defaultStatus;
    private final EventDispatch2 EVENT = new LocalEventDispatch();

    public static void setWindowFactory(WindowFactory wf) {
        windowFactory = wf;
    }

    public NavigatorWindowImpl(NavigatorFrame openerFrame, String windowId, Properties properties) {
        this.requestedProperties = properties;
        this.windowId = windowId;
        WindowFactory wf = windowFactory;
        if (wf == null) {
            throw new IllegalStateException("Global WindowFactory is null.");
        }
        AbstractBrowserWindow window = wf.getExistingWindow(windowId);
        FramePanel framePanel = null;
        if (window != null) {
            framePanel = window.getTopFramePanel();
            if (framePanel == null) {
                throw new IllegalStateException("Window with ID " + windowId + " exists but its top frame is null.");
            }
        } else {
            framePanel = FramePanelFactorySource.getInstance().getActiveFactory().createFramePanel(windowId);
            framePanel.setOpenerFrame(openerFrame);
        }
        this.framePanel = framePanel;
        if (window != null) {
            this.browserWindow = window;
            this.progressWindow = null;
            this.launched = true;
        } else {
            AbstractBrowserWindow newWindow;
            this.browserWindow = newWindow = wf.createWindow(this.windowId, properties, this);
            ProgressWindow progressWindow = new ProgressWindow();
            this.progressWindow = progressWindow;
            progressWindow.pack();
            progressWindow.setSize(new Dimension(400, progressWindow.getHeight()));
            progressWindow.setLocationByPlatform(true);
            progressWindow.setVisible(true);
            progressWindow.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    if (!NavigatorWindowImpl.this.launched) {
                        if (logger.isLoggable(Level.INFO)) {
                            logger.info("NavigatorWindowImpl(): Disposing browserWindow due to progress window getting closed.");
                        }
                        NavigatorWindowImpl.this.browserWindow.dispose();
                    }
                }
            });
        }
    }

    public boolean isClosed() {
        return !this.browserWindow.isDisplayable();
    }

    public FramePanel getFramePanel() {
        return this.framePanel;
    }

    void resetAsNavigator(Properties overridingProperties) {
        NavigationEntry currentEntry;
        AbstractBrowserWindow window;
        if (this.launched) {
            return;
        }
        this.launched = true;
        if (this.progressWindow != null) {
            if (!this.progressWindow.isDisplayable()) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("resetAsNavigator(): Progress window is not displayable, so it must have been closed; cancelling operation.");
                }
                this.browserWindow.dispose();
                return;
            }
            this.progressWindow.dispose();
        }
        if (!(window = this.browserWindow).isVisible()) {
            window.setVisible(true);
        }
        window.toFront();
        if (overridingProperties != null) {
            Properties original = this.requestedProperties;
            if (original == null) {
                original = new Properties();
            }
            original.putAll((Map<?, ?>)overridingProperties);
            WindowFactory wf = windowFactory;
            if (wf == null) {
                throw new IllegalStateException("Global WindowFactory is null.");
            }
            wf.overrideProperties(window, original);
        }
        if (window instanceof Frame && (currentEntry = this.getCurrentNavigationEntry()) != null) {
            String title = currentEntry.getTitle();
            if (title == null) {
                title = Urls.getNoRefForm(currentEntry.getUrl());
            }
            window.setTitle(title);
        }
        if (!window.isVisible()) {
            window.setVisible(true);
        }
        window.toFront();
    }

    public void close() {
        Window pw;
        AbstractBrowserWindow window = this.browserWindow;
        if (window != null) {
            window.dispose();
        }
        if ((pw = this.progressWindow) != null) {
            pw.dispose();
        }
    }

    public void updatePreNavigationProgress(NavigatorProgressEvent event) {
        Window window = this.progressWindow;
        if (window instanceof ProgressWindow) {
            ProgressWindow pw = (ProgressWindow)window;
            pw.updateProgress(event);
        }
    }

    public static NavigatorWindowImpl createFromWindowFeatures(NavigatorFrame openerFrame, String windowId, String windowFeatures) {
        return new NavigatorWindowImpl(openerFrame, windowId, NavigatorWindowImpl.getPropertiesFromWindowFeatures(windowFeatures));
    }

    public static Properties getPropertiesFromWindowFeatures(String windowFeatures) {
        String lineBreak = System.getProperty("line.separator");
        StringBuffer buffer = new StringBuffer();
        StringTokenizer tok = new StringTokenizer(windowFeatures, ",");
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            buffer.append(token);
            buffer.append(lineBreak);
        }
        Properties props = new Properties();
        byte[] bytes = buffer.toString().getBytes();
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        try {
            props.load(in);
        }
        catch (IOException ioe) {
            logger.log(Level.SEVERE, "unexpected", ioe);
        }
        return props;
    }

    public void navigate(String urlOrPath) throws MalformedURLException {
        this.framePanel.navigate(urlOrPath);
    }

    public void navigate(URL url, String method, ParameterInfo paramInfo) {
        this.framePanel.navigate(url, method, paramInfo, TargetType.SELF, RequestType.PROGRAMMATIC);
    }

    @Override
    public void handleError(NavigatorFrame frame, ClientletResponse response, Throwable exception) {
        ExtensionManager.getInstance().handleError(frame, response, exception);
        this.handleDocumentRendering(frame, response, null);
    }

    @Override
    public void handleDocumentAccess(NavigatorFrame frame, ClientletResponse response) {
        final NavigatorWindowEvent event = new NavigatorWindowEvent(this, NavigatorEventType.DOCUMENT_ACCESSED, frame, response);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NavigatorWindowImpl.this.EVENT.fireEvent(event);
            }
        });
    }

    public void handleDocumentAccess(NavigatorFrame frame, ClientletResponse response, boolean okToAddToNavigationList) {
        this.handleDocumentAccess(frame, response);
    }

    @Override
    public boolean canCopy() {
        return this.framePanel.canCopy();
    }

    @Override
    public boolean canReload() {
        return this.framePanel.canReload();
    }

    @Override
    public boolean copy() {
        return this.framePanel.copy();
    }

    @Override
    public UserAgent getUserAgent() {
        return UserAgentImpl.getInstance();
    }

    @Override
    public void dispose() {
        this.progressWindow.dispose();
        this.browserWindow.dispose();
    }

    @Override
    public boolean reload() {
        this.framePanel.reload();
        return true;
    }

    @Override
    public boolean stop() {
        RequestEngine.getInstance().cancelAllRequests();
        return true;
    }

    @Override
    public void handleDocumentRendering(final NavigatorFrame frame, final ClientletResponse response, final ComponentContent content) {
        if (EventQueue.isDispatchThread()) {
            this.handleDocumentRenderingImpl(frame, response, content);
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NavigatorWindowImpl.this.handleDocumentRenderingImpl(frame, response, content);
                }
            });
        }
    }

    private String getWindowTitle(ClientletResponse response, ComponentContent content) {
        String title;
        String string = title = content == null ? null : content.getTitle();
        if (title == null) {
            title = response == null ? "" : Urls.getNoRefForm(response.getResponseURL());
        }
        return title;
    }

    private void handleDocumentRenderingImpl(NavigatorFrame frame, ClientletResponse response, ComponentContent content) {
        if (frame == this.framePanel) {
            String title = this.getWindowTitle(response, content);
            AbstractBrowserWindow window = this.browserWindow;
            if (window instanceof Frame) {
                ((Frame)window).setTitle(title);
            }
        }
        NavigatorWindowEvent event = new NavigatorWindowEvent(this, NavigatorEventType.DOCUMENT_RENDERING, frame, response);
        this.latestAccessedFrame = event.getNavigatorFrame();
        if (!this.EVENT.fireEvent(event)) {
            logger.warning("handleDocumentRendering(): Did not deliver event to any window: " + event);
        }
    }

    @Override
    public void updateProgress(final NavigatorProgressEvent event) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                NavigatorWindowImpl.this.EVENT.fireEvent(event);
            }
        });
    }

    @Override
    public Component getComponent() {
        if (this.launched) {
            return this.browserWindow;
        }
        return this.progressWindow;
    }

    @Override
    public boolean back() {
        NavigatorFrame frame = this.latestAccessedFrame;
        if (frame != null) {
            if (frame.back()) {
                return true;
            }
            if (frame == this.framePanel) {
                return false;
            }
        }
        return this.framePanel.back();
    }

    @Override
    public boolean forward() {
        NavigatorFrame frame = this.latestAccessedFrame;
        if (frame != null) {
            if (frame.forward()) {
                return true;
            }
            if (frame == this.framePanel) {
                return false;
            }
        }
        return this.framePanel.forward();
    }

    @Override
    public boolean canForward() {
        NavigatorFrame frame = this.latestAccessedFrame;
        if (frame != null) {
            if (frame.canForward()) {
                return true;
            }
            if (frame == this.framePanel) {
                return false;
            }
        }
        return this.framePanel.canForward();
    }

    @Override
    public boolean canBack() {
        NavigatorFrame frame = this.latestAccessedFrame;
        if (frame != null) {
            if (frame.canBack()) {
                return true;
            }
            if (frame == this.framePanel) {
                return false;
            }
        }
        return this.framePanel.canBack();
    }

    public void toFront() {
        this.browserWindow.toFront();
    }

    public void toBack() {
        this.browserWindow.toBack();
    }

    @Override
    public NavigatorFrame getTopFrame() {
        return this.framePanel;
    }

    public void statusUpdated(NavigatorFrame clientletFrame, String value) {
        final NavigatorWindowEvent event = new NavigatorWindowEvent((Object)this, NavigatorEventType.STATUS_UPDATED, clientletFrame, value, RequestType.NONE);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                NavigatorWindowImpl.this.EVENT.fireEvent(event);
            }
        });
    }

    public void defaultStatusUpdated(NavigatorFrame clientletFrame, String value) {
        final NavigatorWindowEvent event = new NavigatorWindowEvent((Object)this, NavigatorEventType.STATUS_UPDATED, clientletFrame, value, RequestType.NONE);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                NavigatorWindowImpl.this.EVENT.fireEvent(event);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStatus(NavigatorFrame frame, String value) {
        NavigatorWindowImpl navigatorWindowImpl = this;
        synchronized (navigatorWindowImpl) {
            if (!Objects.equals(this.status, value)) {
                this.status = value;
                String actualStatus = value == null ? this.defaultStatus : value;
                final NavigatorWindowEvent event = new NavigatorWindowEvent((Object)this, NavigatorEventType.STATUS_UPDATED, frame, actualStatus, RequestType.NONE);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        NavigatorWindowImpl.this.EVENT.fireEvent(event);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDefaultStatus(NavigatorFrame frame, String value) {
        NavigatorWindowImpl navigatorWindowImpl = this;
        synchronized (navigatorWindowImpl) {
            this.defaultStatus = value;
            if (this.status == null) {
                String actualStatus = this.defaultStatus;
                final NavigatorWindowEvent event = new NavigatorWindowEvent((Object)this, NavigatorEventType.STATUS_UPDATED, frame, actualStatus, RequestType.NONE);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        NavigatorWindowImpl.this.EVENT.fireEvent(event);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getStatus() {
        NavigatorWindowImpl navigatorWindowImpl = this;
        synchronized (navigatorWindowImpl) {
            return this.status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDefaultStatus() {
        NavigatorWindowImpl navigatorWindowImpl = this;
        synchronized (navigatorWindowImpl) {
            return this.defaultStatus;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAddressBarComponent(Component addressBar) {
        NavigatorWindowImpl navigatorWindowImpl = this;
        synchronized (navigatorWindowImpl) {
            this.addressBarComponents.add(addressBar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMenu(String menuId, JMenu menu) {
        Map<String, JMenu> map = this.menusById;
        NavigatorWindowImpl navigatorWindowImpl = this;
        synchronized (navigatorWindowImpl) {
            if (map.containsKey(menuId)) {
                throw new IllegalArgumentException("Menu " + menuId + " already exists.");
            }
            this.menusById.put(menuId, menu);
            this.menus.add(menu);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JMenu getMenu(String menuId) {
        NavigatorWindowImpl navigatorWindowImpl = this;
        synchronized (navigatorWindowImpl) {
            return this.menusById.get(menuId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSharedToolBarComponent(Component toolBarComponent) {
        NavigatorWindowImpl navigatorWindowImpl = this;
        synchronized (navigatorWindowImpl) {
            this.sharedToolbarComponents.add(toolBarComponent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addStatusBarComponent(Component statusBarComponent) {
        NavigatorWindowImpl navigatorWindowImpl = this;
        synchronized (navigatorWindowImpl) {
            this.statusBarComponents.add(statusBarComponent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addToolBar(Component toolBar) {
        NavigatorWindowImpl navigatorWindowImpl = this;
        synchronized (navigatorWindowImpl) {
            this.toolBars.add(toolBar);
        }
    }

    @Override
    public void addNavigatorWindowListener(NavigatorWindowListener listener) {
        this.EVENT.addListener(listener);
    }

    @Override
    public void removeNavigatorWindowListener(NavigatorWindowListener listener) {
        this.EVENT.removeListener(listener);
    }

    public Collection<Component> getAddressBarComponents() {
        return this.addressBarComponents;
    }

    public Collection<JMenu> getMenus() {
        return this.menus;
    }

    public Collection<Component> getSharedToolbarComponents() {
        return this.sharedToolbarComponents;
    }

    public Collection<Component> getStatusBarComponents() {
        return this.statusBarComponents;
    }

    public Collection<Component> getToolBars() {
        return this.toolBars;
    }

    public Object getComponentLock() {
        return this;
    }

    @Override
    public Component createGlueComponent(Component wrappedComponent, boolean usingMaxSize) {
        return new FillerComponent(wrappedComponent, usingMaxSize);
    }

    @Override
    public Component createGap() {
        return Box.createRigidArea(new Dimension(4, 2));
    }

    @Override
    public boolean goTo(NavigationEntry entry) {
        return this.framePanel.goTo(entry);
    }

    @Override
    public NavigationEntry[] getBackNavigationEntries() {
        return this.framePanel.getBackNavigationEntries();
    }

    @Override
    public NavigationEntry[] getForwardNavigationEntries() {
        return this.framePanel.getForwardNavigationEntries();
    }

    @Override
    public NavigationEntry getCurrentNavigationEntry() {
        return this.framePanel.getCurrentNavigationEntry();
    }

    @Override
    public boolean hasSource() {
        return this.framePanel.hasSource();
    }

    @Override
    public Window getAwtWindow() {
        if (this.launched) {
            return this.browserWindow;
        }
        return this.progressWindow;
    }

    public static class LocalEventDispatch
    extends EventDispatch2 {
        @Override
        protected void dispatchEvent(EventListener listener, EventObject event) {
            NavigatorEvent ne = (NavigatorEvent)event;
            NavigatorWindowListener nwl = (NavigatorWindowListener)listener;
            switch (ne.getEventType()) {
                case DOCUMENT_ACCESSED: {
                    nwl.documentAccessed((NavigatorWindowEvent)ne);
                    break;
                }
                case DOCUMENT_RENDERING: {
                    nwl.documentRendering((NavigatorWindowEvent)ne);
                    break;
                }
                case PROGRESS_UPDATED: {
                    nwl.progressUpdated((NavigatorProgressEvent)ne);
                    break;
                }
                case STATUS_UPDATED: {
                    nwl.statusUpdated((NavigatorWindowEvent)ne);
                    break;
                }
                case DEFAULT_STATUS_UPDATED: {
                    nwl.defaultStatusUpdated((NavigatorWindowEvent)ne);
                    break;
                }
            }
        }
    }
}

