/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.dombl;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lobobrowser.html.dombl.DocumentNotificationAdapter;
import org.lobobrowser.html.domfilter.NodeFilter;
import org.lobobrowser.html.domimpl.DOMElementImpl;
import org.lobobrowser.html.domimpl.DOMNodeImpl;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.html.w3c.HTMLCollection;
import org.lobobrowser.js.AbstractScriptableDelegate;
import org.lobobrowser.util.Nodes;
import org.w3c.dom.Node;

public class DescendentHTMLCollection
extends AbstractScriptableDelegate
implements HTMLCollection {
    private final DOMNodeImpl rootNode;
    private final NodeFilter nodeFilter;
    private final Object treeLock;
    private final boolean nestIntoMatchingNodes;
    private Map<String, DOMElementImpl> itemsByName = null;
    private List<DOMNodeImpl> itemsByIndex = null;

    public DescendentHTMLCollection(DOMNodeImpl node, NodeFilter filter, Object treeLock) {
        this(node, filter, treeLock, true);
    }

    public DescendentHTMLCollection(DOMNodeImpl node, NodeFilter filter, Object treeLock, boolean nestMatchingNodes) {
        this.rootNode = node;
        this.nodeFilter = filter;
        this.treeLock = treeLock;
        this.nestIntoMatchingNodes = nestMatchingNodes;
        HTMLDocumentImpl document = (HTMLDocumentImpl)node.getOwnerDocument();
        document.addDocumentNotificationListener(new LocalNotificationListener(document, this));
    }

    private void ensurePopulatedImpl() {
        if (this.itemsByName == null) {
            ArrayList<DOMNodeImpl> descendents = this.rootNode.getDescendents(this.nodeFilter, this.nestIntoMatchingNodes);
            this.itemsByIndex = descendents == null ? Collections.emptyList() : descendents;
            int size = descendents == null ? 0 : descendents.size();
            HashMap<String, DOMElementImpl> itemsByName = new HashMap<String, DOMElementImpl>(size * 3 / 2);
            this.itemsByName = itemsByName;
            for (int i = 0; i < size; ++i) {
                String name;
                DOMNodeImpl descNode = descendents.get(i);
                if (!(descNode instanceof DOMElementImpl)) continue;
                DOMElementImpl element = (DOMElementImpl)descNode;
                String id = element.getId();
                if (id != null && id.length() != 0) {
                    itemsByName.put(id, element);
                }
                if ((name = element.getAttribute("name")) == null || name.length() == 0 || name.equals(id)) continue;
                itemsByName.put(name, element);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidate() {
        Object object = this.treeLock;
        synchronized (object) {
            this.itemsByName = null;
            this.itemsByIndex = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isValid() {
        Object object = this.treeLock;
        synchronized (object) {
            return this.itemsByName != null && this.itemsByIndex != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLength() {
        Object object = this.treeLock;
        synchronized (object) {
            this.ensurePopulatedImpl();
            return this.itemsByIndex.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node item(int index) {
        Object object = this.treeLock;
        synchronized (object) {
            this.ensurePopulatedImpl();
            try {
                return this.itemsByIndex.get(index);
            }
            catch (IndexOutOfBoundsException iob) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node namedItem(String name) {
        Object object = this.treeLock;
        synchronized (object) {
            this.ensurePopulatedImpl();
            return this.itemsByName.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(Node node) {
        Object object = this.treeLock;
        synchronized (object) {
            this.ensurePopulatedImpl();
            return this.itemsByIndex.indexOf(node);
        }
    }

    private static class LocalNotificationListener
    extends DocumentNotificationAdapter {
        private final HTMLDocumentImpl document;
        private final WeakReference<DescendentHTMLCollection> collectionRef;

        public LocalNotificationListener(HTMLDocumentImpl document, DescendentHTMLCollection collection) {
            this.document = document;
            this.collectionRef = new WeakReference<DescendentHTMLCollection>(collection);
        }

        @Override
        public void structureInvalidated(DOMNodeImpl node) {
            DescendentHTMLCollection collection = (DescendentHTMLCollection)this.collectionRef.get();
            if (collection == null) {
                this.document.removeDocumentNotificationListener(this);
                return;
            }
            if (collection.isValid() && Nodes.isSameOrAncestorOf(collection.rootNode, node)) {
                collection.invalidate();
            }
        }

        @Override
        public void nodeLoaded(DOMNodeImpl node) {
            this.structureInvalidated(node);
        }
    }
}

