/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.domimpl.HTMLOptionsCollectionImpl;
import org.lobobrowser.html.domimpl.HTMLSelectElementImpl;
import org.lobobrowser.html.w3c.HTMLFormElement;
import org.lobobrowser.html.w3c.HTMLOptionElement;
import org.lobobrowser.html.w3c.HTMLSelectElement;
import org.w3c.dom.Node;

public class HTMLOptionElementImpl
extends HTMLElementImpl
implements HTMLOptionElement {
    private boolean selected;

    public HTMLOptionElementImpl(String name) {
        super(name, true);
    }

    @Override
    public boolean getDefaultSelected() {
        return this.getAttributeAsBoolean("selected");
    }

    @Override
    public boolean getDisabled() {
        return false;
    }

    @Override
    public HTMLFormElement getForm() {
        return this.getForm();
    }

    @Override
    public int getIndex() {
        Node parent = this.getParentNode();
        if (parent instanceof HTMLSelectElement) {
            HTMLOptionsCollectionImpl options = (HTMLOptionsCollectionImpl)((HTMLSelectElement)parent).getOptions();
            return options.indexOf(this);
        }
        return -1;
    }

    @Override
    public String getLabel() {
        return this.getAttribute("label");
    }

    @Override
    public boolean getSelected() {
        return this.selected;
    }

    @Override
    public String getText() {
        return this.getRawInnerText(false);
    }

    public void setText(String value) {
        this.setTextContent(value);
    }

    @Override
    public String getValue() {
        return this.getAttribute("value");
    }

    @Override
    public void setDefaultSelected(boolean defaultSelected) {
        this.setAttribute("selected", defaultSelected ? "selected" : null);
    }

    @Override
    public void setDisabled(boolean disabled) {
    }

    @Override
    public void setLabel(String label) {
        this.setAttribute("label", label);
    }

    void setSelectedImpl(boolean selected) {
        this.selected = selected;
    }

    @Override
    public void setSelected(boolean selected) {
        boolean changed = selected != this.selected;
        this.selected = selected;
        Node parent = this.getParentNode();
        if (parent instanceof HTMLSelectElementImpl) {
            HTMLSelectElementImpl parentSelect = (HTMLSelectElementImpl)parent;
            if (changed || parentSelect.getSelectedIndex() == -1) {
                if (selected) {
                    parentSelect.setSelectedIndexImpl(this.getIndex());
                } else {
                    int currentIndex = parentSelect.getSelectedIndex();
                    if (currentIndex != -1 && currentIndex == this.getIndex()) {
                        parentSelect.setSelectedIndexImpl(-1);
                    }
                }
            }
        }
    }

    @Override
    public void setValue(String value) {
        this.setAttribute("value", value);
    }

    @Override
    public String toString() {
        return "HTMLOptionElementImpl[text=" + this.getText() + ",selected=" + this.getSelected() + "]";
    }
}

