/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.js;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Timer;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.domimpl.HTMLIFrameElementImpl;
import org.lobobrowser.html.domimpl.HTMLImageElementImpl;
import org.lobobrowser.html.domimpl.HTMLOptionElementImpl;
import org.lobobrowser.html.domimpl.HTMLScriptElementImpl;
import org.lobobrowser.html.domimpl.HTMLSelectElementImpl;
import org.lobobrowser.html.js.Executor;
import org.lobobrowser.html.js.History;
import org.lobobrowser.html.js.Location;
import org.lobobrowser.html.js.Navigator;
import org.lobobrowser.html.js.Screen;
import org.lobobrowser.html.js.XMLHttpRequest;
import org.lobobrowser.html.jsimpl.ConsoleImpl;
import org.lobobrowser.html.w3c.ApplicationCache;
import org.lobobrowser.html.w3c.BarProp;
import org.lobobrowser.html.w3c.HTMLCollection;
import org.lobobrowser.html.w3c.HTMLElement;
import org.lobobrowser.html.w3c.MessagePort;
import org.lobobrowser.html.w3c.Selection;
import org.lobobrowser.html.w3c.StyleMedia;
import org.lobobrowser.html.w3c.UndoManager;
import org.lobobrowser.js.AbstractScriptableDelegate;
import org.lobobrowser.js.JavaClassWrapper;
import org.lobobrowser.js.JavaClassWrapperFactory;
import org.lobobrowser.js.JavaInstantiator;
import org.lobobrowser.js.JavaObjectWrapper;
import org.lobobrowser.js.JavaScript;
import org.lobobrowser.util.ID;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSS2Properties;
import org.w3c.dom.views.AbstractView;
import org.w3c.dom.views.DocumentView;

public class Window
extends AbstractScriptableDelegate
implements AbstractView {
    private static final Logger logger = Logger.getLogger(Window.class.getName());
    private static final Map<HtmlRendererContext, WeakReference<Window>> CONTEXT_WINDOWS = new WeakHashMap<HtmlRendererContext, WeakReference<Window>>();
    private static final JavaClassWrapper XMLHTTPREQUEST_WRAPPER = JavaClassWrapperFactory.getInstance().getClassWrapper(XMLHttpRequest.class);
    private static int timerIdCounter = 0;
    private final HtmlRendererContext rcontext;
    private final UserAgentContext uaContext;
    private Navigator navigator;
    private Screen screen;
    private Location location;
    private ScriptableObject windowScope;
    private History history;
    private Function onunload;
    private Map<Integer, TaskWrapper> taskMap;
    private volatile HTMLDocumentImpl document;
    private int length;
    private String name;
    private boolean lengthSet = false;
    private boolean nameSet = false;
    private Function onabort;
    private Function onafterprint;
    private Function onbeforeprint;
    private Function onbeforeunload;
    private Function onblur;
    private Function oncanplay;
    private Function oncanplaythrough;
    private Function onchange;
    private Function oncontextmenu;
    private Function ondrag;
    private Function ondragend;
    private Function ondragenter;
    private Function ondragleave;
    private Function ondragover;
    private Function ondragstart;
    private Function ondrop;
    private Function ondurationchange;
    private Function onemptied;
    private Function onended;
    private Function onerror;
    private Function onfocus;
    private Function onformchange;
    private Function onforminput;
    private Function onhashchange;
    private Function oninput;
    private Function oninvalid;
    private Function onloadeddata;
    private Function onloadedmetadata;
    private Function onloadstart;
    private Function onmessage;
    private Function onmousemove;
    private Function onmouseout;
    private Function onmousewheel;
    private Function onoffline;
    private Function ononline;
    private Function onpause;
    private Function onplay;
    private Function onplaying;
    private Function onpagehide;
    private Function onpageshow;
    private Function onpopstate;
    private Function onprogress;
    private Function onratechange;
    private Function onreadystatechange;
    private Function onredo;
    private Function onresize;
    private Function onscroll;
    private Function onseeked;
    private Function onseeking;
    private Function onselect;
    private Function onshow;
    private Function onstalled;
    private Function onstorage;
    private Function onsubmit;
    private Function onsuspend;
    private Function ontimeupdate;
    private Function onundo;
    private Function onvolumechange;
    private Function onwaiting;

    public Window(HtmlRendererContext rcontext, UserAgentContext uaContext) {
        this.rcontext = rcontext;
        this.uaContext = uaContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int generateTimerID() {
        Logger logger = Window.logger;
        synchronized (logger) {
            return timerIdCounter++;
        }
    }

    public HtmlRendererContext getHtmlRendererContext() {
        return this.rcontext;
    }

    public UserAgentContext getUserAgentContext() {
        return this.uaContext;
    }

    private void clearState() {
        Scriptable s = this.getWindowScope();
        if (s != null) {
            Object[] ids = s.getIds();
            for (int i = 0; i < ids.length; ++i) {
                Object id = ids[i];
                if (id instanceof String) {
                    s.delete((String)id);
                    continue;
                }
                if (!(id instanceof Integer)) continue;
                s.delete((Integer)id);
            }
        }
    }

    public void setDocument(HTMLDocumentImpl document) {
        HTMLDocumentImpl prevDocument = this.document;
        if (prevDocument != document) {
            if (prevDocument != null) {
                this.clearState();
            }
            this.initWindowScope(document);
            this.forgetAllTasks();
            Function onunload = this.onunload;
            if (onunload != null) {
                HTMLDocumentImpl oldDoc = this.document;
                Executor.executeFunction(this.getWindowScope(), onunload, oldDoc.getDocumentURL(), this.uaContext);
                this.onunload = null;
            }
            this.document = document;
        }
    }

    @Override
    public DocumentView getDocument() {
        return this.document;
    }

    public Document getDocumentNode() {
        return this.document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putAndStartTask(Integer timeoutID, Timer timer, Object retained) {
        TaskWrapper oldTaskWrapper = null;
        Window window = this;
        synchronized (window) {
            Map<Integer, TaskWrapper> taskMap = this.taskMap;
            if (taskMap == null) {
                this.taskMap = taskMap = new HashMap<Integer, TaskWrapper>(4);
            } else {
                oldTaskWrapper = taskMap.get(timeoutID);
            }
            taskMap.put(timeoutID, new TaskWrapper(timer, retained));
        }
        if (oldTaskWrapper != null) {
            oldTaskWrapper.timer.stop();
        }
        timer.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forgetTask(Integer timeoutID, boolean cancel) {
        TaskWrapper oldTimer = null;
        Window window = this;
        synchronized (window) {
            Map<Integer, TaskWrapper> taskMap = this.taskMap;
            if (taskMap != null) {
                oldTimer = taskMap.remove(timeoutID);
            }
        }
        if (oldTimer != null && cancel) {
            oldTimer.timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forgetAllTasks() {
        TaskWrapper[] oldTaskWrappers = null;
        Window window = this;
        synchronized (window) {
            Map<Integer, TaskWrapper> taskMap = this.taskMap;
            if (taskMap != null) {
                oldTaskWrappers = taskMap.values().toArray(new TaskWrapper[0]);
                this.taskMap = null;
            }
        }
        if (oldTaskWrappers != null) {
            for (int i = 0; i < oldTaskWrappers.length; ++i) {
                TaskWrapper taskWrapper = oldTaskWrappers[i];
                taskWrapper.timer.stop();
            }
        }
    }

    public int setInterval(Function aFunction, double aTimeInMs) {
        if (aTimeInMs > 2.147483647E9 || aTimeInMs < 0.0) {
            throw new IllegalArgumentException("Timeout value " + aTimeInMs + " is not supported.");
        }
        int timeID = Window.generateTimerID();
        Integer timeIDInt = new Integer(timeID);
        FunctionTimerTask task = new FunctionTimerTask(this, timeIDInt, aFunction, false);
        int t = (int)aTimeInMs;
        if (t < 1) {
            t = 1;
        }
        Timer timer = new Timer(t, task);
        timer.setRepeats(true);
        this.putAndStartTask(timeIDInt, timer, aFunction);
        return timeID;
    }

    public int setInterval(String aExpression, double aTimeInMs) {
        if (aTimeInMs > 2.147483647E9 || aTimeInMs < 0.0) {
            throw new IllegalArgumentException("Timeout value " + aTimeInMs + " is not supported.");
        }
        int timeID = Window.generateTimerID();
        Integer timeIDInt = new Integer(timeID);
        ExpressionTimerTask task = new ExpressionTimerTask(this, timeIDInt, aExpression, false);
        int t = (int)aTimeInMs;
        if (t < 1) {
            t = 1;
        }
        Timer timer = new Timer(t, task);
        timer.setRepeats(false);
        this.putAndStartTask(timeIDInt, timer, null);
        return timeID;
    }

    public void clearInterval(int aTimerID) {
        Integer key = new Integer(aTimerID);
        this.forgetTask(key, true);
    }

    public void alert(String message) {
        if (this.rcontext != null) {
            this.rcontext.alert(message);
        }
    }

    public void back() {
        HtmlRendererContext rcontext = this.rcontext;
        if (rcontext != null) {
            rcontext.back();
        }
    }

    public void blur() {
        HtmlRendererContext rcontext = this.rcontext;
        if (rcontext != null) {
            rcontext.blur();
        }
    }

    public void clearTimeout(int timeoutID) {
        Integer key = new Integer(timeoutID);
        this.forgetTask(key, true);
    }

    public void close() {
        HtmlRendererContext rcontext = this.rcontext;
        if (rcontext != null) {
            rcontext.close();
        }
    }

    public boolean confirm(String message) {
        HtmlRendererContext rcontext = this.rcontext;
        if (rcontext != null) {
            return rcontext.confirm(message);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object eval(String javascript) {
        HTMLDocumentImpl document = this.document;
        if (document == null) {
            throw new IllegalStateException("Cannot evaluate if document is not set.");
        }
        Context ctx = Executor.createContext(document.getDocumentURL(), this.uaContext);
        try {
            Scriptable scope = this.getWindowScope();
            if (scope == null) {
                throw new IllegalStateException("Scriptable (scope) instance was expected to be keyed as UserData to document using cobra.js.scope");
            }
            String scriptURI = "window.eval";
            if (logger.isLoggable(Level.INFO)) {
                logger.info("eval(): javascript follows...\r\n" + javascript);
            }
            Object object = ctx.evaluateString(scope, javascript, scriptURI, 1, null);
            return object;
        }
        finally {
            Context.exit();
        }
    }

    public void focus() {
        HtmlRendererContext rcontext = this.rcontext;
        if (rcontext != null) {
            rcontext.focus();
        }
    }

    private void initWindowScope(final Document doc) {
        final Scriptable ws = this.getWindowScope();
        JavaInstantiator xi = new JavaInstantiator(){

            @Override
            public Object newInstance() {
                HTMLDocumentImpl hd;
                Document d = doc;
                if (d == null) {
                    throw new IllegalStateException("Cannot perform operation when document is unset.");
                }
                try {
                    hd = (HTMLDocumentImpl)d;
                }
                catch (ClassCastException err) {
                    throw new IllegalStateException("Cannot perform operation with documents of type " + d.getClass().getName() + ".");
                }
                return new XMLHttpRequest(Window.this.uaContext, hd.getDocumentURL(), ws);
            }
        };
        Function xmlHttpRequestC = JavaObjectWrapper.getConstructor("XMLHttpRequest", XMLHTTPREQUEST_WRAPPER, ws, xi);
        ScriptableObject.defineProperty(ws, "XMLHttpRequest", xmlHttpRequestC, 1);
        this.defineElementClass(ws, doc, "Image", "img", HTMLImageElementImpl.class);
        this.defineElementClass(ws, doc, "Script", "script", HTMLScriptElementImpl.class);
        this.defineElementClass(ws, doc, "IFrame", "iframe", HTMLIFrameElementImpl.class);
        this.defineElementClass(ws, doc, "Option", "option", HTMLOptionElementImpl.class);
        this.defineElementClass(ws, doc, "Select", "select", HTMLSelectElementImpl.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Scriptable getWindowScope() {
        Window window = this;
        synchronized (window) {
            ScriptableObject scriptableObject;
            ScriptableObject windowScope = this.windowScope;
            if (windowScope != null) {
                return windowScope;
            }
            Context ctx = Context.enter();
            try {
                windowScope = (ScriptableObject)JavaScript.getInstance().getJavascriptObject(this, null);
                ctx.initStandardObjects(windowScope);
                Object consoleJSObj = JavaScript.getInstance().getJavascriptObject(new ConsoleImpl(), windowScope);
                ScriptableObject.putProperty((Scriptable)windowScope, "console", consoleJSObj);
                this.windowScope = windowScope;
                scriptableObject = windowScope;
            }
            catch (Throwable throwable) {
                Context.exit();
                throw throwable;
            }
            Context.exit();
            return scriptableObject;
        }
    }

    private final void defineElementClass(Scriptable scope, final Document document, String jsClassName, final String elementName, Class<?> javaClass) {
        JavaInstantiator ji = new JavaInstantiator(){

            @Override
            public Object newInstance() {
                Document d = document;
                if (d == null) {
                    throw new IllegalStateException("Document not set in current context.");
                }
                return d.createElement(elementName);
            }
        };
        JavaClassWrapper classWrapper = JavaClassWrapperFactory.getInstance().getClassWrapper(javaClass);
        Function constructorFunction = JavaObjectWrapper.getConstructor(jsClassName, classWrapper, scope, ji);
        ScriptableObject.defineProperty(scope, jsClassName, constructorFunction, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Window getWindow(HtmlRendererContext rcontext) {
        if (rcontext == null) {
            return null;
        }
        Map<HtmlRendererContext, WeakReference<Window>> map = CONTEXT_WINDOWS;
        synchronized (map) {
            Window window;
            Reference wref = CONTEXT_WINDOWS.get(rcontext);
            if (wref != null && (window = (Window)wref.get()) != null) {
                return window;
            }
            window = new Window(rcontext, rcontext.getUserAgentContext());
            CONTEXT_WINDOWS.put(rcontext, new WeakReference<Window>(window));
            return window;
        }
    }

    public void open(String relativeUrl, String windowName, String windowFeatures, boolean replace) {
        HtmlRendererContext rcontext = this.rcontext;
        if (rcontext != null) {
            URL url;
            HTMLDocumentImpl document = this.document;
            if (document instanceof HTMLDocumentImpl) {
                url = document.getFullURL(relativeUrl);
            } else {
                try {
                    url = new URL(relativeUrl);
                }
                catch (MalformedURLException mfu) {
                    throw new IllegalArgumentException("Malformed URI: " + relativeUrl);
                }
            }
            rcontext.open(url, windowName, windowFeatures, replace);
        }
    }

    public void open() {
        this.open("", "window:" + String.valueOf(ID.generateLong()));
    }

    public void open(String url) {
        this.open(url, "window:" + String.valueOf(ID.generateLong()));
    }

    public void open(String url, String windowName) {
        this.open(url, windowName, null, false);
    }

    public void open(String url, String windowName, String windowFeatures) {
        this.open(url, windowName, windowFeatures, false);
    }

    public String prompt(String message) {
        return this.prompt(message, "");
    }

    public String prompt(String message, int inputDefault) {
        return this.prompt(message, String.valueOf(inputDefault));
    }

    public String prompt(String message, String inputDefault) {
        HtmlRendererContext rcontext = this.rcontext;
        if (rcontext != null) {
            return rcontext.prompt(message, inputDefault);
        }
        return null;
    }

    public void scrollTo(int x, int y) {
        HtmlRendererContext rcontext = this.rcontext;
        if (rcontext != null) {
            rcontext.scroll(x, y);
        }
    }

    public void scrollBy(int x, int y) {
        HtmlRendererContext rcontext = this.rcontext;
        if (rcontext != null) {
            rcontext.scrollBy(x, y);
        }
    }

    public void resizeTo(int width, int height) {
        HtmlRendererContext rcontext = this.rcontext;
        if (rcontext != null) {
            rcontext.resizeTo(width, height);
        }
    }

    public void resizeBy(int byWidth, int byHeight) {
        HtmlRendererContext rcontext = this.rcontext;
        if (rcontext != null) {
            rcontext.resizeBy(byWidth, byHeight);
        }
    }

    public int setTimeout(String expr, double millis) {
        if (millis > 2.147483647E9 || millis < 0.0) {
            throw new IllegalArgumentException("Timeout value " + millis + " is not supported.");
        }
        int timeID = Window.generateTimerID();
        Integer timeIDInt = new Integer(timeID);
        ExpressionTimerTask task = new ExpressionTimerTask(this, timeIDInt, expr, true);
        int t = (int)millis;
        if (t < 1) {
            t = 1;
        }
        Timer timer = new Timer(t, task);
        timer.setRepeats(false);
        this.putAndStartTask(timeIDInt, timer, null);
        return timeID;
    }

    public int setTimeout(Function function, double millis) {
        if (millis > 2.147483647E9 || millis < 0.0) {
            throw new IllegalArgumentException("Timeout value " + millis + " is not supported.");
        }
        int timeID = Window.generateTimerID();
        Integer timeIDInt = new Integer(timeID);
        FunctionTimerTask task = new FunctionTimerTask(this, timeIDInt, function, true);
        int t = (int)millis;
        if (t < 1) {
            t = 1;
        }
        Timer timer = new Timer(t, task);
        timer.setRepeats(false);
        this.putAndStartTask(timeIDInt, timer, function);
        return timeID;
    }

    public boolean isClosed() {
        HtmlRendererContext rcontext = this.rcontext;
        if (rcontext != null) {
            return rcontext.isClosed();
        }
        return false;
    }

    public String getDefaultStatus() {
        HtmlRendererContext rcontext = this.rcontext;
        if (rcontext != null) {
            return rcontext.getDefaultStatus();
        }
        return null;
    }

    public HTMLCollection getFrames() {
        HTMLDocumentImpl doc = this.document;
        if (doc instanceof HTMLDocumentImpl) {
            return doc.getFrames();
        }
        return null;
    }

    public int getLength() {
        if (this.lengthSet) {
            return this.length;
        }
        HTMLCollection frames = this.getFrames();
        return frames == null ? 0 : frames.getLength();
    }

    public void setLength(int length) {
        this.lengthSet = true;
        this.length = length;
    }

    public String getName() {
        if (this.nameSet) {
            return this.name;
        }
        HtmlRendererContext rcontext = this.rcontext;
        if (rcontext != null) {
            return rcontext.getName();
        }
        return null;
    }

    public void setName(String name) {
        this.nameSet = true;
        this.name = name;
    }

    public Window getParent() {
        HtmlRendererContext rcontext = this.rcontext;
        if (rcontext != null) {
            return Window.getWindow(rcontext.getParent());
        }
        return null;
    }

    public Window getOpener() {
        HtmlRendererContext rcontext = this.rcontext;
        if (rcontext != null) {
            return Window.getWindow(rcontext.getOpener());
        }
        return null;
    }

    public void setOpener(Window opener) {
        HtmlRendererContext rcontext = this.rcontext;
        if (rcontext != null) {
            if (opener == null) {
                rcontext.setOpener(null);
            } else {
                rcontext.setOpener(opener.rcontext);
            }
        }
    }

    public Window getSelf() {
        return this;
    }

    public String getStatus() {
        HtmlRendererContext rcontext = this.rcontext;
        if (rcontext != null) {
            return rcontext.getStatus();
        }
        return null;
    }

    public void setStatus(String message) {
        HtmlRendererContext rcontext = this.rcontext;
        if (rcontext != null) {
            rcontext.setStatus(message);
        }
    }

    public Window getTop() {
        HtmlRendererContext rcontext = this.rcontext;
        if (rcontext != null) {
            return Window.getWindow(rcontext.getTop());
        }
        return null;
    }

    public Window getWindow() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Navigator getNavigator() {
        Window window = this;
        synchronized (window) {
            Navigator nav = this.navigator;
            if (nav == null) {
                this.navigator = nav = new Navigator(this.uaContext);
            }
            return nav;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Screen getScreen() {
        Window window = this;
        synchronized (window) {
            Screen nav = this.screen;
            if (nav == null) {
                this.screen = nav = new Screen();
            }
            return nav;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Location getLocation() {
        Window window = this;
        synchronized (window) {
            Location location = this.location;
            if (location == null) {
                this.location = location = new Location(this);
            }
            return location;
        }
    }

    public void setLocation(String location) {
        this.getLocation().setHref(location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public History getHistory() {
        Window window = this;
        synchronized (window) {
            History history = this.history;
            if (history == null) {
                this.history = history = new History(this);
            }
            return history;
        }
    }

    public CSS2Properties getComputedStyle(HTMLElement element, String pseudoElement) {
        if (element instanceof HTMLElementImpl) {
            return ((HTMLElementImpl)element).getComputedStyle(pseudoElement);
        }
        throw new IllegalArgumentException("Element implementation unknown: " + element);
    }

    public CSS2Properties getComputedStyle(HTMLElement elt) {
        return this.getComputedStyle(elt, null);
    }

    public Function getOnload() {
        HTMLDocumentImpl doc = this.document;
        if (doc instanceof HTMLDocumentImpl) {
            return doc.getOnloadHandler();
        }
        return null;
    }

    public void setOnload(Function onload) {
        HTMLDocumentImpl doc = this.document;
        if (doc instanceof HTMLDocumentImpl) {
            doc.setOnloadHandler(onload);
        }
    }

    public Function getOnunload() {
        return this.onunload;
    }

    public void setOnunload(Function onunload) {
        this.onunload = onunload;
    }

    public Node namedItem(String name) {
        HTMLDocumentImpl doc = this.document;
        if (doc == null) {
            return null;
        }
        Element node = doc.getElementById(name);
        if (node != null) {
            return node;
        }
        return null;
    }

    public void forceGC() {
        System.gc();
    }

    public void addEventListener(String script, Function function) {
        HTMLDocumentImpl doc = this.document;
        if (doc instanceof HTMLDocumentImpl) {
            doc.addEventListener(script, function);
        }
    }

    public void removeEventListener(String script, Function function) {
        HTMLDocumentImpl doc = this.document;
        if (doc instanceof HTMLDocumentImpl) {
            doc.removeEventListener(script, function);
        }
    }

    public UndoManager getUndoManager() {
        return null;
    }

    public Selection getSelection() {
        return null;
    }

    public Object getLocationbar() {
        return null;
    }

    public void setLocationbar(Object locationbar) {
    }

    public BarProp getMenubar() {
        return null;
    }

    public void setMenubar(BarProp menubar) {
    }

    public BarProp getPersonalbar() {
        return null;
    }

    public void setPersonalbar(BarProp personalbar) {
    }

    public BarProp getScrollbars() {
        return null;
    }

    public void setScrollbars(BarProp scrollbars) {
    }

    public BarProp getStatusbar() {
        return null;
    }

    public void setStatusbar(BarProp statusbar) {
    }

    public BarProp getToolbar() {
        return null;
    }

    public void setToolbar(BarProp toolbar) {
    }

    public void stop() {
    }

    public void setFrames(Object frames) {
    }

    public Element getFrameElement() {
        return null;
    }

    public ApplicationCache getApplicationCache() {
        return null;
    }

    public void print() {
    }

    public Object showModalDialog(String url) {
        return null;
    }

    public Object showModalDialog(String url, Object argument) {
        return null;
    }

    public void postMessage(Object message, String targetOrigin) {
    }

    public void postMessage(Object message, String targetOrigin, MessagePort[] ports) {
    }

    public Function getOnabort() {
        return this.onabort;
    }

    public void setOnabort(Function onabort) {
        this.onabort = onabort;
    }

    public Function getOnafterprint() {
        return this.onafterprint;
    }

    public void setOnafterprint(Function onafterprint) {
        this.onafterprint = onafterprint;
    }

    public Function getOnbeforeprint() {
        return this.onbeforeprint;
    }

    public void setOnbeforeprint(Function onbeforeprint) {
        this.onbeforeprint = onbeforeprint;
    }

    public Function getOnbeforeunload() {
        return this.onbeforeunload;
    }

    public void setOnbeforeunload(Function onbeforeunload) {
        this.onbeforeunload = onbeforeunload;
    }

    public Function getOnblur() {
        return this.onblur;
    }

    public void setOnblur(Function onblur) {
        this.onblur = onblur;
    }

    public Function getOncanplay() {
        return this.oncanplay;
    }

    public void setOncanplay(Function oncanplay) {
        this.oncanplay = oncanplay;
    }

    public Function getOncanplaythrough() {
        return this.oncanplaythrough;
    }

    public void setOncanplaythrough(Function oncanplaythrough) {
        this.oncanplaythrough = oncanplaythrough;
    }

    public Function getOnchange() {
        return this.onchange;
    }

    public void setOnchange(Function onchange) {
        this.onchange = onchange;
    }

    public Function getOnclick() {
        HTMLDocumentImpl doc = this.document;
        if (doc instanceof HTMLDocumentImpl) {
            return doc.getOnclick();
        }
        return null;
    }

    public void setOnclick(Function onclick) {
        HTMLDocumentImpl doc = this.document;
        if (doc instanceof HTMLDocumentImpl) {
            doc.setOnclick(onclick);
        }
    }

    public Function getOncontextmenu() {
        return this.oncontextmenu;
    }

    public void setOncontextmenu(Function oncontextmenu) {
        this.oncontextmenu = oncontextmenu;
    }

    public Function getOndblclick() {
        HTMLDocumentImpl doc = this.document;
        if (doc instanceof HTMLDocumentImpl) {
            return doc.getOndblclick();
        }
        return null;
    }

    public void setOndblclick(Function ondblclick) {
        HTMLDocumentImpl doc = this.document;
        if (doc instanceof HTMLDocumentImpl) {
            doc.setOndblclick(ondblclick);
        }
    }

    public Function getOndrag() {
        return this.ondrag;
    }

    public void setOndrag(Function ondrag) {
        this.ondrag = ondrag;
    }

    public Function getOndragend() {
        return this.ondragend;
    }

    public void setOndragend(Function ondragend) {
        this.ondragend = ondragend;
    }

    public Function getOndragenter() {
        return this.ondragenter;
    }

    public void setOndragenter(Function ondragenter) {
        this.ondragenter = ondragenter;
    }

    public Function getOndragleave() {
        return this.ondragleave;
    }

    public void setOndragleave(Function ondragleave) {
        this.ondragleave = ondragleave;
    }

    public Function getOndragover() {
        return this.ondragover;
    }

    public void setOndragover(Function ondragover) {
        this.ondragover = ondragover;
    }

    public Function getOndragstart() {
        return this.ondragstart;
    }

    public void setOndragstart(Function ondragstart) {
        this.ondragstart = ondragstart;
    }

    public Function getOndrop() {
        return this.ondrop;
    }

    public void setOndrop(Function ondrop) {
        this.ondrop = ondrop;
    }

    public Function getOndurationchange() {
        return this.ondurationchange;
    }

    public void setOndurationchange(Function ondurationchange) {
        this.ondurationchange = ondurationchange;
    }

    public Function getOnemptied() {
        return this.onemptied;
    }

    public void setOnemptied(Function onemptied) {
        this.onemptied = onemptied;
    }

    public Function getOnended() {
        return this.onended;
    }

    public void setOnended(Function onended) {
        this.onended = onended;
    }

    public Function getOnerror() {
        return this.onerror;
    }

    public void setOnerror(Function onerror) {
        this.onerror = onerror;
    }

    public Function getOnfocus() {
        return this.onfocus;
    }

    public void setOnfocus(Function onfocus) {
        this.onfocus = onfocus;
    }

    public Function getOnformchange() {
        return this.onformchange;
    }

    public void setOnformchange(Function onformchange) {
        this.onformchange = onformchange;
    }

    public Function getOnforminput() {
        return this.onforminput;
    }

    public void setOnforminput(Function onforminput) {
        this.onforminput = onforminput;
    }

    public Function getOnhashchange() {
        return this.onhashchange;
    }

    public void setOnhashchange(Function onhashchange) {
        this.onhashchange = onhashchange;
    }

    public Function getOninput() {
        return this.oninput;
    }

    public void setOninput(Function oninput) {
        this.oninput = oninput;
    }

    public Function getOninvalid() {
        return this.oninvalid;
    }

    public void setOninvalid(Function oninvalid) {
        this.oninvalid = oninvalid;
    }

    public Function getOnkeydown() {
        HTMLDocumentImpl doc = this.document;
        if (doc instanceof HTMLDocumentImpl) {
            return doc.getOnkeydown();
        }
        return null;
    }

    public void setOnkeydown(Function onkeydown) {
        HTMLDocumentImpl doc = this.document;
        if (doc instanceof HTMLDocumentImpl) {
            doc.setOnkeydown(onkeydown);
        }
    }

    public Function getOnkeypress() {
        HTMLDocumentImpl doc = this.document;
        if (doc instanceof HTMLDocumentImpl) {
            return doc.getOnkeypress();
        }
        return null;
    }

    public void setOnkeypress(Function onkeypress) {
        HTMLDocumentImpl doc = this.document;
        if (doc instanceof HTMLDocumentImpl) {
            doc.setOnkeypress(onkeypress);
        }
    }

    public Function getOnkeyup() {
        HTMLDocumentImpl doc = this.document;
        if (doc instanceof HTMLDocumentImpl) {
            return doc.getOnkeyup();
        }
        return null;
    }

    public void setOnkeyup(Function onkeyup) {
        HTMLDocumentImpl doc = this.document;
        if (doc instanceof HTMLDocumentImpl) {
            doc.setOnkeyup(onkeyup);
        }
    }

    public Function getOnloadeddata() {
        return this.onloadeddata;
    }

    public void setOnloadeddata(Function onloadeddata) {
        this.onloadeddata = onloadeddata;
    }

    public Function getOnloadedmetadata() {
        return this.onloadedmetadata;
    }

    public void setOnloadedmetadata(Function onloadedmetadata) {
        this.onloadedmetadata = onloadedmetadata;
    }

    public Function getOnloadstart() {
        return this.onloadstart;
    }

    public void setOnloadstart(Function onloadstart) {
        this.onloadstart = onloadstart;
    }

    public Function getOnmessage() {
        return this.onmessage;
    }

    public void setOnmessage(Function onmessage) {
        this.onmessage = onmessage;
    }

    public Function getOnmousedown() {
        HTMLDocumentImpl doc = this.document;
        if (doc instanceof HTMLDocumentImpl) {
            return doc.getOnmousedown();
        }
        return null;
    }

    public void setOnmousedown(Function onmousedown) {
        HTMLDocumentImpl doc = this.document;
        if (doc instanceof HTMLDocumentImpl) {
            doc.setOnmousedown(onmousedown);
        }
    }

    public Function getOnmousemove() {
        return this.onmousemove;
    }

    public void setOnmousemove(Function onmousemove) {
        this.onmousemove = onmousemove;
    }

    public Function getOnmouseout() {
        return this.onmouseout;
    }

    public void setOnmouseout(Function onmouseout) {
        this.onmouseout = onmouseout;
    }

    public Function getOnmouseover() {
        HTMLDocumentImpl doc = this.document;
        if (doc instanceof HTMLDocumentImpl) {
            return doc.getOnmouseover();
        }
        return null;
    }

    public void setOnmouseover(Function onmouseover) {
        HTMLDocumentImpl doc = this.document;
        if (doc instanceof HTMLDocumentImpl) {
            doc.setOnmouseover(onmouseover);
        }
    }

    public Function getOnmouseup() {
        HTMLDocumentImpl doc = this.document;
        if (doc instanceof HTMLDocumentImpl) {
            return doc.getOnmouseup();
        }
        return null;
    }

    public void setOnmouseup(Function onmouseup) {
        HTMLDocumentImpl doc = this.document;
        if (doc instanceof HTMLDocumentImpl) {
            doc.setOnmouseup(onmouseup);
        }
    }

    public Function getOnmousewheel() {
        return this.onmousewheel;
    }

    public void setOnmousewheel(Function onmousewheel) {
        this.onmousewheel = onmousewheel;
    }

    public Function getOnoffline() {
        return this.onoffline;
    }

    public void setOnoffline(Function onoffline) {
        this.onoffline = onoffline;
    }

    public Function getOnonline() {
        return this.ononline;
    }

    public void setOnonline(Function ononline) {
        this.ononline = ononline;
    }

    public Function getOnpause() {
        return this.onpause;
    }

    public void setOnpause(Function onpause) {
        this.onpause = onpause;
    }

    public Function getOnplay() {
        return this.onplay;
    }

    public void setOnplay(Function onplay) {
        this.onplay = onplay;
    }

    public Function getOnplaying() {
        return this.onplaying;
    }

    public void setOnplaying(Function onplaying) {
        this.onplaying = onplaying;
    }

    public Function getOnpagehide() {
        return this.onpagehide;
    }

    public void setOnpagehide(Function onpagehide) {
        this.onpagehide = onpagehide;
    }

    public Function getOnpageshow() {
        return this.onpageshow;
    }

    public void setOnpageshow(Function onpageshow) {
        this.onpageshow = onpageshow;
    }

    public Function getOnpopstate() {
        return this.onpopstate;
    }

    public void setOnpopstate(Function onpopstate) {
        this.onpopstate = onpopstate;
    }

    public Function getOnprogress() {
        return this.onprogress;
    }

    public void setOnprogress(Function onprogress) {
        this.onprogress = onprogress;
    }

    public Function getOnratechange() {
        return this.onratechange;
    }

    public void setOnratechange(Function onratechange) {
        this.onratechange = onratechange;
    }

    public Function getOnreadystatechange() {
        return this.onreadystatechange;
    }

    public void setOnreadystatechange(Function onreadystatechange) {
        this.onreadystatechange = onreadystatechange;
    }

    public Function getOnredo() {
        return this.onredo;
    }

    public void setOnredo(Function onredo) {
        this.onredo = onredo;
    }

    public Function getOnresize() {
        return this.onresize;
    }

    public void setOnresize(Function onresize) {
        this.onresize = onresize;
    }

    public Function getOnscroll() {
        return this.onscroll;
    }

    public void setOnscroll(Function onscroll) {
        this.onscroll = onscroll;
    }

    public Function getOnseeked() {
        return this.onseeked;
    }

    public void setOnseeked(Function onseeked) {
        this.onseeked = onseeked;
    }

    public Function getOnseeking() {
        return this.onseeking;
    }

    public void setOnseeking(Function onseeking) {
        this.onseeking = onseeking;
    }

    public Function getOnselect() {
        return this.onselect;
    }

    public void setOnselect(Function onselect) {
        this.onselect = onselect;
    }

    public Function getOnshow() {
        return this.onshow;
    }

    public void setOnshow(Function onshow) {
        this.onshow = onshow;
    }

    public Function getOnstalled() {
        return this.onstalled;
    }

    public void setOnstalled(Function onstalled) {
        this.onstalled = onstalled;
    }

    public Function getOnstorage() {
        return this.onstorage;
    }

    public void setOnstorage(Function onstorage) {
        this.onstorage = onstorage;
    }

    public Function getOnsubmit() {
        return this.onsubmit;
    }

    public void setOnsubmit(Function onsubmit) {
        this.onsubmit = onsubmit;
    }

    public Function getOnsuspend() {
        return this.onsuspend;
    }

    public void setOnsuspend(Function onsuspend) {
        this.onsuspend = onsuspend;
    }

    public Function getOntimeupdate() {
        return this.ontimeupdate;
    }

    public void setOntimeupdate(Function ontimeupdate) {
        this.ontimeupdate = ontimeupdate;
    }

    public Function getOnundo() {
        return this.onundo;
    }

    public void setOnundo(Function onundo) {
        this.onundo = onundo;
    }

    public Function getOnvolumechange() {
        return this.onvolumechange;
    }

    public void setOnvolumechange(Function onvolumechange) {
        this.onvolumechange = onvolumechange;
    }

    public Function getOnwaiting() {
        return this.onwaiting;
    }

    public void setOnwaiting(Function onwaiting) {
        this.onwaiting = onwaiting;
    }

    public StyleMedia getStyleMedia() {
        return null;
    }

    public int getInnerWidth() {
        return 0;
    }

    public int getInnerHeight() {
        return 0;
    }

    public int getPageXOffset() {
        return 0;
    }

    public int getPageYOffset() {
        return 0;
    }

    public void scroll(int x, int y) {
    }

    public int getScreenX() {
        return 0;
    }

    public int getScreenY() {
        return 0;
    }

    public int getOuterWidth() {
        return 0;
    }

    public int getOuterHeight() {
        return 0;
    }

    private static class TaskWrapper {
        public final Timer timer;
        private final Object retained;

        public TaskWrapper(Timer timer, Object retained) {
            this.timer = timer;
            this.retained = retained;
        }
    }

    private static class ExpressionTimerTask
    extends WeakWindowTask {
        private final Integer timeIDInt;
        private final String expression;
        private final boolean removeTask;

        public ExpressionTimerTask(Window window, Integer timeIDInt, String expression, boolean removeTask) {
            super(window);
            this.timeIDInt = timeIDInt;
            this.expression = expression;
            this.removeTask = removeTask;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                HTMLDocumentImpl doc;
                Window window = this.getWindow();
                if (window == null) {
                    if (logger.isLoggable(Level.INFO)) {
                        logger.info("actionPerformed(): Window is no longer available.");
                    }
                    return;
                }
                if (this.removeTask) {
                    window.forgetTask(this.timeIDInt, false);
                }
                if ((doc = (HTMLDocumentImpl)window.getDocument()) == null) {
                    throw new IllegalStateException("Cannot perform operation when document is unset.");
                }
                window.eval(this.expression);
            }
            catch (Throwable err) {
                logger.log(Level.WARNING, "actionPerformed()", err);
            }
        }
    }

    private static class FunctionTimerTask
    extends WeakWindowTask {
        private final Integer timeIDInt;
        private final WeakReference<Function> functionRef;
        private final boolean removeTask;

        public FunctionTimerTask(Window window, Integer timeIDInt, Function function, boolean removeTask) {
            super(window);
            this.timeIDInt = timeIDInt;
            this.functionRef = new WeakReference<Function>(function);
            this.removeTask = removeTask;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                HTMLDocumentImpl doc;
                Window window = this.getWindow();
                if (window == null) {
                    if (logger.isLoggable(Level.INFO)) {
                        logger.info("actionPerformed(): Window is no longer available.");
                    }
                    return;
                }
                if (this.removeTask) {
                    window.forgetTask(this.timeIDInt, false);
                }
                if ((doc = (HTMLDocumentImpl)window.getDocument()) == null) {
                    throw new IllegalStateException("Cannot perform operation when document is unset.");
                }
                Function function = (Function)this.functionRef.get();
                if (function == null) {
                    throw new IllegalStateException("Cannot perform operation. Function is no longer available.");
                }
                Executor.executeFunction(window.getWindowScope(), function, doc.getDocumentURL(), window.getUserAgentContext());
            }
            catch (Throwable err) {
                logger.log(Level.WARNING, "actionPerformed()", err);
            }
        }
    }

    private static abstract class WeakWindowTask
    implements ActionListener {
        private final WeakReference<Window> windowRef;

        public WeakWindowTask(Window window) {
            this.windowRef = new WeakReference<Window>(window);
        }

        protected Window getWindow() {
            WeakReference<Window> ref = this.windowRef;
            return ref == null ? null : (Window)ref.get();
        }
    }
}

