/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.layout;

import org.lobobrowser.html.dombl.UINode;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.renderer.BaseBoundableRenderable;
import org.lobobrowser.html.renderer.MarkupLayout;
import org.lobobrowser.html.renderer.RBlockViewport;
import org.lobobrowser.html.renderstate.RenderState;

public abstract class CommonLayout
implements MarkupLayout {
    protected static final int DISPLAY_NONE = 0;
    protected static final int DISPLAY_INLINE = 1;
    protected static final int DISPLAY_BLOCK = 2;
    protected static final int DISPLAY_LIST_ITEM = 3;
    protected static final int DISPLAY_TABLE = 6;
    protected static final int DISPLAY_INLINE_BLOCK = 8;
    private final int display;

    public CommonLayout(int defaultDisplay) {
        this.display = defaultDisplay;
    }

    @Override
    public void layoutMarkup(RBlockViewport bodyLayout, HTMLElementImpl markupElement) {
        RenderState rs = markupElement.getRenderState();
        int display = 0;
        if (!markupElement.getHidden()) {
            display = 0;
        } else {
            int n = display = rs == null ? this.display : rs.getDisplay();
        }
        if (display == 1) {
            int position;
            int n = position = rs == null ? 0 : rs.getPosition();
            if (position == 1 || position == 3) {
                display = 2;
            } else {
                int boxFloat;
                int n2 = boxFloat = rs == null ? 0 : rs.getFloat();
                if (boxFloat != 0) {
                    display = 2;
                }
            }
        }
        switch (display) {
            case 0: {
                UINode node = markupElement.getUINode();
                if (!(node instanceof BaseBoundableRenderable)) break;
                ((BaseBoundableRenderable)((Object)node)).markLayoutValid();
                break;
            }
            case 2: {
                bodyLayout.layoutRBlock(markupElement);
                break;
            }
            case 3: {
                String tagName = markupElement.getTagName();
                if ("UL".equalsIgnoreCase(tagName) || "OL".equalsIgnoreCase(tagName)) {
                    bodyLayout.layoutList(markupElement);
                    break;
                }
                bodyLayout.layoutListItem(markupElement);
                break;
            }
            case 6: {
                bodyLayout.layoutRTable(markupElement);
                break;
            }
            case 8: {
                bodyLayout.layoutRInlineBlock(markupElement);
                break;
            }
            default: {
                bodyLayout.layoutMarkup(markupElement);
            }
        }
    }
}

