/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.layout;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.html.dombl.UINode;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.renderer.MarkupLayout;
import org.lobobrowser.html.renderer.RBlockViewport;
import org.lobobrowser.html.renderer.RElement;
import org.lobobrowser.html.style.AbstractCSS2Properties;

public abstract class CommonWidgetLayout
implements MarkupLayout {
    private static final Logger logger = Logger.getLogger(CommonWidgetLayout.class.getName());
    protected static final int ADD_INLINE = 0;
    protected static final int ADD_AS_BLOCK = 1;
    private final int method;
    private final boolean useAlignAttribute;

    public CommonWidgetLayout(int method, boolean usesAlignAttribute) {
        this.method = method;
        this.useAlignAttribute = usesAlignAttribute;
    }

    @Override
    public void layoutMarkup(RBlockViewport bodyLayout, HTMLElementImpl markupElement) {
        String display;
        AbstractCSS2Properties style = markupElement.getCurrentStyle();
        if (style != null && (display = style.getDisplay()) != null && "none".equalsIgnoreCase(display)) {
            return;
        }
        UINode node = markupElement.getUINode();
        RElement renderable = null;
        if (node == null) {
            renderable = this.createRenderable(bodyLayout, markupElement);
            if (renderable == null) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("layoutMarkup(): Don't know how to render " + markupElement + ".");
                }
                return;
            }
            markupElement.setUINode(renderable);
        } else {
            renderable = (RElement)node;
        }
        renderable.setOriginalParent(bodyLayout);
        switch (this.method) {
            case 0: {
                bodyLayout.addRenderableToLineCheckStyle(renderable, markupElement, this.useAlignAttribute);
                break;
            }
            case 1: {
                bodyLayout.positionRElement(markupElement, renderable, this.useAlignAttribute, true, false);
            }
        }
    }

    protected abstract RElement createRenderable(RBlockViewport var1, HTMLElementImpl var2);
}

