/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.html.HtmlMapping;
import org.lobobrowser.html.HtmlMappingChar;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.io.WritableLineReader;
import org.lobobrowser.html.parser.ElementInfo;
import org.lobobrowser.html.parser.StopException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class HtmlParser {
    private static final Logger logger = Logger.getLogger(HtmlParser.class.getName());
    private final Document document;
    private final UserAgentContext ucontext;
    private final String publicId;
    private final String systemId;
    private static Map<String, Character> ENTITIES = new HashMap<String, Character>(256);
    private static Map<String, ElementInfo> ELEMENT_INFOS = new HashMap<String, ElementInfo>(35);
    public static final String MODIFYING_KEY = "cobra.suspend";
    private static final int TOKEN_EOD = 0;
    private static final int TOKEN_COMMENT = 1;
    private static final int TOKEN_TEXT = 2;
    private static final int TOKEN_BEGIN_ELEMENT = 3;
    private static final int TOKEN_END_ELEMENT = 4;
    private static final int TOKEN_FULL_ELEMENT = 5;
    private static final int TOKEN_BAD = 6;
    private String normalLastTag = null;
    private boolean justReadTagBegin = false;
    private boolean justReadTagEnd = false;
    private boolean justReadEmptyElement = false;

    public HtmlParser(UserAgentContext ucontext, Document document, ErrorHandler errorHandler, String publicId, String systemId) {
        this.ucontext = ucontext;
        this.document = document;
        this.publicId = publicId;
        this.systemId = systemId;
    }

    public HtmlParser(UserAgentContext ucontext, Document document) {
        this.ucontext = ucontext;
        this.document = document;
        this.publicId = null;
        this.systemId = null;
    }

    public static boolean isDecodeEntities(String elementName) {
        ElementInfo einfo = ELEMENT_INFOS.get(elementName.toUpperCase());
        return einfo == null ? true : einfo.decodeEntities;
    }

    public void parse(InputStream in) throws IOException, SAXException, UnsupportedEncodingException {
        this.parse(in, "ISO-8859-1");
    }

    public void parse(InputStream in, String charset) throws IOException, SAXException, UnsupportedEncodingException {
        WritableLineReader reader = new WritableLineReader(new InputStreamReader(in, charset));
        this.parse(reader);
    }

    public void parse(Reader reader) throws IOException, SAXException {
        this.parse(new LineNumberReader(reader));
    }

    public void parse(LineNumberReader reader) throws IOException, SAXException {
        Document doc = this.document;
        this.parse(reader, (Node)doc);
    }

    public void parse(Reader reader, Node parent) throws IOException, SAXException {
        this.parse(new LineNumberReader(reader), parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(LineNumberReader reader, Node parent) throws IOException, SAXException {
        try {
            parent.setUserData(MODIFYING_KEY, Boolean.TRUE, null);
            try {
                while (this.parseToken(parent, reader, null, new LinkedList<String>()) != 0) {
                }
            }
            catch (StopException se) {
                throw new SAXException("Unexpected flow exception", se);
            }
        }
        finally {
            parent.setUserData(MODIFYING_KEY, Boolean.FALSE, null);
        }
    }

    /*
     * Exception decompiling
     */
    private final int parseToken(Node parent, LineNumberReader reader, Set<String> stopTags, LinkedList<String> ancestors) throws IOException, StopException, SAXException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[TRYBLOCK]], but top level block is 28[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final StringBuffer readUpToTagBegin(LineNumberReader reader) throws IOException, SAXException {
        int intCh;
        StringBuffer sb = null;
        while ((intCh = reader.read()) != -1) {
            char ch = (char)intCh;
            if (ch == '<') {
                this.justReadTagBegin = true;
                this.justReadTagEnd = false;
                this.justReadEmptyElement = false;
                if (sb == null) {
                    sb = new StringBuffer(0);
                }
                return sb;
            }
            if (sb == null) {
                sb = new StringBuffer();
            }
            sb.append(ch);
        }
        this.justReadTagBegin = false;
        this.justReadTagEnd = false;
        this.justReadEmptyElement = false;
        return sb;
    }

    private final int parseForEndTag(Node parent, LineNumberReader reader, String tagName, boolean addTextNode, boolean decodeEntities) throws IOException, SAXException {
        int intCh;
        Document doc = this.document;
        StringBuffer sb = new StringBuffer();
        while ((intCh = reader.read()) != -1) {
            char ch = (char)intCh;
            if (ch == '<' && (intCh = reader.read()) != -1) {
                ch = (char)intCh;
                if (ch == '/') {
                    StringBuffer tempBuffer = new StringBuffer();
                    while ((intCh = reader.read()) != -1) {
                        ch = (char)intCh;
                        if (ch == '>') {
                            String thisTag = tempBuffer.toString().trim();
                            if (!thisTag.equalsIgnoreCase(tagName)) break;
                            this.justReadTagBegin = false;
                            this.justReadTagEnd = true;
                            this.justReadEmptyElement = false;
                            this.normalLastTag = thisTag.toUpperCase();
                            if (addTextNode) {
                                String text;
                                if (decodeEntities) {
                                    sb = this.entityDecode(sb);
                                }
                                if ((text = sb.toString()).length() != 0) {
                                    Text textNode = doc.createTextNode(text);
                                    parent.appendChild(textNode);
                                }
                            }
                            return 4;
                        }
                        tempBuffer.append(ch);
                    }
                    sb.append("</");
                    sb.append(tempBuffer);
                } else {
                    sb.append('<');
                }
            }
            sb.append(ch);
        }
        this.justReadTagBegin = false;
        this.justReadTagEnd = false;
        this.justReadEmptyElement = false;
        if (addTextNode) {
            String text;
            if (decodeEntities) {
                sb = this.entityDecode(sb);
            }
            if ((text = sb.toString()).length() != 0) {
                Text textNode = doc.createTextNode(text);
                parent.appendChild(textNode);
            }
        }
        return 0;
    }

    private final String readTag(Node parent, LineNumberReader reader) throws IOException {
        StringBuffer sb = new StringBuffer();
        int chInt = reader.read();
        if (chInt != -1) {
            char ch;
            boolean cont = true;
            while (!Character.isLetter(ch = (char)chInt)) {
                block23: {
                    Text textNode;
                    Document doc;
                    StringBuffer ltText;
                    if (ch == '!') {
                        sb.append('!');
                        chInt = reader.read();
                        if (chInt != -1) {
                            ch = (char)chInt;
                            if (ch != '-') break;
                            sb.append('-');
                            chInt = reader.read();
                            if (chInt != -1) {
                                ch = (char)chInt;
                                if (ch != '-') break;
                                sb.append('-');
                                cont = false;
                                break;
                            }
                            cont = false;
                            break;
                        }
                        cont = false;
                        break;
                    }
                    if (ch == '/') {
                        sb.append(ch);
                        chInt = reader.read();
                        if (chInt != -1) {
                            ch = (char)chInt;
                            break;
                        }
                        cont = false;
                        break;
                    }
                    if (ch == '<') {
                        block22: {
                            ltText = new StringBuffer(3);
                            ltText.append('<');
                            while ((chInt = reader.read()) == 60) {
                                ltText.append('<');
                            }
                            doc = this.document;
                            textNode = doc.createTextNode(ltText.toString());
                            try {
                                parent.appendChild(textNode);
                            }
                            catch (DOMException de) {
                                if (parent.getNodeType() == 9 && de.code == 3) break block22;
                                logger.log(Level.WARNING, "parseToken(): Unable to append child to " + parent + ".", de);
                            }
                        }
                        if (chInt != -1) continue;
                        cont = false;
                        break;
                    }
                    if (!Character.isWhitespace(ch)) break;
                    ltText = new StringBuffer();
                    ltText.append('<');
                    ltText.append(ch);
                    while ((chInt = reader.read()) != -1) {
                        ch = (char)chInt;
                        if (ch == '<') {
                            chInt = reader.read();
                            break;
                        }
                        ltText.append(ch);
                    }
                    doc = this.document;
                    textNode = doc.createTextNode(ltText.toString());
                    try {
                        parent.appendChild(textNode);
                    }
                    catch (DOMException de) {
                        if (parent.getNodeType() == 9 && de.code == 3) break block23;
                        logger.log(Level.WARNING, "parseToken(): Unable to append child to " + parent + ".", de);
                    }
                }
                if (chInt != -1) continue;
                cont = false;
                break;
            }
            if (cont) {
                boolean lastCharSlash = false;
                while (!Character.isWhitespace(ch)) {
                    if (ch == '>') {
                        this.justReadTagEnd = true;
                        this.justReadTagBegin = false;
                        this.justReadEmptyElement = lastCharSlash;
                        String tag = sb.toString();
                        return tag;
                    }
                    if (ch == '/') {
                        lastCharSlash = true;
                    } else {
                        if (lastCharSlash) {
                            sb.append('/');
                        }
                        lastCharSlash = false;
                        sb.append(ch);
                    }
                    chInt = reader.read();
                    if (chInt == -1) break;
                    ch = (char)chInt;
                }
            }
        }
        if (sb.length() > 0) {
            this.justReadTagEnd = false;
            this.justReadTagBegin = false;
            this.justReadEmptyElement = false;
        }
        String tag = sb.toString();
        return tag;
    }

    private final StringBuffer passEndOfComment(LineNumberReader reader) throws IOException {
        int chInt;
        if (this.justReadTagEnd) {
            return new StringBuffer(0);
        }
        StringBuffer sb = new StringBuffer();
        block0: while ((chInt = reader.read()) != -1) {
            char ch = (char)chInt;
            if (ch == '-') {
                chInt = reader.read();
                if (chInt == -1) {
                    sb.append(ch);
                    break;
                }
                ch = (char)chInt;
                if (ch == '-') {
                    StringBuffer extra = null;
                    while (true) {
                        if ((chInt = reader.read()) == -1) {
                            if (extra == null) break block0;
                            sb.append(extra.toString());
                            break block0;
                        }
                        ch = (char)chInt;
                        if (ch == '>') {
                            this.justReadTagBegin = false;
                            this.justReadTagEnd = true;
                            return sb;
                        }
                        if (ch == '-') {
                            if (extra == null) {
                                extra = new StringBuffer();
                                extra.append("--");
                            }
                            extra.append("-");
                            continue;
                        }
                        if (!Character.isWhitespace(ch)) break;
                        if (extra == null) {
                            extra = new StringBuffer();
                            extra.append("--");
                        }
                        extra.append(ch);
                    }
                    if (extra != null) {
                        sb.append(extra.toString());
                    }
                    sb.append(ch);
                    continue;
                }
                sb.append('-');
                sb.append(ch);
                continue;
            }
            sb.append(ch);
        }
        if (sb.length() > 0) {
            this.justReadTagBegin = false;
            this.justReadTagEnd = false;
        }
        return sb;
    }

    private final void passEndOfTag(Reader reader) throws IOException {
        int chInt;
        if (this.justReadTagEnd) {
            return;
        }
        boolean readSomething = false;
        while ((chInt = reader.read()) != -1) {
            readSomething = true;
            char ch = (char)chInt;
            if (ch != '>') continue;
            this.justReadTagEnd = true;
            this.justReadTagBegin = false;
            return;
        }
        if (readSomething) {
            this.justReadTagBegin = false;
            this.justReadTagEnd = false;
        }
    }

    private final StringBuffer readProcessingInstruction(LineNumberReader reader) throws IOException {
        StringBuffer pidata = new StringBuffer();
        if (this.justReadTagEnd) {
            return pidata;
        }
        int ch = reader.read();
        while (ch != -1 && ch != 62) {
            pidata.append((char)ch);
            ch = reader.read();
        }
        this.justReadTagBegin = false;
        this.justReadTagEnd = ch != -1;
        return pidata;
    }

    private final boolean readAttribute(LineNumberReader reader, Element element) throws IOException, SAXException {
        int ch;
        int chInt;
        if (this.justReadTagEnd) {
            return false;
        }
        StringBuffer attributeName = null;
        boolean blankFound = false;
        boolean lastCharSlash = false;
        while (true) {
            String attributeNameStr;
            int chInt2;
            if ((chInt2 = reader.read()) == -1) {
                if (attributeName != null && attributeName.length() != 0) {
                    String attributeNameStr2 = attributeName.toString();
                    element.setAttribute(attributeNameStr2, attributeNameStr2);
                    attributeName.setLength(0);
                }
                this.justReadTagBegin = false;
                this.justReadTagEnd = false;
                this.justReadEmptyElement = false;
                return false;
            }
            char ch2 = (char)chInt2;
            if (ch2 == '=') break;
            if (ch2 == '>') {
                if (attributeName != null && attributeName.length() != 0) {
                    attributeNameStr = attributeName.toString();
                    element.setAttribute(attributeNameStr, attributeNameStr);
                }
                this.justReadTagBegin = false;
                this.justReadTagEnd = true;
                this.justReadEmptyElement = lastCharSlash;
                return false;
            }
            if (ch2 == '/') {
                blankFound = true;
                lastCharSlash = true;
                continue;
            }
            if (Character.isWhitespace(ch2)) {
                lastCharSlash = false;
                blankFound = true;
                continue;
            }
            lastCharSlash = false;
            if (blankFound) {
                blankFound = false;
                if (attributeName != null && attributeName.length() != 0) {
                    attributeNameStr = attributeName.toString();
                    element.setAttribute(attributeNameStr, attributeNameStr);
                    attributeName.setLength(0);
                }
            }
            if (attributeName == null) {
                attributeName = new StringBuffer(6);
            }
            attributeName.append(ch2);
        }
        lastCharSlash = false;
        blankFound = false;
        StringBuffer attributeValue = null;
        int openQuote = -1;
        while ((chInt = reader.read()) != -1) {
            ch = chInt;
            if (ch == 62) {
                if (attributeName != null && attributeName.length() != 0) {
                    String attributeNameStr = attributeName.toString();
                    element.setAttribute(attributeNameStr, attributeNameStr);
                }
                this.justReadTagBegin = false;
                this.justReadTagEnd = true;
                this.justReadEmptyElement = lastCharSlash;
                return false;
            }
            if (ch == 47) {
                lastCharSlash = true;
                continue;
            }
            if (Character.isWhitespace((char)ch)) {
                lastCharSlash = false;
                continue;
            }
            if (ch == 34) {
                openQuote = 34;
            } else if (ch == 39) {
                openQuote = 39;
            } else {
                openQuote = -1;
                if (attributeValue == null) {
                    attributeValue = new StringBuffer(6);
                }
                if (lastCharSlash) {
                    attributeValue.append('/');
                }
                attributeValue.append((char)ch);
            }
            lastCharSlash = false;
            break;
        }
        while ((chInt = reader.read()) != -1) {
            ch = (char)chInt;
            if (openQuote != -1 && ch == openQuote) {
                lastCharSlash = false;
                if (attributeName != null) {
                    String attributeNameStr = attributeName.toString();
                    if (attributeValue == null) {
                        element.setAttribute(attributeNameStr, "");
                    } else {
                        StringBuffer actualAttributeValue = this.entityDecode(attributeValue);
                        element.setAttribute(attributeNameStr, actualAttributeValue.toString());
                    }
                }
                this.justReadTagBegin = false;
                this.justReadTagEnd = false;
                return true;
            }
            if (openQuote == -1 && ch == 62) {
                if (attributeName != null) {
                    String attributeNameStr = attributeName.toString();
                    if (attributeValue == null) {
                        element.setAttribute(attributeNameStr, null);
                    } else {
                        StringBuffer actualAttributeValue = this.entityDecode(attributeValue);
                        element.setAttribute(attributeNameStr, actualAttributeValue.toString());
                    }
                }
                this.justReadTagBegin = false;
                this.justReadTagEnd = true;
                this.justReadEmptyElement = lastCharSlash;
                return false;
            }
            if (openQuote == -1 && Character.isWhitespace((char)ch)) {
                lastCharSlash = false;
                if (attributeName != null) {
                    String attributeNameStr = attributeName.toString();
                    if (attributeValue == null) {
                        element.setAttribute(attributeNameStr, null);
                    } else {
                        StringBuffer actualAttributeValue = this.entityDecode(attributeValue);
                        element.setAttribute(attributeNameStr, actualAttributeValue.toString());
                    }
                }
                this.justReadTagBegin = false;
                this.justReadTagEnd = false;
                return true;
            }
            if (attributeValue == null) {
                attributeValue = new StringBuffer(6);
            }
            if (lastCharSlash) {
                attributeValue.append('/');
            }
            lastCharSlash = false;
            attributeValue.append((char)ch);
        }
        this.justReadTagBegin = false;
        this.justReadTagEnd = false;
        if (attributeName != null) {
            String attributeNameStr = attributeName.toString();
            if (attributeValue == null) {
                element.setAttribute(attributeNameStr, null);
            } else {
                StringBuffer actualAttributeValue = this.entityDecode(attributeValue);
                element.setAttribute(attributeNameStr, actualAttributeValue.toString());
            }
        }
        return false;
    }

    private final StringBuffer entityDecode(StringBuffer rawText) throws SAXException {
        int startIdx = 0;
        StringBuffer sb = null;
        while (true) {
            int ampIdx;
            if ((ampIdx = rawText.indexOf("&", startIdx)) == -1) {
                if (sb == null) {
                    return rawText;
                }
                sb.append(rawText.substring(startIdx));
                return sb;
            }
            if (sb == null) {
                sb = new StringBuffer();
            }
            sb.append(rawText.substring(startIdx, ampIdx));
            int colonIdx = rawText.indexOf(";", ampIdx);
            if (colonIdx == -1) {
                sb.append('&');
                startIdx = ampIdx + 1;
                continue;
            }
            String spec = rawText.substring(ampIdx + 1, colonIdx);
            if (spec.startsWith("#")) {
                int decimal;
                String number = spec.substring(1).toLowerCase();
                try {
                    decimal = number.startsWith("x") ? Integer.parseInt(number.substring(1), 16) : Integer.parseInt(number);
                }
                catch (NumberFormatException nfe) {
                    logger.log(Level.WARNING, "entityDecode()", nfe);
                    decimal = 0;
                }
                sb.append((char)decimal);
            } else {
                int chInt = this.getEntityChar(spec);
                if (chInt == -1) {
                    sb.append('&');
                    sb.append(spec);
                    sb.append(';');
                } else {
                    sb.append((char)chInt);
                }
            }
            startIdx = colonIdx + 1;
        }
    }

    private final int getEntityChar(String spec) {
        String specTL;
        Character c = ENTITIES.get(spec);
        if (c == null && (c = ENTITIES.get(specTL = spec.toLowerCase())) == null) {
            return -1;
        }
        return c.charValue();
    }

    static {
        ENTITIES = HtmlMappingChar.mappingChar();
        ELEMENT_INFOS = HtmlMapping.mappingTag();
    }
}

