/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.main;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.util.logging.Logger;
import org.lobobrowser.main.PlatformInit;
import org.lobobrowser.main.ReuseServer;
import org.lobobrowser.store.StorageManager;

public class ReuseManager {
    private static final Logger logger = Logger.getLogger(ReuseManager.class.getName());
    private static final ReuseManager instance = new ReuseManager();
    private static final String PORT_FILE = "port.dat";

    private ReuseManager() {
    }

    public static ReuseManager getInstance() throws Exception {
        return instance;
    }

    public void shutdown() {
        try {
            File appHome = StorageManager.getInstance().getAppHome();
            File portFile = new File(appHome, PORT_FILE);
            portFile.delete();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launch(String[] args) throws Exception {
        boolean launched = false;
        try {
            InetAddress bindHost = InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
            File appHome = StorageManager.getInstance().getAppHome();
            File portFile = new File(appHome, PORT_FILE);
            for (int tries = 0; tries < 5; ++tries) {
                OutputStream out;
                int port = -1;
                try {
                    FileInputStream in = new FileInputStream(portFile);
                    DataInputStream din = new DataInputStream(in);
                    try {
                        port = din.readInt();
                    }
                    finally {
                        din.close();
                        ((InputStream)in).close();
                    }
                }
                catch (EOFException eofe) {
                    eofe.printStackTrace(System.err);
                    portFile.delete();
                }
                catch (FileNotFoundException eofe) {
                    // empty catch block
                }
                if (port != -1) {
                    Socket s = new Socket(bindHost, port);
                    try {
                        s.setTcpNoDelay(true);
                        out = s.getOutputStream();
                        try {
                            OutputStreamWriter writer = new OutputStreamWriter(out);
                            boolean hadPath = false;
                            for (int i = 0; i < args.length; ++i) {
                                String url = args[i];
                                if (url.startsWith("-")) continue;
                                hadPath = true;
                                writer.write("LAUNCH " + args[i]);
                                writer.write("\r\n");
                            }
                            if (!hadPath) {
                                writer.write("LAUNCH_BLANK");
                                writer.write("\r\n");
                            }
                            writer.flush();
                            launched = true;
                        }
                        finally {
                            out.close();
                        }
                    }
                    catch (IOException ioe) {
                        portFile.delete();
                    }
                    finally {
                        s.close();
                    }
                }
                if (launched) break;
                ReuseServer server = new ReuseServer();
                port = server.start(bindHost);
                if (portFile.createNewFile()) {
                    out = new FileOutputStream(portFile);
                    DataOutputStream dout = new DataOutputStream(out);
                    try {
                        dout.writeInt(port);
                        dout.flush();
                        break;
                    }
                    finally {
                        dout.close();
                        out.close();
                    }
                }
                server.stop();
            }
        }
        catch (Throwable e) {
            logger.severe(e.getMessage());
        }
        if (!launched) {
            PlatformInit entry = PlatformInit.getInstance();
            boolean debugOn = false;
            for (int i = 0; i < args.length; ++i) {
                String url = args[i];
                if (!url.equals("-debug")) continue;
                debugOn = true;
            }
            entry.init();
            entry.start(args);
        }
    }
}

