/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.primary.clientlets;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import org.lobobrowser.primary.clientlets.ArchiveInfo;
import org.lobobrowser.util.BaseClassLoader;
import org.lobobrowser.util.CollectionUtilities;
import org.lobobrowser.util.GenericURLConnection;
import org.lobobrowser.util.io.IORoutines;

public class ArchiveClassLoader
extends BaseClassLoader {
    private static final Logger logger = Logger.getLogger(ArchiveClassLoader.class.getName());
    private final ArchiveInfo[] archiveInfos;

    ArchiveClassLoader(Collection<Object[]> archiveInfos) throws IOException {
        super(ArchiveClassLoader.class.getClassLoader());
        this.archiveInfos = archiveInfos.toArray(ArchiveInfo.EMPTY_ARRAY);
    }

    protected Class findClass(String arg0) throws ClassNotFoundException {
        final String subPath = arg0.replace('.', '/') + ".class";
        ArchiveInfo[] ainfos = this.archiveInfos;
        int len = ainfos.length;
        byte[] classBytes = null;
        final ArchiveInfo[] foundAinfo = new ArchiveInfo[1];
        for (int i = 0; i < len; ++i) {
            final ArchiveInfo ainfo = ainfos[i];
            try {
                final JarFile jarFile = ainfo.getJarFile();
                classBytes = (byte[])AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Object run() {
                        byte[] byArray;
                        ZipEntry entry = jarFile.getEntry(subPath);
                        if (entry == null) {
                            return null;
                        }
                        InputStream in = jarFile.getInputStream(entry);
                        try {
                            byte[] bytes = IORoutines.loadExact(in, (int)entry.getSize());
                            foundAinfo[0] = ainfo;
                            byArray = bytes;
                        }
                        catch (Throwable throwable) {
                            try {
                                in.close();
                                throw throwable;
                            }
                            catch (IOException ioe) {
                                return null;
                            }
                        }
                        in.close();
                        return byArray;
                    }
                });
            }
            catch (IOException ioe2) {
                continue;
            }
            if (classBytes != null) break;
        }
        if (classBytes == null) {
            throw new ClassNotFoundException("I/O error or entry not found: " + subPath);
        }
        CodeSource cs = new CodeSource(foundAinfo[0].url, new Certificate[0]);
        return this.defineClass(arg0, classBytes, 0, classBytes.length, cs);
    }

    @Override
    protected URL findResource(final String name) {
        try {
            return AccessController.doPrivileged(new PrivilegedAction<URL>(){

                @Override
                public URL run() {
                    try {
                        return new URL(null, "volatile:" + name, new LocalURLStreamHandler(name));
                    }
                    catch (MalformedURLException mfu) {
                        throw new IllegalStateException(mfu.getMessage());
                    }
                }
            });
        }
        catch (RuntimeException err) {
            logger.log(Level.SEVERE, "findResource()", err);
            throw err;
        }
    }

    protected Enumeration findResources(String name) throws IOException {
        URL url = this.findResource(name);
        if (url != null) {
            return CollectionUtilities.getIteratorEnumeration(Collections.singletonList(url).iterator());
        }
        return CollectionUtilities.getIteratorEnumeration(Collections.EMPTY_LIST.iterator());
    }

    private InputStream getResourceAsStreamImpl(final String resourceName) {
        ArchiveInfo[] ainfos = this.archiveInfos;
        int len = ainfos.length;
        InputStream in = null;
        for (int i = 0; i < len; ++i) {
            ArchiveInfo ainfo = ainfos[i];
            try {
                final JarFile jarFile = ainfo.getJarFile();
                in = (InputStream)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        try {
                            ZipEntry entry = jarFile.getEntry(resourceName);
                            if (entry == null) {
                                return null;
                            }
                            return jarFile.getInputStream(entry);
                        }
                        catch (IOException ioe) {
                            return null;
                        }
                    }
                });
            }
            catch (IOException ioe2) {
                continue;
            }
            if (in != null) break;
        }
        if (in == null) {
            ClassLoader parent = this.getParent();
            return parent != null ? parent.getResourceAsStream(resourceName) : null;
        }
        return in;
    }

    public class LocalURLStreamHandler
    extends URLStreamHandler {
        private final String resourceName;

        public LocalURLStreamHandler(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            return new GenericURLConnection(u, ArchiveClassLoader.this.getResourceAsStreamImpl(this.resourceName));
        }

        @Override
        protected URLConnection openConnection(URL u, Proxy p) throws IOException {
            return this.openConnection(u);
        }
    }
}

