/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.primary.ext;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.lobobrowser.primary.ext.BookmarkInfo;
import org.lobobrowser.primary.gui.FieldType;
import org.lobobrowser.primary.gui.FormField;
import org.lobobrowser.primary.gui.FormPanel;
import org.lobobrowser.util.Strings;

public class AddBookmarkDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final FormField urlField = new FormField(FieldType.TEXT, "URL:");
    private final FormField titleField = new FormField(FieldType.TEXT, "Title:");
    private final FormField descriptionField = new FormField(FieldType.TEXT, "Description:");
    private final FormField tagsField = new FormField(FieldType.TEXT, "Tags:");
    private final URL url;
    private BookmarkInfo bookmarkInfo;

    public AddBookmarkDialog(Frame owner, boolean modal, BookmarkInfo existingInfo) throws HeadlessException {
        super(owner, modal);
        this.setDefaultCloseOperation(2);
        this.url = existingInfo.getUrl();
        this.urlField.setEditable(false);
        this.tagsField.setToolTip("List of keywords separated by blanks.");
        this.urlField.setValue(existingInfo.getUrl().toExternalForm());
        this.titleField.setValue(existingInfo.getTitle());
        this.descriptionField.setValue(existingInfo.getDescription());
        this.tagsField.setValue(existingInfo.getTagsText());
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        FormPanel fieldsPanel = new FormPanel();
        fieldsPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        fieldsPanel.addField(this.urlField);
        fieldsPanel.addField(this.titleField);
        fieldsPanel.addField(this.descriptionField);
        fieldsPanel.addField(this.tagsField);
        Dimension fpps = fieldsPanel.getPreferredSize();
        fieldsPanel.setPreferredSize(new Dimension(400, fpps.height));
        contentPane.add(fieldsPanel);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 0));
        JButton okButton = new JButton();
        okButton.setAction(new OkAction());
        okButton.setText("Save");
        JButton cancelButton = new JButton();
        cancelButton.setAction(new CancelAction());
        cancelButton.setText("Cancel");
        buttonsPanel.add(Box.createHorizontalGlue());
        buttonsPanel.add(okButton);
        buttonsPanel.add(Box.createRigidArea(new Dimension(4, 1)));
        buttonsPanel.add(cancelButton);
        buttonsPanel.add(Box.createHorizontalGlue());
        contentPane.add(buttonsPanel);
        contentPane.add(Box.createRigidArea(new Dimension(1, 4)));
    }

    public BookmarkInfo getBookmarkInfo() {
        return this.bookmarkInfo;
    }

    private class CancelAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AddBookmarkDialog.this.bookmarkInfo = null;
            AddBookmarkDialog.this.dispose();
        }
    }

    private class OkAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private OkAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BookmarkInfo binfo = new BookmarkInfo();
            binfo.setUrl(AddBookmarkDialog.this.url);
            binfo.setTitle(AddBookmarkDialog.this.titleField.getValue());
            binfo.setDescription(AddBookmarkDialog.this.descriptionField.getValue());
            binfo.setTags(Strings.split(AddBookmarkDialog.this.tagsField.getValue()));
            AddBookmarkDialog.this.bookmarkInfo = binfo;
            AddBookmarkDialog.this.dispose();
        }
    }
}

