/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.primary.ext;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import org.lobobrowser.util.io.IORoutines;

public class IconFactory {
    private static final Logger logger = Logger.getLogger(IconFactory.class.getName());
    private static final IconFactory instance = new IconFactory();
    private Map<String, ImageIcon> iconMap = new HashMap<String, ImageIcon>();

    private IconFactory() {
    }

    public static IconFactory getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageIcon getIcon(String resourcePath) {
        try {
            IconFactory iconFactory = this;
            synchronized (iconFactory) {
                ImageIcon icon = this.iconMap.get(resourcePath);
                if (icon == null) {
                    InputStream in = this.getClass().getResourceAsStream(resourcePath);
                    if (in == null) {
                        logger.warning("getIcon(): Resource path " + resourcePath + " not found.");
                        return null;
                    }
                    try {
                        byte[] imageBytes = IORoutines.load(in, 4096);
                        icon = new ImageIcon(imageBytes);
                        this.iconMap.put(resourcePath, icon);
                    }
                    finally {
                        in.close();
                    }
                }
                return icon;
            }
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, "getIcon(): Resource path " + resourcePath + " gave error.", ioe);
            return null;
        }
    }
}

