/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.primary.gui;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.lobobrowser.primary.gui.ItemEditorDialog;
import org.lobobrowser.primary.gui.ItemEditorFactory;
import org.lobobrowser.primary.gui.SwingTasks;

public class ItemListControl<T>
extends JComponent {
    private static final long serialVersionUID = 1L;
    private final JComboBox comboBox;
    private final ItemEditorFactory<T> itemEditorFactory;
    private String editListCaption;

    public ItemListControl(ItemEditorFactory<T> ief) {
        this.itemEditorFactory = ief;
        this.setLayout(new BoxLayout(this, 0));
        this.comboBox = new JComboBox();
        this.comboBox.setPreferredSize(new Dimension(100, 24));
        this.comboBox.setEditable(false);
        JButton editButton = new JButton();
        editButton.setAction(new EditAction(false));
        editButton.setText("Edit");
        JButton addButton = new JButton();
        addButton.setAction(new EditAction(true));
        addButton.setText("Add");
        JButton removeButton = new JButton();
        removeButton.setAction(new RemoveAction());
        removeButton.setText("Remove");
        this.add(this.comboBox);
        this.add(editButton);
        this.add(addButton);
        this.add(removeButton);
    }

    public void setItems(Collection<T> items) {
        JComboBox comboBox = this.comboBox;
        comboBox.removeAllItems();
        for (T item : items) {
            comboBox.addItem(item);
        }
    }

    private T getSelectedItem() {
        return (T)this.comboBox.getSelectedItem();
    }

    private void addItem(T item) {
        this.comboBox.addItem(item);
        this.comboBox.setSelectedItem(item);
    }

    private void replaceSelectedItem(T item) {
        int index = this.comboBox.getSelectedIndex();
        if (index != -1) {
            this.comboBox.removeItemAt(index);
        }
        this.comboBox.addItem(item);
        this.comboBox.setSelectedItem(item);
    }

    private void removeSelectedItem() {
        int index = this.comboBox.getSelectedIndex();
        if (index != -1) {
            this.comboBox.removeItemAt(index);
        }
    }

    public Collection<T> getItems() {
        ArrayList items = new ArrayList();
        int count = this.comboBox.getItemCount();
        for (int i = 0; i < count; ++i) {
            items.add(this.comboBox.getItemAt(i));
        }
        return items;
    }

    public void setEditorCaption(String caption) {
        this.editListCaption = caption;
    }

    private class EditAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private final boolean add;

        public EditAction(boolean add) {
            this.add = add;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ItemEditorDialog<Object> dialog;
            Frame parentFrame = SwingTasks.getFrame(ItemListControl.this);
            if (parentFrame != null) {
                dialog = new ItemEditorDialog<Object>(parentFrame, ItemListControl.this.itemEditorFactory);
            } else {
                Dialog parentDialog = SwingTasks.getDialog(ItemListControl.this);
                dialog = new ItemEditorDialog(parentDialog, ItemListControl.this.itemEditorFactory);
            }
            dialog.setModal(true);
            dialog.setTitle(this.add ? "Add Item" : "Edit Item");
            dialog.setCaption(ItemListControl.this.editListCaption);
            dialog.pack();
            Dimension size = dialog.getSize();
            if (size.width > 400) {
                dialog.setSize(new Dimension(400, size.height));
            }
            dialog.setLocationByPlatform(true);
            if (!this.add) {
                dialog.setItem(ItemListControl.this.getSelectedItem());
            }
            dialog.setVisible(true);
            Object item = dialog.getResultingItem();
            if (item != null) {
                if (this.add) {
                    ItemListControl.this.addItem(item);
                } else {
                    ItemListControl.this.replaceSelectedItem(item);
                }
            }
        }
    }

    private class RemoveAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private RemoveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (JOptionPane.showConfirmDialog(ItemListControl.this, "Are you sure you want to remove the selected item?", "Confirm", 0) == 0) {
                ItemListControl.this.removeSelectedItem();
            }
        }
    }
}

