/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.protocol.data;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.xml.bind.DatatypeConverter;

public class DataURLConnection
extends HttpURLConnection {
    private static final Logger logger = Logger.getLogger(DataURLConnection.class.getName());
    private HashMap<String, String> headerMap = new HashMap();
    private byte[] content = new byte[0];

    protected DataURLConnection(URL url) {
        super(url);
    }

    @Override
    public void connect() throws IOException {
        this.loadHeaderMap();
    }

    @Override
    public String getContentType() {
        String type = this.headerMap.get("Content-Type");
        if (type == null) {
            return "Content-Type: text/plain; charset=US-ASCII";
        }
        return type;
    }

    @Override
    public int getContentLength() {
        if (this.content != null) {
            return this.content.length;
        }
        return 0;
    }

    @Override
    public String getHeaderField(int n) {
        return this.headerMap.get(this.headerMap.keySet().toArray()[n]);
    }

    @Override
    public String getHeaderField(String name) {
        return this.headerMap.get(name);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.connect();
        if (this.content != null) {
            return new ByteArrayInputStream(this.content);
        }
        return new ByteArrayInputStream(new byte[0]);
    }

    private void loadHeaderMap() {
        String UTF8 = "UTF-8";
        this.headerMap.clear();
        String path = this.getURL().getPath();
        int index2 = path.toLowerCase().indexOf(",");
        if (index2 == -1) {
            index2 = path.toLowerCase().lastIndexOf(";");
        }
        String mediatype = path.substring(0, index2).trim();
        boolean base64 = false;
        String[] split = mediatype.split("[;,]");
        String value = path.substring(index2 + 1).trim();
        if (split[0].equals("")) {
            split[0] = "text/plain";
        }
        this.headerMap.put("content-type", split[0]);
        try {
            for (int i = 1; i < split.length; ++i) {
                if (split[i].contains("=")) {
                    int index = split[i].indexOf("=");
                    String attr = split[i].substring(0, index);
                    String v = split[i].substring(index + 1);
                    this.headerMap.put(attr, URLDecoder.decode(v, UTF8));
                    continue;
                }
                if (!split[i].equalsIgnoreCase("base64")) continue;
                base64 = true;
            }
            String charset = this.getHeaderField("charset");
            if (charset == null) {
                charset = UTF8;
            }
            if (base64) {
                this.content = DatatypeConverter.parseBase64Binary((String)value);
            } else {
                value = URLDecoder.decode(value, charset);
                this.content = value.getBytes();
            }
        }
        catch (IOException e) {
            logger.severe(e.getMessage());
        }
    }

    @Override
    public void disconnect() {
    }

    @Override
    public boolean usingProxy() {
        return false;
    }
}

