/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.protocol.vc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.lobobrowser.context.VolatileContentImpl;

public class VcURLConnection
extends URLConnection {
    private final VolatileContentImpl vc;

    public VcURLConnection(URL url) {
        super(url);
        String file = url.getPath();
        try {
            long id = Long.parseLong(file.trim());
            this.vc = VolatileContentImpl.getVolatileContent(id);
            if (this.vc == null) {
                throw new IllegalArgumentException("Content either invalid or no longer available");
            }
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Bad path: " + file);
        }
    }

    @Override
    public void connect() throws IOException {
    }

    @Override
    public int getContentLength() {
        return this.vc.getBytes().length;
    }

    @Override
    public String getContentType() {
        return this.vc.getContentType();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.vc.getBytes());
    }
}

