/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.request;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.lobobrowser.util.NameValuePair;

public class Cookie
extends NameValuePair {
    private String comment;
    private String domain;
    private long expires;
    private int maxAge = -1;
    private String path;
    private boolean secure;
    private int version;

    public Cookie() {
    }

    public Cookie(String name, String value, String path, String domain, long expires) {
        super(name, value);
        this.path = path;
        this.domain = domain;
        this.expires = expires;
    }

    public String getEncodedName() throws UnsupportedEncodingException {
        return URLEncoder.encode(this.name, "UTF-8");
    }

    public String getEncodedValue() throws UnsupportedEncodingException {
        return URLEncoder.encode(this.value, "UTF-8");
    }

    public void setComment(String comment) {
        String old = this.getComment();
        this.comment = comment;
        this.firePropertyChange("comment", old, this.getComment());
    }

    public String getComment() {
        return this.comment;
    }

    public Long getExpires() {
        return this.expires;
    }

    public void setDomain(String domain) {
        String old = this.getDomain();
        this.domain = domain;
        this.firePropertyChange("domain", old, this.getDomain());
    }

    public String getDomain() {
        return this.domain;
    }

    public void setMaxAge(int age) {
        long old = this.getMaxAge();
        this.maxAge = age;
        this.firePropertyChange("maxAge", old, this.getMaxAge());
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public void setPath(String path) {
        String old = this.getPath();
        this.path = path;
        this.firePropertyChange("path", old, this.getPath());
    }

    public String getPath() {
        return this.path;
    }

    public void setSecure(boolean secure) {
        boolean old = this.isSecure();
        this.secure = secure;
        this.firePropertyChange("secure", old, this.isSecure());
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setVersion(int version) {
        int old = this.getVersion();
        this.version = version;
        this.firePropertyChange("version", old, this.getVersion());
    }

    public int getVersion() {
        return this.version;
    }

    @Override
    public String toString() {
        return "Cookie [" + this.getName() + "=" + this.getValue() + ", " + "Comment=" + this.getComment() + ", " + "Domain=" + this.getDomain() + ", " + "Max-Age=" + this.getMaxAge() + ", " + "Path=" + this.getPath() + ", " + "Secure=" + this.isSecure() + ", " + "Version=" + this.getVersion() + "]";
    }
}

