/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.request;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lobobrowser.request.MemoryCacheEntry;
import org.lobobrowser.util.NameValuePair;

public class MemoryURLConnection
extends URLConnection {
    private final MemoryCacheEntry memoryEntry;
    private InputStream inputStream;
    private final Map<String, List<String>> headersMap = new HashMap<String, List<String>>();

    public MemoryURLConnection(URL url, MemoryCacheEntry memoryEntry) {
        super(url);
        this.memoryEntry = memoryEntry;
    }

    @Override
    public void connect() throws IOException {
        if (!this.connected) {
            this.readHeaders();
            ByteArrayInputStream in = new ByteArrayInputStream(this.memoryEntry.content);
            this.inputStream = in;
            this.connected = true;
        }
    }

    private void readHeaders() throws IOException {
        Map<String, List<String>> headersMap = this.headersMap;
        List<NameValuePair> origList = this.memoryEntry.headers;
        for (NameValuePair pair : origList) {
            String name = pair.name;
            if (name != null) {
                name = name.toLowerCase();
            }
            String value = pair.value;
            List<String> hvalues = headersMap.get(name);
            if (hvalues == null) {
                hvalues = new ArrayList<String>(1);
                headersMap.put(name, hvalues);
            }
            hvalues.add(value);
        }
    }

    @Override
    public String getHeaderField(int n) {
        try {
            this.connect();
            NameValuePair pair = this.memoryEntry.headers.get(n);
            return pair.value;
        }
        catch (IndexOutOfBoundsException iob) {
            return null;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    @Override
    public String getHeaderField(String name) {
        try {
            this.connect();
        }
        catch (IOException ioe) {
            return null;
        }
        List<String> hvalues = this.headersMap.get(name.toLowerCase());
        if (hvalues == null || hvalues.size() == 0) {
            return null;
        }
        return hvalues.get(0);
    }

    @Override
    public String getHeaderFieldKey(int n) {
        try {
            this.connect();
            NameValuePair pair = this.memoryEntry.headers.get(n);
            return pair.name;
        }
        catch (IndexOutOfBoundsException iob) {
            return null;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        try {
            this.connect();
        }
        catch (IOException ioe) {
            return null;
        }
        return this.headersMap;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.connect();
        return this.inputStream;
    }
}

