/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.structureView;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.navigation.ItemPresentation;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLPsiElement;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;

public class YAMLStructureViewElement
implements StructureViewTreeElement {
    private final YAMLPsiElement myElement;

    public YAMLStructureViewElement(YAMLPsiElement element) {
        this.myElement = element;
    }

    @NotNull
    public StructureViewTreeElement[] getChildren() {
        Collection<YAMLPsiElement> children = this.myElement instanceof YAMLFile ? ((YAMLFile)this.myElement).getDocuments() : (this.myElement instanceof YAMLDocument ? YAMLStructureViewElement.getChildrenForValue(((YAMLDocument)this.myElement).getTopLevelValue()) : (this.myElement instanceof YAMLSequenceItem ? YAMLStructureViewElement.getChildrenForValue(((YAMLSequenceItem)this.myElement).getValue()) : (this.myElement instanceof YAMLKeyValue ? YAMLStructureViewElement.getChildrenForValue(((YAMLKeyValue)this.myElement).getValue()) : Collections.emptyList())));
        ArrayList<YAMLStructureViewElement> structureElements = new ArrayList<YAMLStructureViewElement>();
        for (YAMLPsiElement child : children) {
            structureElements.add(new YAMLStructureViewElement(child));
        }
        StructureViewTreeElement[] structureViewTreeElementArray = structureElements.toArray(new StructureViewTreeElement[structureElements.size()]);
        if (structureViewTreeElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/structureView/YAMLStructureViewElement", "getChildren"));
        }
        return structureViewTreeElementArray;
    }

    @NotNull
    private static Collection<? extends YAMLPsiElement> getChildrenForValue(@Nullable YAMLPsiElement element) {
        if (element instanceof YAMLMapping) {
            Collection<YAMLKeyValue> collection = ((YAMLMapping)element).getKeyValues();
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/structureView/YAMLStructureViewElement", "getChildrenForValue"));
            }
            return collection;
        }
        if (element instanceof YAMLSequence) {
            List<YAMLSequenceItem> list = ((YAMLSequence)element).getItems();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/structureView/YAMLStructureViewElement", "getChildrenForValue"));
            }
            return list;
        }
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/structureView/YAMLStructureViewElement", "getChildrenForValue"));
        }
        return list;
    }

    @NotNull
    public ItemPresentation getPresentation() {
        if (this.myElement instanceof YAMLKeyValue) {
            final YAMLKeyValue kv = (YAMLKeyValue)this.myElement;
            ItemPresentation itemPresentation = new ItemPresentation(){

                public String getPresentableText() {
                    return kv.getKeyText();
                }

                public String getLocationString() {
                    if (kv.getValue() instanceof YAMLScalar) {
                        return kv.getValueText();
                    }
                    return null;
                }

                public Icon getIcon(boolean open) {
                    YAMLValue value = kv.getValue();
                    return value instanceof YAMLScalar ? kv.getIcon(0) : PlatformIcons.XML_TAG_ICON;
                }
            };
            if (itemPresentation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/structureView/YAMLStructureViewElement", "getPresentation"));
            }
            return itemPresentation;
        }
        if (this.myElement instanceof YAMLDocument) {
            ItemPresentation itemPresentation = new ItemPresentation(){

                public String getPresentableText() {
                    return "YAML document";
                }

                public String getLocationString() {
                    return null;
                }

                public Icon getIcon(boolean open) {
                    return PlatformIcons.XML_TAG_ICON;
                }
            };
            if (itemPresentation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/structureView/YAMLStructureViewElement", "getPresentation"));
            }
            return itemPresentation;
        }
        if (this.myElement instanceof YAMLSequenceItem) {
            final YAMLSequenceItem item = (YAMLSequenceItem)this.myElement;
            ItemPresentation itemPresentation = new ItemPresentation(){

                @Nullable
                public String getPresentableText() {
                    if (item.getValue() instanceof YAMLScalar) {
                        return ((YAMLScalar)item.getValue()).getTextValue();
                    }
                    return "Sequence Item";
                }

                @Nullable
                public String getLocationString() {
                    return null;
                }

                @Nullable
                public Icon getIcon(boolean unused) {
                    return item.getValue() instanceof YAMLScalar ? PlatformIcons.PROPERTY_ICON : PlatformIcons.XML_TAG_ICON;
                }
            };
            if (itemPresentation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/structureView/YAMLStructureViewElement", "getPresentation"));
            }
            return itemPresentation;
        }
        ItemPresentation itemPresentation = this.myElement.getPresentation();
        if (itemPresentation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/structureView/YAMLStructureViewElement", "getPresentation"));
        }
        return itemPresentation;
    }

    public YAMLPsiElement getValue() {
        return this.myElement;
    }

    public void navigate(boolean requestFocus) {
        this.myElement.navigate(requestFocus);
    }

    public boolean canNavigate() {
        return this.myElement.canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.myElement.canNavigateToSource();
    }
}

