/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.facet;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.util.text.StringUtil;
import icons.OsmorcIdeaIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.osgi.jps.model.OutputPathType;
import org.osmorc.facet.OsmorcFacet;
import org.osmorc.facet.OsmorcFacetConfiguration;
import org.osmorc.settings.ProjectSettings;

public class OsmorcFacetType
extends FacetType<OsmorcFacet, OsmorcFacetConfiguration> {
    public static final FacetTypeId<OsmorcFacet> ID = new FacetTypeId("Osmorc");

    public static OsmorcFacetType getInstance() {
        return (OsmorcFacetType)OsmorcFacetType.findInstance(OsmorcFacetType.class);
    }

    protected OsmorcFacetType() {
        super(ID, "Osmorc", "OSGi");
    }

    public OsmorcFacetConfiguration createDefaultConfiguration() {
        return new OsmorcFacetConfiguration();
    }

    public OsmorcFacet createFacet(@NotNull Module module, String name, @NotNull OsmorcFacetConfiguration configuration, @Nullable Facet facet) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/osmorc/facet/OsmorcFacetType", "createFacet"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/osmorc/facet/OsmorcFacetType", "createFacet"));
        }
        OsmorcFacetType.completeDefaultConfiguration(configuration, module);
        return new OsmorcFacet(this, module, configuration, facet, name);
    }

    public boolean isSuitableModuleType(ModuleType moduleType) {
        return moduleType instanceof JavaModuleType;
    }

    private static void completeDefaultConfiguration(OsmorcFacetConfiguration configuration, Module module) {
        if (StringUtil.isEmpty((String)configuration.getJarFileLocation())) {
            String bundlesOutputPath;
            String jarFileName = module.getName().replaceAll("[\\s]", "_") + ".jar";
            OutputPathType outputPathType = OutputPathType.CompilerOutputPath;
            ProjectSettings projectSettings = ProjectSettings.getInstance(module.getProject());
            if (projectSettings != null && StringUtil.isNotEmpty((String)(bundlesOutputPath = projectSettings.getBundlesOutputPath()))) {
                outputPathType = OutputPathType.OsgiOutputPath;
            }
            configuration.setJarFileLocation(jarFileName, outputPathType);
        }
    }

    public Icon getIcon() {
        return OsmorcIdeaIcons.Osgi;
    }
}

