/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.inspection;

import com.intellij.codeInsight.daemon.impl.analysis.AnnotationsHighlightUtil;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.packageDependencies.DependenciesBuilder;
import com.intellij.packageDependencies.DependencyVisitorFactory;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.lang.manifest.psi.ManifestFile;
import org.jetbrains.osgi.project.BundleManifest;
import org.jetbrains.osgi.project.BundleManifestCache;
import org.osmorc.facet.OsmorcFacet;
import org.osmorc.facet.OsmorcFacetConfiguration;
import org.osmorc.i18n.OsmorcBundle;
import org.osmorc.inspection.AbstractOsgiQuickFix;
import org.osmorc.util.OsgiPsiUtil;

public class PackageAccessibilityInspection
extends BaseJavaBatchLocalInspectionTool {
    public boolean checkTests = false;

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(OsmorcBundle.message("PackageAccessibilityInspection.ui.check.tests", new Object[0]), (InspectionProfileEntry)this, "checkTests");
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, final @NotNull InspectionManager manager, final boolean isOnTheFly) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/osmorc/inspection/PackageAccessibilityInspection", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/osmorc/inspection/PackageAccessibilityInspection", "checkFile"));
        }
        if (!this.checkTests && ProjectRootsUtil.isInTestSource((PsiFile)file)) {
            return null;
        }
        final OsmorcFacet facet = OsmorcFacet.getInstance((PsiElement)file);
        if (facet == null) {
            return null;
        }
        final List problems = ContainerUtil.newSmartList();
        DependenciesBuilder.analyzeFileDependencies((PsiFile)file, (DependenciesBuilder.DependencyProcessor)new DependenciesBuilder.DependencyProcessor(){

            public void process(PsiElement place, PsiElement dependency) {
                Problem problem;
                if (dependency instanceof PsiClass && (problem = PackageAccessibilityInspection.checkAccessibility((PsiClass)dependency, facet)) != null) {
                    problems.add(manager.createProblemDescriptor(place, problem.message, isOnTheFly, problem.fixes, problem.type));
                }
            }
        }, (DependencyVisitorFactory.VisitorOptions)DependencyVisitorFactory.VisitorOptions.SKIP_IMPORTS);
        return problems.isEmpty() ? null : problems.toArray(new ProblemDescriptor[problems.size()]);
    }

    private static Problem checkAccessibility(PsiClass targetClass, OsmorcFacet facet) {
        RetentionPolicy retention;
        if (targetClass.isAnnotationType() && ((retention = AnnotationsHighlightUtil.getRetentionPolicy((PsiClass)targetClass)) == RetentionPolicy.SOURCE || retention == RetentionPolicy.CLASS)) {
            return null;
        }
        PsiFile targetFile = targetClass.getContainingFile();
        if (!(targetFile instanceof PsiClassOwner)) {
            return null;
        }
        String packageName = ((PsiClassOwner)targetFile).getPackageName();
        if (packageName.isEmpty() || packageName.startsWith("java.")) {
            return null;
        }
        Module requestorModule = facet.getModule();
        Module targetModule = ModuleUtilCore.findModuleForPsiElement((PsiElement)targetClass);
        if (targetModule == requestorModule) {
            return null;
        }
        BundleManifest importer = BundleManifestCache.getInstance(targetClass.getProject()).getManifest(requestorModule);
        if (importer != null && (importer.isPrivatePackage(packageName) || importer.getExportedPackage(packageName) != null)) {
            return null;
        }
        BundleManifest exporter = BundleManifestCache.getInstance(targetClass.getProject()).getManifest(targetClass);
        if (exporter == null || exporter.getBundleSymbolicName() == null) {
            return Problem.weak(OsmorcBundle.message("PackageAccessibilityInspection.non.osgi", packageName), new LocalQuickFix[0]);
        }
        String exportedPackage = exporter.getExportedPackage(packageName);
        if (exportedPackage == null) {
            return Problem.error(OsmorcBundle.message("PackageAccessibilityInspection.not.exported", packageName), new LocalQuickFix[0]);
        }
        if (!((OsmorcFacetConfiguration)facet.getConfiguration()).isManifestManuallyEdited()) {
            return null;
        }
        if (importer != null) {
            if (importer.isPackageImported(packageName)) {
                return null;
            }
            if (importer.isBundleRequired(exporter.getBundleSymbolicName())) {
                return null;
            }
        }
        return Problem.error(OsmorcBundle.message("PackageAccessibilityInspection.not.imported", packageName), new ImportPackageFix(exportedPackage));
    }

    private static class ImportPackageFix
    extends AbstractOsgiQuickFix {
        private final String myPackageToImport;

        public ImportPackageFix(String packageToImport) {
            this.myPackageToImport = packageToImport;
        }

        @NotNull
        public String getName() {
            String string = OsmorcBundle.message("PackageAccessibilityInspection.fix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/inspection/PackageAccessibilityInspection$ImportPackageFix", "getName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/osmorc/inspection/PackageAccessibilityInspection$ImportPackageFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/osmorc/inspection/PackageAccessibilityInspection$ImportPackageFix", "applyFix"));
            }
            final ManifestFile manifestFile = this.getVerifiedManifestFile(descriptor.getPsiElement());
            if (manifestFile != null) {
                new WriteCommandAction.Simple(project, new PsiFile[]{manifestFile}){

                    protected void run() throws Throwable {
                        OsgiPsiUtil.appendToHeader(manifestFile, "Import-Package", myPackageToImport);
                    }
                }.execute();
            }
        }
    }

    private static class Problem {
        public final ProblemHighlightType type;
        public final String message;
        public final LocalQuickFix[] fixes;

        private Problem(ProblemHighlightType type, String message, LocalQuickFix ... fixes) {
            this.type = type;
            this.message = message;
            this.fixes = fixes.length > 0 ? fixes : null;
        }

        public static Problem weak(String message, LocalQuickFix ... fixes) {
            return new Problem(ProblemHighlightType.WEAK_WARNING, message, fixes);
        }

        public static Problem error(String message, LocalQuickFix ... fixes) {
            return new Problem(ProblemHighlightType.GENERIC_ERROR_OR_WARNING, message, fixes);
        }
    }
}

