/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.inspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.lang.manifest.psi.ManifestFile;
import org.jetbrains.osgi.project.BundleManifest;
import org.jetbrains.osgi.project.BundleManifestCache;
import org.osmorc.facet.OsmorcFacet;
import org.osmorc.facet.OsmorcFacetConfiguration;
import org.osmorc.i18n.OsmorcBundle;
import org.osmorc.inspection.AbstractOsgiQuickFix;
import org.osmorc.inspection.AbstractOsgiVisitor;
import org.osmorc.util.OsgiPsiUtil;

public class UnregisteredActivatorInspection
extends AbstractOsgiVisitor {
    @Override
    @NotNull
    protected PsiElementVisitor buildVisitor(final OsmorcFacet facet, final ProblemsHolder holder, boolean isOnTheFly) {
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitFile(PsiFile file) {
                if (file instanceof PsiClassOwner) {
                    for (PsiClass psiClass : ((PsiClassOwner)file).getClasses()) {
                        BundleManifest manifest;
                        String className = psiClass.getQualifiedName();
                        if (!OsgiPsiUtil.isActivator((PsiElement)psiClass) || className == null || (manifest = BundleManifestCache.getInstance(psiClass.getProject()).getManifest(facet.getModule())) == null || className.equals(manifest.getBundleActivator())) continue;
                        LocalQuickFix[] fixes = LocalQuickFix.EMPTY_ARRAY;
                        OsmorcFacetConfiguration configuration = (OsmorcFacetConfiguration)facet.getConfiguration();
                        if (configuration.isManifestManuallyEdited()) {
                            fixes = new LocalQuickFix[]{new RegisterInManifestQuickfix(className)};
                        } else if (configuration.isOsmorcControlsManifest()) {
                            fixes = new LocalQuickFix[]{new RegisterInConfigurationQuickfix(className, configuration)};
                        }
                        PsiElement identifier = AbstractOsgiVisitor.unwrap((PsiElement)psiClass.getNameIdentifier());
                        if (identifier == null) continue;
                        holder.registerProblem(identifier, OsmorcBundle.message("UnregisteredActivatorInspection.message", new Object[0]), fixes);
                    }
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/inspection/UnregisteredActivatorInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    private static class RegisterInConfigurationQuickfix
    extends AbstractOsgiQuickFix {
        private final String myActivatorClass;
        private final OsmorcFacetConfiguration myConfiguration;

        private RegisterInConfigurationQuickfix(@NotNull String activatorClass, @NotNull OsmorcFacetConfiguration configuration) {
            if (activatorClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activatorClass", "org/osmorc/inspection/UnregisteredActivatorInspection$RegisterInConfigurationQuickfix", "<init>"));
            }
            if (configuration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/osmorc/inspection/UnregisteredActivatorInspection$RegisterInConfigurationQuickfix", "<init>"));
            }
            this.myActivatorClass = activatorClass;
            this.myConfiguration = configuration;
        }

        @NotNull
        public String getName() {
            String string = OsmorcBundle.message("UnregisteredActivatorInspection.fix.config", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/inspection/UnregisteredActivatorInspection$RegisterInConfigurationQuickfix", "getName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/osmorc/inspection/UnregisteredActivatorInspection$RegisterInConfigurationQuickfix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/osmorc/inspection/UnregisteredActivatorInspection$RegisterInConfigurationQuickfix", "applyFix"));
            }
            this.myConfiguration.setBundleActivator(this.myActivatorClass);
        }
    }

    private static class RegisterInManifestQuickfix
    extends AbstractOsgiQuickFix {
        private final String myActivatorClass;

        private RegisterInManifestQuickfix(@NotNull String activatorClass) {
            if (activatorClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activatorClass", "org/osmorc/inspection/UnregisteredActivatorInspection$RegisterInManifestQuickfix", "<init>"));
            }
            this.myActivatorClass = activatorClass;
        }

        @NotNull
        public String getName() {
            String string = OsmorcBundle.message("UnregisteredActivatorInspection.fix.manifest", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/inspection/UnregisteredActivatorInspection$RegisterInManifestQuickfix", "getName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/osmorc/inspection/UnregisteredActivatorInspection$RegisterInManifestQuickfix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/osmorc/inspection/UnregisteredActivatorInspection$RegisterInManifestQuickfix", "applyFix"));
            }
            final ManifestFile manifestFile = this.getVerifiedManifestFile(descriptor.getEndElement());
            if (manifestFile != null) {
                new WriteCommandAction.Simple(project, new PsiFile[]{manifestFile}){

                    protected void run() throws Throwable {
                        OsgiPsiUtil.setHeader(manifestFile, "Bundle-Activator", myActivatorClass);
                    }
                }.execute();
            }
        }
    }
}

