/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.make;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.osgi.jps.build.BndWrapper;
import org.jetbrains.osgi.jps.build.OsgiBuildException;
import org.jetbrains.osgi.jps.build.Reporter;
import org.jetbrains.osgi.jps.model.LibraryBundlificationRule;
import org.osmorc.settings.ApplicationSettings;

public class BundleCompiler
implements Reporter {
    private static final Logger LOG = Logger.getInstance(BundleCompiler.class);
    private final ProgressIndicator myIndicator;

    public BundleCompiler(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/osmorc/make/BundleCompiler", "<init>"));
        }
        this.myIndicator = indicator;
    }

    @NotNull
    public List<String> bundlifyLibraries(@NotNull Module module) throws OsgiBuildException {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/osmorc/make/BundleCompiler", "bundlifyLibraries"));
        }
        this.myIndicator.setText("Bundling non-OSGi libraries for module '" + module.getName() + "'");
        File outputDir = BndWrapper.getOutputDir((File)BundleCompiler.getModuleOutputDir(module));
        List<LibraryBundlificationRule> libRules = ApplicationSettings.getInstance().getLibraryBundlificationRules();
        List paths = OrderEnumerator.orderEntries((Module)module).withoutSdk().withoutModuleSourceEntries().withoutDepModules().productionOnly().runtimeOnly().recursively().exportedOnly().classes().getPathsList().getPathList();
        List files = ContainerUtil.map((Collection)paths, path -> new File((String)path));
        List list = new BndWrapper((Reporter)this).bundlifyLibraries((Collection)files, outputDir, libRules);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/make/BundleCompiler", "bundlifyLibraries"));
        }
        return list;
    }

    private static File getModuleOutputDir(@NotNull Module module) throws OsgiBuildException {
        String url;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/osmorc/make/BundleCompiler", "getModuleOutputDir"));
        }
        CompilerModuleExtension extension = CompilerModuleExtension.getInstance((Module)module);
        if (extension != null && (url = extension.getCompilerOutputUrl()) != null) {
            return new File(VfsUtilCore.urlToPath((String)url));
        }
        throw new OsgiBuildException("Unable to determine the compiler output path for the module '" + module.getName() + "'");
    }

    public void progress(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/osmorc/make/BundleCompiler", "progress"));
        }
        LOG.debug(message);
        this.myIndicator.setText2(message);
    }

    public void warning(@NotNull String message, @Nullable Throwable t, @Nullable String sourcePath) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/osmorc/make/BundleCompiler", "warning"));
        }
        LOG.warn(message, t);
    }

    public void error(@NotNull String message, @Nullable Throwable t, @Nullable String sourcePath) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/osmorc/make/BundleCompiler", "error"));
        }
        LOG.warn(message, t);
    }

    public boolean isDebugEnabled() {
        return LOG.isDebugEnabled();
    }

    public void debug(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/osmorc/make/BundleCompiler", "debug"));
        }
        LOG.debug(message);
    }
}

