/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.make;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osmorc.facet.OsmorcFacet;
import org.osmorc.facet.OsmorcFacetConfiguration;
import org.osmorc.make.ViewManifestAction;

public class ViewGeneratedManifestGroup
extends ActionGroup {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/osmorc/make/ViewGeneratedManifestGroup", "update"));
        }
        boolean enabled = false;
        Project project = e.getProject();
        if (project != null) {
            for (Module m : ModuleManager.getInstance((Project)project).getModules()) {
                if (!OsmorcFacet.hasOsmorcFacet(m)) continue;
                enabled = true;
                break;
            }
        }
        e.getPresentation().setVisible(enabled);
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        Project project;
        if (e != null && (project = e.getProject()) != null) {
            List actions = null;
            for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                String jarFilePath;
                OsmorcFacet facet = OsmorcFacet.getInstance(module);
                if (facet == null || (jarFilePath = ((OsmorcFacetConfiguration)facet.getConfiguration()).getJarFileLocation()).isEmpty()) continue;
                String title = "[" + module.getName() + "] " + PathUtil.getFileName((String)jarFilePath);
                ViewManifestAction action = new ViewManifestAction(title, jarFilePath);
                if (actions == null) {
                    actions = ContainerUtil.newSmartList();
                }
                actions.add(action);
            }
            if (actions != null) {
                AnAction[] anActionArray = actions.toArray(new AnAction[actions.size()]);
                if (anActionArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/make/ViewGeneratedManifestGroup", "getChildren"));
                }
                return anActionArray;
            }
        }
        if (AnAction.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/make/ViewGeneratedManifestGroup", "getChildren"));
        }
        return AnAction.EMPTY_ARRAY;
    }
}

