/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.maven.inspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.dom.model.MavenDomRepository;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenArtifactUtil;
import org.jetbrains.osgi.jps.build.CachingBundleInfoProvider;
import org.osmorc.facet.OsmorcFacet;
import org.osmorc.i18n.OsmorcBundle;
import org.osmorc.inspection.AbstractOsgiQuickFix;
import org.osmorc.obrimport.MavenRepository;
import org.osmorc.obrimport.ObrSearchDialog;
import org.osmorc.obrimport.springsource.ObrMavenResult;

public class NonOsgiMavenDependencyInspection
extends XmlSuppressableInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder problemsHolder, boolean isOnTheFly) {
        if (problemsHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problemsHolder", "org/osmorc/maven/inspection/NonOsgiMavenDependencyInspection", "buildVisitor"));
        }
        boolean isMaven = MavenDomUtil.isMavenFile((PsiFile)problemsHolder.getFile());
        Object object = !isMaven ? PsiElementVisitor.EMPTY_VISITOR : new XmlElementVisitor(){

            public void visitXmlTag(XmlTag tag) {
                String version;
                String artifactId;
                String groupId;
                File repo;
                File artifactFile;
                String scope;
                MavenDomDependency dependency;
                if (OsmorcFacet.hasOsmorcFacet((PsiElement)tag) && (dependency = NonOsgiMavenDependencyInspection.getDependency(tag)) != null && !"test".equals(scope = dependency.getScope().getStringValue()) && (artifactFile = MavenArtifactUtil.getArtifactFile((File)(repo = MavenProjectsManager.getInstance((Project)tag.getProject()).getLocalRepository()), (String)(groupId = dependency.getGroupId().getStringValue()), (String)(artifactId = dependency.getArtifactId().getStringValue()), (String)(version = dependency.getVersion().getStringValue()), (String)"jar")).exists() && !CachingBundleInfoProvider.isBundle((String)artifactFile.getPath())) {
                    problemsHolder.registerProblem((PsiElement)tag, OsmorcBundle.message("NonOsgiMavenDependencyInspection.message", new Object[0]), new LocalQuickFix[]{new FindOsgiCapableMavenDependencyQuickFix()});
                }
            }
        };
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/maven/inspection/NonOsgiMavenDependencyInspection", "buildVisitor"));
        }
        return object;
    }

    private static MavenDomDependency getDependency(XmlTag tag) {
        DomElement dom;
        PsiElement grand;
        PsiElement parent;
        if (!(!"dependency".equals(tag.getName()) || (parent = tag.getParent()) == null || (grand = parent.getParent()) instanceof XmlTag && "plugin".equals(((XmlTag)grand).getName()) || (dom = DomManager.getDomManager((Project)tag.getProject()).getDomElement(tag)) == null)) {
            return (MavenDomDependency)dom.getParentOfType(MavenDomDependency.class, false);
        }
        return null;
    }

    private static class FindOsgiCapableMavenDependencyQuickFix
    extends AbstractOsgiQuickFix {
        private FindOsgiCapableMavenDependencyQuickFix() {
        }

        @NotNull
        public String getName() {
            String string = OsmorcBundle.message("NonOsgiMavenDependencyInspection.fix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/maven/inspection/NonOsgiMavenDependencyInspection$FindOsgiCapableMavenDependencyQuickFix", "getName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor problemDescriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/osmorc/maven/inspection/NonOsgiMavenDependencyInspection$FindOsgiCapableMavenDependencyQuickFix", "applyFix"));
            }
            if (problemDescriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problemDescriptor", "org/osmorc/maven/inspection/NonOsgiMavenDependencyInspection$FindOsgiCapableMavenDependencyQuickFix", "applyFix"));
            }
            final MavenDomDependency dependency = NonOsgiMavenDependencyInspection.getDependency((XmlTag)problemDescriptor.getPsiElement());
            if (dependency == null) {
                return;
            }
            final ObrMavenResult result = ObrSearchDialog.queryForMavenArtifact(project, dependency.getArtifactId().toString());
            if (result == null) {
                return;
            }
            final PsiFile psiFile = problemDescriptor.getPsiElement().getContainingFile();
            new WriteCommandAction(project, new PsiFile[]{psiFile}){

                protected void run(@NotNull Result _result) throws Throwable {
                    if (_result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_result", "org/osmorc/maven/inspection/NonOsgiMavenDependencyInspection$FindOsgiCapableMavenDependencyQuickFix$1", "run"));
                    }
                    MavenDomProjectModel model = MavenDomUtil.getMavenDomProjectModel((Project)this.getProject(), (VirtualFile)psiFile.getVirtualFile());
                    if (model == null) {
                        return;
                    }
                    MavenDomDependency dummy = model.getDependencies().addDependency();
                    dummy.getGroupId().setStringValue(result.getGroupId());
                    dummy.getArtifactId().setStringValue(result.getArtifactId());
                    dummy.getVersion().setStringValue(result.getVersion());
                    String scope = dependency.getScope().getStringValue();
                    if (!StringUtil.isEmpty((String)scope)) {
                        dummy.getScope().setStringValue(scope);
                    }
                    XmlElement newDep = dummy.getXmlElement();
                    XmlElement oldDep = dependency.getXmlElement();
                    assert (newDep != null) : dummy;
                    assert (oldDep != null) : dependency;
                    oldDep.replace(newDep.copy());
                    newDep.delete();
                    Set projectRepositoryUrls = ContainerUtil.map2Set((Collection)model.getRepositories().getRepositories(), repository -> repository.getUrl().getStringValue());
                    List newRepositories = ContainerUtil.newSmartList((Object[])result.getBundleRepository().getMavenRepositories());
                    Iterator i = newRepositories.iterator();
                    while (i.hasNext()) {
                        MavenRepository repository2 = (MavenRepository)i.next();
                        if (!projectRepositoryUrls.contains(repository2.getRepositoryUrl())) continue;
                        i.remove();
                    }
                    for (MavenRepository repository2 : newRepositories) {
                        MavenDomRepository added = model.getRepositories().addRepository();
                        added.getId().setStringValue(repository2.getRepositoryId());
                        added.getUrl().setStringValue(repository2.getRepositoryUrl());
                        added.getName().setStringValue(repository2.getRepositoryDescription());
                    }
                }
            }.execute();
        }
    }
}

