/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ITaskStackListener
extends IInterface {
    public void onTaskStackChanged() throws RemoteException;

    public void onActivityPinned() throws RemoteException;

    public void onPinnedActivityRestartAttempt() throws RemoteException;

    public void onPinnedStackAnimationEnded() throws RemoteException;

    public void onActivityForcedResizable(String var1, int var2) throws RemoteException;

    public void onActivityDismissingDockedStack() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ITaskStackListener {
        private static final String DESCRIPTOR = "android.app.ITaskStackListener";
        static final int TRANSACTION_onTaskStackChanged = 1;
        static final int TRANSACTION_onActivityPinned = 2;
        static final int TRANSACTION_onPinnedActivityRestartAttempt = 3;
        static final int TRANSACTION_onPinnedStackAnimationEnded = 4;
        static final int TRANSACTION_onActivityForcedResizable = 5;
        static final int TRANSACTION_onActivityDismissingDockedStack = 6;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ITaskStackListener asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ITaskStackListener) {
                return (ITaskStackListener)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            switch (code) {
                case 1598968902: {
                    reply.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    data.enforceInterface(DESCRIPTOR);
                    this.onTaskStackChanged();
                    return true;
                }
                case 2: {
                    data.enforceInterface(DESCRIPTOR);
                    this.onActivityPinned();
                    return true;
                }
                case 3: {
                    data.enforceInterface(DESCRIPTOR);
                    this.onPinnedActivityRestartAttempt();
                    return true;
                }
                case 4: {
                    data.enforceInterface(DESCRIPTOR);
                    this.onPinnedStackAnimationEnded();
                    return true;
                }
                case 5: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    this.onActivityForcedResizable(_arg0, _arg1);
                    return true;
                }
                case 6: {
                    data.enforceInterface(DESCRIPTOR);
                    this.onActivityDismissingDockedStack();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        private static class Proxy
        implements ITaskStackListener {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            @Override
            public void onTaskStackChanged() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onActivityPinned() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onPinnedActivityRestartAttempt() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onPinnedStackAnimationEnded() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onActivityForcedResizable(String packageName, int taskId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(taskId);
                    this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onActivityDismissingDockedStack() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }
}

