/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.net.wifi.WifiNetworkConnectionStatistics;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import java.util.HashMap;

public class WifiConnectionStatistics
implements Parcelable {
    private static final String TAG = "WifiConnnectionStatistics";
    public HashMap<String, WifiNetworkConnectionStatistics> untrustedNetworkHistory = new HashMap();
    public int num5GhzConnected;
    public int num24GhzConnected;
    public int numAutoJoinAttempt;
    public int numAutoRoamAttempt;
    public int numWifiManagerJoinAttempt;
    public static final Parcelable.Creator<WifiConnectionStatistics> CREATOR = new Parcelable.Creator<WifiConnectionStatistics>(){

        @Override
        public WifiConnectionStatistics createFromParcel(Parcel in) {
            WifiConnectionStatistics stats = new WifiConnectionStatistics();
            stats.num24GhzConnected = in.readInt();
            stats.num5GhzConnected = in.readInt();
            stats.numAutoJoinAttempt = in.readInt();
            stats.numAutoRoamAttempt = in.readInt();
            stats.numWifiManagerJoinAttempt = in.readInt();
            int n = in.readInt();
            while (n-- > 0) {
                String Key2 = in.readString();
                int numConnection = in.readInt();
                int numUsage = in.readInt();
                WifiNetworkConnectionStatistics st = new WifiNetworkConnectionStatistics(numConnection, numUsage);
                stats.untrustedNetworkHistory.put(Key2, st);
            }
            return stats;
        }

        public WifiConnectionStatistics[] newArray(int size) {
            return new WifiConnectionStatistics[size];
        }
    };

    public WifiConnectionStatistics() {
    }

    public void incrementOrAddUntrusted(String SSID, int connection, int usage) {
        WifiNetworkConnectionStatistics stats;
        if (TextUtils.isEmpty(SSID)) {
            return;
        }
        if (this.untrustedNetworkHistory.containsKey(SSID)) {
            stats = this.untrustedNetworkHistory.get(SSID);
            if (stats != null) {
                stats.numConnection = connection + stats.numConnection;
                stats.numUsage = usage + stats.numUsage;
            }
        } else {
            stats = new WifiNetworkConnectionStatistics(connection, usage);
        }
        if (stats != null) {
            this.untrustedNetworkHistory.put(SSID, stats);
        }
    }

    public String toString() {
        StringBuilder sbuf = new StringBuilder();
        sbuf.append("Connected on: 2.4Ghz=").append(this.num24GhzConnected);
        sbuf.append(" 5Ghz=").append(this.num5GhzConnected).append("\n");
        sbuf.append(" join=").append(this.numWifiManagerJoinAttempt);
        sbuf.append("\\").append(this.numAutoJoinAttempt).append("\n");
        sbuf.append(" roam=").append(this.numAutoRoamAttempt).append("\n");
        for (String Key2 : this.untrustedNetworkHistory.keySet()) {
            WifiNetworkConnectionStatistics stats = this.untrustedNetworkHistory.get(Key2);
            if (stats == null) continue;
            sbuf.append(Key2).append(" ").append(stats.toString()).append("\n");
        }
        return sbuf.toString();
    }

    public WifiConnectionStatistics(WifiConnectionStatistics source) {
        if (source != null) {
            this.untrustedNetworkHistory.putAll(source.untrustedNetworkHistory);
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.num24GhzConnected);
        dest.writeInt(this.num5GhzConnected);
        dest.writeInt(this.numAutoJoinAttempt);
        dest.writeInt(this.numAutoRoamAttempt);
        dest.writeInt(this.numWifiManagerJoinAttempt);
        dest.writeInt(this.untrustedNetworkHistory.size());
        for (String Key2 : this.untrustedNetworkHistory.keySet()) {
            WifiNetworkConnectionStatistics num = this.untrustedNetworkHistory.get(Key2);
            dest.writeString(Key2);
            dest.writeInt(num.numConnection);
            dest.writeInt(num.numUsage);
        }
    }
}

