/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.CanvasProperty;
import android.graphics.Paint;
import android.util.Pools;
import android.view.HardwareLayer;
import android.view.RenderNode;
import com.android.tools.layoutlib.create.OverrideMethod;

public class DisplayListCanvas
extends Canvas {
    private static final int POOL_LIMIT = 25;
    private static final int MAX_BITMAP_SIZE = 0x6400000;
    private static final Pools.SynchronizedPool<DisplayListCanvas> sPool = new Pools.SynchronizedPool(25);
    RenderNode mNode;
    private int mWidth;
    private int mHeight;
    private static boolean sIsAvailable = DisplayListCanvas.nIsAvailable();

    static DisplayListCanvas obtain(RenderNode node, int width, int height) {
        if (node == null) {
            throw new IllegalArgumentException("node cannot be null");
        }
        DisplayListCanvas canvas = sPool.acquire();
        if (canvas == null) {
            canvas = new DisplayListCanvas(width, height);
        } else {
            DisplayListCanvas.nResetDisplayListCanvas(canvas.mNativeCanvasWrapper, width, height);
        }
        canvas.mNode = node;
        canvas.mWidth = width;
        canvas.mHeight = height;
        return canvas;
    }

    void recycle() {
        this.mNode = null;
        sPool.release(this);
    }

    long finishRecording() {
        return DisplayListCanvas.nFinishRecording(this.mNativeCanvasWrapper);
    }

    @Override
    public boolean isRecordingFor(Object o) {
        return o == this.mNode;
    }

    private static boolean nIsAvailable() {
        return OverrideMethod.invokeI("android.view.DisplayListCanvas#nIsAvailable()Z", true, null) != 0;
    }

    static boolean isAvailable() {
        return sIsAvailable;
    }

    private DisplayListCanvas(int width, int height) {
        super(DisplayListCanvas.nCreateDisplayListCanvas(width, height));
        this.mDensity = 0;
    }

    private static long nCreateDisplayListCanvas(int n, int n2) {
        return OverrideMethod.invokeL("android.view.DisplayListCanvas#nCreateDisplayListCanvas(II)J", true, null);
    }

    private static void nResetDisplayListCanvas(long l, int n, int n2) {
        OverrideMethod.invokeV("android.view.DisplayListCanvas#nResetDisplayListCanvas(JII)V", true, null);
    }

    @Override
    public void setDensity(int density) {
    }

    @Override
    public boolean isHardwareAccelerated() {
        return true;
    }

    @Override
    public void setBitmap(Bitmap bitmap) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isOpaque() {
        return false;
    }

    @Override
    public int getWidth() {
        return this.mWidth;
    }

    @Override
    public int getHeight() {
        return this.mHeight;
    }

    @Override
    public int getMaximumBitmapWidth() {
        return DisplayListCanvas.nGetMaximumTextureWidth();
    }

    @Override
    public int getMaximumBitmapHeight() {
        return DisplayListCanvas.nGetMaximumTextureHeight();
    }

    private static int nGetMaximumTextureWidth() {
        return OverrideMethod.invokeI("android.view.DisplayListCanvas#nGetMaximumTextureWidth()I", true, null);
    }

    private static int nGetMaximumTextureHeight() {
        return OverrideMethod.invokeI("android.view.DisplayListCanvas#nGetMaximumTextureHeight()I", true, null);
    }

    @Override
    public void insertReorderBarrier() {
        DisplayListCanvas.nInsertReorderBarrier(this.mNativeCanvasWrapper, true);
    }

    @Override
    public void insertInorderBarrier() {
        DisplayListCanvas.nInsertReorderBarrier(this.mNativeCanvasWrapper, false);
    }

    private static void nInsertReorderBarrier(long l, boolean bl) {
        OverrideMethod.invokeV("android.view.DisplayListCanvas#nInsertReorderBarrier(JZ)V", true, null);
    }

    public void callDrawGLFunction2(long drawGLFunction) {
        DisplayListCanvas.nCallDrawGLFunction(this.mNativeCanvasWrapper, drawGLFunction, null);
    }

    public void drawGLFunctor2(long drawGLFunctor, Runnable releasedCallback) {
        DisplayListCanvas.nCallDrawGLFunction(this.mNativeCanvasWrapper, drawGLFunctor, releasedCallback);
    }

    private static void nCallDrawGLFunction(long l, long l2, Runnable runnable) {
        OverrideMethod.invokeV("android.view.DisplayListCanvas#nCallDrawGLFunction(JJLjava/lang/Runnable;)V", true, null);
    }

    protected static long nFinishRecording(long l) {
        return OverrideMethod.invokeL("android.view.DisplayListCanvas#nFinishRecording(J)J", true, null);
    }

    public void drawRenderNode(RenderNode renderNode) {
        DisplayListCanvas.nDrawRenderNode(this.mNativeCanvasWrapper, renderNode.getNativeDisplayList());
    }

    private static void nDrawRenderNode(long l, long l2) {
        OverrideMethod.invokeV("android.view.DisplayListCanvas#nDrawRenderNode(JJ)V", true, null);
    }

    void drawHardwareLayer(HardwareLayer layer) {
        DisplayListCanvas.nDrawLayer(this.mNativeCanvasWrapper, layer.getLayerHandle());
    }

    private static void nDrawLayer(long l, long l2) {
        OverrideMethod.invokeV("android.view.DisplayListCanvas#nDrawLayer(JJ)V", true, null);
    }

    public void drawCircle(CanvasProperty<Float> cx, CanvasProperty<Float> cy, CanvasProperty<Float> radius, CanvasProperty<Paint> paint) {
        DisplayListCanvas.nDrawCircle(this.mNativeCanvasWrapper, cx.getNativeContainer(), cy.getNativeContainer(), radius.getNativeContainer(), paint.getNativeContainer());
    }

    private static void nDrawCircle(long l, long l2, long l3, long l4, long l5) {
        OverrideMethod.invokeV("android.view.DisplayListCanvas#nDrawCircle(JJJJJ)V", true, null);
    }

    public void drawRoundRect(CanvasProperty<Float> left, CanvasProperty<Float> top, CanvasProperty<Float> right, CanvasProperty<Float> bottom, CanvasProperty<Float> rx, CanvasProperty<Float> ry, CanvasProperty<Paint> paint) {
        DisplayListCanvas.nDrawRoundRect(this.mNativeCanvasWrapper, left.getNativeContainer(), top.getNativeContainer(), right.getNativeContainer(), bottom.getNativeContainer(), rx.getNativeContainer(), ry.getNativeContainer(), paint.getNativeContainer());
    }

    private static void nDrawRoundRect(long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8) {
        OverrideMethod.invokeV("android.view.DisplayListCanvas#nDrawRoundRect(JJJJJJJJ)V", true, null);
    }

    @Override
    protected void throwIfCannotDraw(Bitmap bitmap) {
        super.throwIfCannotDraw(bitmap);
        int bitmapSize = bitmap.getByteCount();
        if (bitmapSize > 0x6400000) {
            throw new RuntimeException("Canvas: trying to draw too large(" + bitmapSize + "bytes) bitmap.");
        }
    }
}

