/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.persistence.integration.hibernate;

import com.intellij.hibernate.facet.HibernateFacet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.persistence.PersistenceHelper;
import com.intellij.persistence.model.manipulators.AbstractPersistenceManipulator;
import com.intellij.persistence.model.manipulators.ManipulatorsRegistry;
import com.intellij.persistence.model.manipulators.PersistenceAction;
import com.intellij.persistence.model.manipulators.PersistenceFacetManipulator;
import com.intellij.persistence.model.manipulators.PersistenceManipulator;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.contexts.model.XmlSpringModel;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class HibernateFacetManipulator
extends AbstractPersistenceManipulator<HibernateFacet>
implements PersistenceFacetManipulator<HibernateFacet> {
    public HibernateFacetManipulator(HibernateFacet target) {
        super((Object)target);
    }

    public List<PersistenceAction> getCreateActions() {
        Module module = ((HibernateFacet)this.getManipulatorTarget()).getModule();
        THashSet files = new THashSet();
        for (SpringModel springModel : SpringManager.getInstance((Project)module.getProject()).getAllModels(module)) {
            if (!(springModel instanceof XmlSpringModel)) continue;
            files.addAll((Collection)((XmlSpringModel)springModel).getXmlConfigFiles());
        }
        ArrayList<PersistenceAction> result = new ArrayList<PersistenceAction>();
        ManipulatorsRegistry manipulatorsRegistry = PersistenceHelper.getHelper().getManipulatorsRegistry();
        for (XmlFile file : files) {
            Class<PersistenceManipulator> aClass;
            DomElement element;
            PersistenceManipulator manipulator;
            DomFileElement fileElement = SpringDomUtils.getSpringDomFileElement((XmlFile)file);
            if (fileElement == null || (manipulator = manipulatorsRegistry.getManipulator((Object)(element = fileElement.getRootElement()), aClass = PersistenceManipulator.class)) == null) continue;
            result.addAll(manipulator.getCreateActions());
        }
        return result;
    }
}

