/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.parsing;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lang.properties.parsing.PropertiesElementTypes;
import com.intellij.lang.properties.parsing.PropertiesLexer;
import com.intellij.lang.properties.parsing.PropertiesParser;
import com.intellij.lang.properties.parsing.PropertiesTokenTypes;
import com.intellij.lang.properties.psi.impl.PropertiesFileImpl;
import com.intellij.lang.properties.psi.impl.PropertiesListImpl;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;

public class PropertiesParserDefinition
implements ParserDefinition {
    @NotNull
    public Lexer createLexer(Project project) {
        PropertiesLexer propertiesLexer = new PropertiesLexer();
        if (propertiesLexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/parsing/PropertiesParserDefinition", "createLexer"));
        }
        return propertiesLexer;
    }

    public IFileElementType getFileNodeType() {
        return PropertiesElementTypes.FILE;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = PropertiesTokenTypes.WHITESPACES;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/parsing/PropertiesParserDefinition", "getWhitespaceTokens"));
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = PropertiesTokenTypes.COMMENTS;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/parsing/PropertiesParserDefinition", "getCommentTokens"));
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = TokenSet.EMPTY;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/parsing/PropertiesParserDefinition", "getStringLiteralElements"));
        }
        return tokenSet;
    }

    @NotNull
    public PsiParser createParser(Project project) {
        PropertiesParser propertiesParser = new PropertiesParser();
        if (propertiesParser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/parsing/PropertiesParserDefinition", "createParser"));
        }
        return propertiesParser;
    }

    public PsiFile createFile(FileViewProvider viewProvider) {
        return new PropertiesFileImpl(viewProvider);
    }

    public ParserDefinition.SpaceRequirements spaceExistanceTypeBetweenTokens(ASTNode left, ASTNode right) {
        return ParserDefinition.SpaceRequirements.MAY;
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        IElementType type = node.getElementType();
        if (type == PropertiesElementTypes.PROPERTY) {
            PropertyImpl propertyImpl = new PropertyImpl(node);
            if (propertyImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/parsing/PropertiesParserDefinition", "createElement"));
            }
            return propertyImpl;
        }
        if (type == PropertiesElementTypes.PROPERTIES_LIST) {
            PropertiesListImpl propertiesListImpl = new PropertiesListImpl(node);
            if (propertiesListImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/parsing/PropertiesParserDefinition", "createElement"));
            }
            return propertiesListImpl;
        }
        throw new AssertionError((Object)("Alien element type [" + type + "]. Can't create Property PsiElement for that."));
    }
}

