/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.openshift.cloud;

import com.intellij.javaee.openshift.cloud.OS3ServerRuntimeInstance;
import com.intellij.javaee.openshift.cloud.OSCloudConfiguration;
import com.intellij.javaee.openshift.cloud.OSDeploymentConfiguration;
import com.intellij.javaee.openshift.cloud.OSServerRuntimeInstance;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.runtime.ServerConnector;
import com.intellij.remoteServer.runtime.ServerTaskExecutor;
import com.intellij.remoteServer.runtime.clientLibrary.ClientLibraryDescription;
import com.intellij.remoteServer.runtime.clientLibrary.ClientLibraryManager;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OSConnector
extends ServerConnector<OSDeploymentConfiguration> {
    private static final Logger LOG = Logger.getInstance((String)("#" + OSConnector.class.getName()));
    private final RemoteServer<OSCloudConfiguration> myServer;
    private final ServerTaskExecutor myTasksExecutor;

    public OSConnector(RemoteServer<OSCloudConfiguration> server, ServerTaskExecutor tasksExecutor) {
        this.myServer = server;
        this.myTasksExecutor = tasksExecutor;
    }

    public void connect(@NotNull ServerConnector.ConnectionCallback<OSDeploymentConfiguration> callback) {
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/javaee/openshift/cloud/OSConnector", "connect"));
        }
        this.myTasksExecutor.submit(() -> {
            List clientLibrary;
            if (callback == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/javaee/openshift/cloud/OSConnector", "lambda$connect$0"));
            }
            try {
                ClientLibraryDescription libraryDescription = ((OSCloudConfiguration)this.myServer.getConfiguration()).getVersion().getLibraryDescription();
                clientLibrary = ClientLibraryManager.getInstance().download(libraryDescription);
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                callback.errorOccurred("Failed to download client libraries: " + e.getMessage());
                return;
            }
            if (((OSCloudConfiguration)this.myServer.getConfiguration()).isOS3()) {
                new OS3ServerRuntimeInstance(this.myServer, this.myTasksExecutor, clientLibrary).connect(callback);
            } else {
                new OSServerRuntimeInstance(this.myServer, this.myTasksExecutor, clientLibrary).connect(callback);
            }
        }, callback);
    }
}

