/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.openshift.cloud.action;

import com.intellij.icons.AllIcons;
import com.intellij.javaee.openshift.agent.cloud.os3.OS3ProjectRequestConfigImpl;
import com.intellij.javaee.openshift.cloud.OS3ServerRuntimeInstance;
import com.intellij.javaee.openshift.cloud.OSBundle;
import com.intellij.javaee.openshift.cloud.OSCloudConfiguration;
import com.intellij.javaee.openshift.cloud.action.CreateProjectConfigurable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.remoteServer.impl.runtime.ui.ServersToolWindowContent;
import com.intellij.remoteServer.impl.runtime.ui.tree.ServersTreeStructure;
import com.intellij.remoteServer.impl.runtime.ui.tree.actions.ServersTreeAction;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.remoteServer.runtime.ServerConnectionManager;
import com.intellij.remoteServer.runtime.ServerConnector;
import com.intellij.remoteServer.runtime.deployment.ServerRuntimeInstance;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;

public class CreateProjectAction
extends ServersTreeAction<ServersTreeStructure.RemoteServerNode> {
    public CreateProjectAction() {
        super(OSBundle.getText("OS3.action.createProject.title", new Object[0]), OSBundle.getText("OS3.action.createProject.description", new Object[0]), AllIcons.General.Add);
    }

    protected Class<ServersTreeStructure.RemoteServerNode> getTargetNodeClass() {
        return ServersTreeStructure.RemoteServerNode.class;
    }

    protected boolean isEnabled4(ServersTreeStructure.RemoteServerNode node) {
        return node.isConnected();
    }

    protected void doActionPerformed(final @NotNull ServersToolWindowContent content, AnActionEvent e, ServersTreeStructure.RemoteServerNode node) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/javaee/openshift/cloud/action/CreateProjectAction", "doActionPerformed"));
        }
        ServerConnection connection = ServerConnectionManager.getInstance().getConnection(node.getServer());
        if (connection == null) {
            return;
        }
        connection.connectIfNeeded(new ServerConnector.ConnectionCallback(){

            public void connected(@NotNull ServerRuntimeInstance serverRuntimeInstance) {
                if (serverRuntimeInstance == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverRuntimeInstance", "com/intellij/javaee/openshift/cloud/action/CreateProjectAction$1", "connected"));
                }
                OS3ProjectRequestConfigImpl requestConfig = new OS3ProjectRequestConfigImpl();
                if (!ShowSettingsUtil.getInstance().editConfigurable(content.getProject(), (Configurable)new CreateProjectConfigurable(requestConfig))) {
                    return;
                }
                ((OS3ServerRuntimeInstance)serverRuntimeInstance).createProject(requestConfig);
            }

            public void errorOccurred(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/javaee/openshift/cloud/action/CreateProjectAction$1", "errorOccurred"));
                }
            }
        });
    }

    protected boolean isVisible4(ServersTreeStructure.RemoteServerNode node) {
        OSCloudConfiguration config = (OSCloudConfiguration)ObjectUtils.tryCast((Object)node.getServer().getConfiguration(), OSCloudConfiguration.class);
        return config != null && config.isOS3();
    }
}

