/*
 * Decompiled with CFR 0.152.
 */
package git4idea.log;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import git4idea.GitVcs;
import git4idea.i18n.GitBundle;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitShowCommitInLogAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance(GitShowCommitInLogAction.class);

    public GitShowCommitInLogAction() {
        super(GitBundle.getString("vcs.history.action.gitlog"));
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        VcsLog log;
        Content[] contents;
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "git4idea/log/GitShowCommitInLogAction", "actionPerformed"));
        }
        final Project project = (Project)event.getRequiredData(CommonDataKeys.PROJECT);
        final VcsRevisionNumber revision = this.getRevisionNumber(event);
        if (revision == null) {
            return;
        }
        boolean logReady = GitShowCommitInLogAction.findLog(project) != null;
        final ToolWindow window = ToolWindowManager.getInstance((Project)project).getToolWindow(ChangesViewContentManager.TOOLWINDOW_ID);
        ContentManager cm = window.getContentManager();
        for (Content content : contents = cm.getContents()) {
            if (!"Log".equals(content.getDisplayName())) continue;
            cm.setSelectedContent(content);
            break;
        }
        if ((log = GitShowCommitInLogAction.findLog(project)) == null) {
            GitShowCommitInLogAction.showLogNotReadyMessage(project);
            return;
        }
        Runnable selectAndOpenLog = new Runnable(){

            @Override
            public void run() {
                Runnable selectCommit = new Runnable(){

                    @Override
                    public void run() {
                        GitShowCommitInLogAction.jumpToRevisionUnderProgress(project, log, revision);
                    }
                };
                if (!window.isVisible()) {
                    window.activate(selectCommit, true);
                } else {
                    selectCommit.run();
                }
            }
        };
        if (logReady) {
            selectAndOpenLog.run();
            return;
        }
        VcsProjectLog projectLog = VcsProjectLog.getInstance((Project)project);
        if (projectLog == null) {
            GitShowCommitInLogAction.showLogNotReadyMessage(project);
            return;
        }
        VcsLogUiImpl logUi = projectLog.getMainLogUi();
        if (logUi == null) {
            GitShowCommitInLogAction.showLogNotReadyMessage(project);
            return;
        }
        logUi.invokeOnChange(selectAndOpenLog);
    }

    private static void showLogNotReadyMessage(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/log/GitShowCommitInLogAction", "showLogNotReadyMessage"));
        }
        VcsBalloonProblemNotifier.showOverChangesView((Project)project, (String)GitBundle.getString("vcs.history.action.gitlog.error"), (MessageType)MessageType.WARNING, (NamedRunnable[])new NamedRunnable[0]);
    }

    @Nullable
    protected VcsRevisionNumber getRevisionNumber(@NotNull AnActionEvent event) {
        VcsFileRevision fileRevision;
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "git4idea/log/GitShowCommitInLogAction", "getRevisionNumber"));
        }
        VcsRevisionNumber revision = (VcsRevisionNumber)event.getData(VcsDataKeys.VCS_REVISION_NUMBER);
        if (revision == null && (fileRevision = (VcsFileRevision)event.getData(VcsDataKeys.VCS_FILE_REVISION)) != null) {
            revision = fileRevision.getRevisionNumber();
        }
        return revision;
    }

    @Nullable
    protected VcsKey getVcsKey(@NotNull AnActionEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "git4idea/log/GitShowCommitInLogAction", "getVcsKey"));
        }
        return (VcsKey)event.getData(VcsDataKeys.VCS);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "git4idea/log/GitShowCommitInLogAction", "update"));
        }
        super.update(e);
        Project project = e.getProject();
        e.getPresentation().setEnabled(project != null && VcsProjectLog.getInstance((Project)project) != null && this.getRevisionNumber(e) != null && Comparing.equal((Object)this.getVcsKey(e), (Object)GitVcs.getKey()));
    }

    @Nullable
    private static VcsLog findLog(@NotNull Project project) {
        VcsLogUiImpl ui;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/log/GitShowCommitInLogAction", "findLog"));
        }
        VcsProjectLog projectLog = VcsProjectLog.getInstance((Project)project);
        if (projectLog != null && (ui = projectLog.getMainLogUi()) != null) {
            return ui.getVcsLog();
        }
        return null;
    }

    private static void jumpToRevisionUnderProgress(@NotNull Project project, @NotNull VcsLog log, @NotNull VcsRevisionNumber revision) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/log/GitShowCommitInLogAction", "jumpToRevisionUnderProgress"));
        }
        if (log == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "log", "git4idea/log/GitShowCommitInLogAction", "jumpToRevisionUnderProgress"));
        }
        if (revision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "git4idea/log/GitShowCommitInLogAction", "jumpToRevisionUnderProgress"));
        }
        final Future future = log.jumpToReference(revision.asString());
        if (!future.isDone()) {
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, "Searching for revision " + revision.asString(), false, PerformInBackgroundOption.ALWAYS_BACKGROUND){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/log/GitShowCommitInLogAction$2", "run"));
                    }
                    try {
                        future.get();
                    }
                    catch (CancellationException cancellationException) {
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (ExecutionException e) {
                        LOG.error((Throwable)e);
                    }
                }
            });
        }
    }
}

